/**
 * Copyright PESakaTFM ( http://wonderfl.net/user/PESakaTFM )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/acIO
 */

// forked from sofe's ellipse rotate
//ellipse rotate
/**
Added the ability to hold 2 (non-conflicting) keys at once.
mouse press : draw
↑：ellipse size up
↓：ellipse size down
→：radius up
←：radius down
**/
 
package
{
    import flash.text.Font;
    import flash.display.*;
    import flash.events.*;
    import flash.ui.*;
    import flash.net.*;
    import flash.geom.*;
    import flash.system.*;
 
    public class Main extends Sprite
    {
        private var isUpDown:Boolean = false;
        private var isLeftDown:Boolean = false;
        private var isDownDown:Boolean = false;
        private var isRightDown:Boolean = false;
        private var isMouseDown:Boolean = false;
        
        private var mySprite:Sprite = new Sprite();
        private var myGraphics:Graphics = mySprite.graphics;
        private  var nThickness:Number = 1;
        private var nColor:uint = 0x000000;
        private var nAlpha:Number = 1.0;
        private var nPixcelHinting:Boolean = true;
        private var nFill:uint = 0x000000;
        private var nX:Number;
        private var nY:Number;
        private var radius:Number = 10;
        private var nSinX:int = 0;
        private var nCosY:int = 0;
        private var nDi:int = 20;
        private var nAngle:int = 10; 
        
        private const WIDTH:int = 500;
        private const HEIGHT:int = 500;
        private var url:String = "http://assets.wonderfl.net/images/related_images/7/7c/7c39/7c390c254a3528f15f927c059cdb9bccb3438544";
        private var bd:BitmapData = new BitmapData(WIDTH, HEIGHT); 
 
        public function Main(){                        
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.INIT, initHandler);    
            loader.load(new URLRequest(url), new LoaderContext(true)); 
        }
        
        private function Loop(event:Event):void
        {
            if(isMouseDown)
                xDrawEllipse();
            
            if(radius < 50 && isUpDown)
            {
                radius += .5;
            }
            else if(radius > 1  && isDownDown)
            {
                radius -= .5;
            }
            if(nDi < 450 && isRightDown)
                nDi += 1;
            else if(nDi > 1 && isLeftDown)
                nDi -= 1;
        }

        private function initHandler(event:Event):void{
            var loader:Loader = event.currentTarget.loader;
            var matrix:Matrix = new Matrix();
            matrix.scale(WIDTH / loader.width, HEIGHT / loader.height); 
            bd.draw(loader);
            matrix = new Matrix();
            var destbd:BitmapData = new BitmapData(bd.width, bd.height);
            destbd.draw(bd);
            addChild(new Bitmap(destbd));
            addChild(mySprite);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, xBeginEllipse);
            stage.addEventListener(MouseEvent.MOUSE_UP, xEndEllipse);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, KeyDownFunc);
            stage.addEventListener(KeyboardEvent.KEY_UP, KeyUpFunc);
            stage.addEventListener(Event.ENTER_FRAME, Loop);   
        }
       
       private  function xBeginEllipse(eventObject:MouseEvent):void{   
            myGraphics.lineStyle(nThickness, nColor, nAlpha, nPixcelHinting);    
            nX = mouseX;
            nY = mouseY;
            isMouseDown = true;
        } 
        
        private function xEndEllipse(eventObject:MouseEvent):void{
            myGraphics.endFill();
            isMouseDown = false;
        }
        
         private function xDrawEllipse():void{          
            var nDiX:Number =  Math.sin(nSinX*(Math.PI/180))*nDi;
            var nDiY:Number = Math.cos(nCosY*(Math.PI/180))*nDi;  
            var posX:int = mouseX - radius / 2 + nDiX;
            var posY:int = mouseY - radius / 2 + nDiY;        
            var pixelValue:uint  = bd.getPixel(posX <= 0? 1 : posX, posY <= 0? 1 : posY);
            nFill = pixelValue;   
            myGraphics.beginFill(nFill); 
            myGraphics.drawCircle(posX, posY, radius);            
            nSinX += nAngle;
            nCosY += nAngle;
        } 
        
        private function KeyDownFunc(event:KeyboardEvent):void{
            if(event.keyCode == Keyboard.UP)
                isUpDown = true;
            if(event.keyCode == Keyboard.DOWN)
                isDownDown = true;
            if(event.keyCode == Keyboard.RIGHT)
                isRightDown = true;
            if(event.keyCode == Keyboard.LEFT)
                isLeftDown = true;
        }    
        
        private function KeyUpFunc(event:KeyboardEvent):void{
            if(event.keyCode == Keyboard.UP)
                isUpDown = false;
            if(event.keyCode == Keyboard.DOWN)
                isDownDown = false;
            if(event.keyCode == Keyboard.RIGHT)
                isRightDown = false;
            if(event.keyCode == Keyboard.LEFT)
                isLeftDown = false;
        }    
    }    
}