/**
 * Copyright Robbie.Maglone ( http://wonderfl.net/user/Robbie.Maglone )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/abhz9
 */

// forked from spanvega's MINIMAL
package
{
    /*
    * HIT SPACE BAR TO UPLOAD A TRACK
    * CLICK TO GENERATE ANOTHER FORM
    */

    import flash.geom.Point;
    import flash.geom.Matrix;
    import flash.geom.Matrix3D;
    import flash.geom.Vector3D;
    import flash.geom.ColorTransform;
    import flash.geom.PerspectiveProjection;

    import flash.media.Sound;
    import flash.media.ID3Info;
    import flash.media.SoundMixer;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;

    import flash.utils.ByteArray;

    import flash.net.URLRequest;
    import flash.net.FileFilter;
    import flash.net.FileReference;

    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.display.BitmapData;
   
    import flash.text.TextField;

    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.IOErrorEvent;
    import flash.events.KeyboardEvent;
    import flash.events.ProgressEvent;
    import flash.events.SecurityErrorEvent;
    
    import frocessing.color.ColorHSV;

    [ SWF (width = '465', height = '465', backgroundColor = '0x000000', frameRate = '25')]

    /**
    *    @author SPANVEGA // CHRISTIAN //
    **/

    public class MINIMAL extends Sprite
    {
        private var color : ColorHSV = new ColorHSV (Math.random() * 360);

        private var q_prp : PerspectiveProjection;
        private var q_vec : Vector.<QUAD>;
        private var q_arr : Vector.<uint>;
        private var q_m3d : Matrix3D;
        private var q_v3d : Vector3D;

        private var q_pad : uint = 110;
        private var q_num : uint = 128;
        private var q_siz : uint = 55;
        private var q_mvd : int;
        private var q_rot : int;

        private var d_ct : ColorTransform;
        private var d_mt : Matrix;

        private var data : BitmapData;
        private var hold : Sprite;

        private var stageW : uint;
        private var stageH : uint;

        // --o SOUND DERIVED PROPERTIES

        private var track : String = 'http://caster.fnshosting.com:4143/live';
        private var bytes : ByteArray = new ByteArray ();

        private var sLoad : FileReference;
        private var sChan : SoundChannel;
        private var lPeak : Number;
        private var rPeak : Number;
        private var sTags : String;
        private var sound : Sound;

        private var gLoad : GRAPHIC_BAR;
        private var lChan : GRAPHIC_BAR;
        private var rChan : GRAPHIC_BAR;
        private var infos : TextField;
        private var plays : TextField;


        public function MINIMAL ()
        {
            Wonderfl.disable_capture();

            stage ? init () : addEventListener (Event.ADDED_TO_STAGE, init);
        }

        private function init () : void
        {
            if (hasEventListener (Event.ADDED_TO_STAGE))
            {
                removeEventListener (Event.ADDED_TO_STAGE, init);
            }

            stageW = stage.stageHeight;
            stageH = stage.stageWidth;

            stage.scaleMode = 'noScale';

            //
 
            graphics.beginFill (0, 1);
            graphics.drawRect  (0, 0, stageW, stageH);

            //

            hold = new Sprite ();

            data = new BitmapData
            (
                stageW, stageH, true, 0
            );

            addChild (new Bitmap (data));

            //

            d_ct = new ColorTransform (1, 1, 1, 0.35);

            d_mt = new Matrix
            (
                1.02, 0, 0, 1.02, -stageW/2 * 0.02, -10
            );

            //

            q_prp = new PerspectiveProjection ();
            q_prp.focalLength = 250;
            q_prp.fieldOfView = 90;

            q_v3d = new Vector3D (q_siz / 2, q_siz / 6, 0);

            q_m3d = new Matrix3D ();
            q_m3d.prependRotation(2, Vector3D.X_AXIS, q_v3d);
            q_m3d.prependRotation(2, Vector3D.Y_AXIS, q_v3d);
            q_m3d.prependRotation(2, Vector3D.Z_AXIS, q_v3d);

            q_arr = new Vector.<uint>();
            q_arr.push
            (
                1, 2, 3, 4, 5, 6, 7, 8, 25, 26, 27, 30, 31,
                32, 33, 34, 40, 41, 42, 43, 44, 45, 50, 51
            );

            onQuadRot ();

            //

            q_vec = new Vector.<QUAD>(q_num, true);

            q_vec.forEach (onQuadDraw);

            // --o SOUND DERIVED INSTANCES

            infos = new TextField ();
            infos.selectable = false;
            infos.autoSize = 'left';
            infos.x = 7;
            infos.y = stageH - 24;

            addChild (infos);

            //

            plays = new TextField ();
            plays.selectable = false;
            plays.autoSize = 'right';
            plays.x = stageW - 11;
            plays.y = 5;

            addChild (plays);

            //

            gLoad = new GRAPHIC_BAR
            (
                10, stageH - 30,
                stageW / 2 - 10, 2, 'H'
            );
            gLoad.visible = false;

            addChild (gLoad);

            lChan = new GRAPHIC_BAR
            (
                stageW - 23, stageH - 9,
                0, 2, 'V'
            );

            addChild (lChan);

            rChan = new GRAPHIC_BAR
            (
                stageW - 11, stageH - 9,
                0, 2, 'V'
            );

            addChild (rChan);

            //

            sound = new Sound ();

            sound.addEventListener (Event.ID3, onID3);
            sound.addEventListener (Event.OPEN, onOpen);
            sound.addEventListener (Event.COMPLETE, onComplete);
            sound.addEventListener (IOErrorEvent.IO_ERROR, onIOError);
            sound.addEventListener (ProgressEvent.PROGRESS, onProgress);
            sound.addEventListener (SecurityErrorEvent.SECURITY_ERROR, onSecurityError);
            sound.load
            (
                new URLRequest (track),
                new SoundLoaderContext (1000, true)
            );

            //

            stage.addEventListener (KeyboardEvent.KEY_DOWN, onKey);

            stage.addEventListener (MouseEvent.CLICK, onUpdate);

            stage.addEventListener (Event.ENTER_FRAME, onFrame);
        }

        private function onUpdate (e : MouseEvent) : void
        {
            onQuadRot ();

            for each (var q : QUAD in q_vec)
            {
                q.rotationZ = q.r * (180/ Math.PI) * q_rot;
    
                q.x = stageW / 2 + q_pad * Math.cos(q.r);
                q.y = stageH / 2 + q_pad * Math.sin(q.r);
            }
        }

        private function onQuadRot () : void
        {
            q_rot = q_arr[Math.round (Math.random() * (q_arr.length - 1))];

            q_rot = Math.round (Math.random()) == 1 ? -q_rot : q_rot;
        }

        private function onQuadDraw (q : QUAD, n : Number, v : Vector.<QUAD>) : void
        {
            var f : Number = n * (stageH / 10) + stageW;    // DISTANCE
            var d : Number = - (360 / q_num) * n;           // DEGREE
            var r : Number = d * (Math.PI / 180);           // RADIAN

            color.h += 360 / q_num;

            //

            q = new QUAD
            (
                new Point
                (
                    stageW / 2 + q_pad * Math.cos(r),
                    stageH / 2 + q_pad * Math.sin(r)
                ),
                1, q_siz, r
            );

            q.transform.perspectiveProjection = q_prp;

            q.z = (n / 2 is uint ? -f : f);

            q.rotationZ = d * q_rot;

            q.draw (color.value);

            v[n] = q;

            //

            hold.addChild (q);
        }

        private function onFrame (e : Event) : void
        {
            if (q_mvd == q_num)
            {
                if (! sChan)
                {
                    sChan = new SoundChannel();
                    sChan = sound.play (0, 50);

                    infos.htmlText = sTags;
                    gLoad.visible = true;
                }

                lChan.draw (sChan.leftPeak  * 65, 0x333333);
                rChan.draw (sChan.rightPeak * 65, 0x333333);

                SoundMixer.computeSpectrum (bytes, false, 0);

                plays.htmlText = '<font size=\'10\' color=\'#333333\'>[ ' + onDuration (sChan.position) + ' | ' + onDuration (sound.length) + ' ]</font>';
            }

            //

            q_vec.forEach (onQuadMove);

            onRender ();
        }

        private function onQuadMove (q : QUAD, n : Number, v : Vector.<QUAD>) : void
        {
            if (q_mvd < q_num)
            {
                var s : uint = 35;        // QUAD SPEED
                var f : uint = 500;       // FADE ALPHA

                if (q.z != 0)
                {
                    q.z = (0 > q.z ? (q.z + s > 0 ? 0 : q.z + s) : (q.z - s < 0 ? 0 : q.z - s));

                    q.alpha = 1 - (Math.abs(q.z) < f ? Math.abs(q.z / f) : 1);

                    if (q.z == 0)  q_mvd ++;
                }
            }
            else
            {
                var b : Number = bytes.readFloat ();

                bytes.position += 4;

                q.w = q_siz * b;

                //

                color.value = q.c;
                color.h -= 90 / q_num;

                q.draw (color.value);

                q.transform.matrix3D.prepend (q_m3d);
            }

            q.rotationZ += 4;
        }

        private function onRender () : void
        {
            data.colorTransform (data.rect, d_ct);

            data.draw (data, d_mt);
            data.draw (hold, null, null, 'add');
        }

        // --o SOUND EVENT HANDLERS

        private function onID3 (e : Event) : void
        {   
            sound.removeEventListener (Event.ID3, onID3);

            sTags = '<font size=\'10\' color=\'#333333\'>[ ';

            if (sound.id3.TPE1) sTags += sound.id3.TPE1;
            if (sound.id3.TIT2) sTags += ' | ' + sound.id3.TIT2;
            if (sound.id3.TALB) sTags += ' | ' + sound.id3.TALB;
            if (sound.id3.TBPM) sTags += ' | ' + sound.id3.TBPM + ' BPM';

            sTags += ' ]</font>';
        }

        private function onDuration (n : uint) : String
        {
            var m : uint = Math.floor(n / 1000 / 60);
            var s : uint = Math.floor(n / 1000) % 60;

            return m + ':' + (s < 10 ? '0' + s : s);
        }

        private function onOpen (e : Event) : void {}

        private function onProgress (e : ProgressEvent) : void
        {
            var ratio : Number = 1 - e.bytesLoaded / e.bytesTotal;

            gLoad.draw (gLoad.w * ratio, 0x333333);
        }

        private function onComplete (e : Event = null) : void
        {
            if (sound.hasEventListener (ProgressEvent.PROGRESS))
            {
                sound.removeEventListener
                (
                    ProgressEvent.PROGRESS, onProgress
                );
            }
        }

        private function onIOError (e : IOErrorEvent) : void {}

        private function onSecurityError (e : SecurityErrorEvent) : void {}
    
        // --o KEY EVENT HANDLERS
    
        private function onKey (e :KeyboardEvent) : void
        {
            switch (e.keyCode)
            {
                case 32 : onUpload ();
            }
        }

        private function onUpload () : void
        {
            sLoad =  new FileReference ();

            sLoad.addEventListener
            (
                Event.SELECT, onFileSelect
            );

            sLoad.addEventListener
            (
                Event.COMPLETE, onFileComplete
            );

            sLoad.addEventListener
            (
                ProgressEvent.PROGRESS, onProgress
            );

            sLoad.browse
            (
                [new FileFilter ('Music File (*.mp3)', '*.mp3;')]
            );
        }

        private function onFileSelect (e : Event) : void
        {
            onComplete ();

            sLoad.load ();
        }

        private function onFileComplete (e : Event) : void
        {
            var mp3File : MP3FILE = new MP3FILE (sLoad.data);

            mp3File.addEventListener
            (
                MP3FILE.AVAILABLE, onFileAvailable
            );
        }

        private function onFileAvailable (e : Event) : void
        {
            sound = e.target.sound;

            sTags = '<font size=\'10\' color=\'#333333\'>[ ' + sLoad.name.slice(0,sLoad.name.lastIndexOf('.')) + ' ]';

            if (sChan)
            {
                sChan.stop ();
   
                sChan = sound.play (0, 50);

                infos.htmlText = sTags;
            }
        }
    }
}

//

import flash.geom.Point;

import flash.display.Shape;
import flash.display.GraphicsPath;
import flash.display.IGraphicsData;
import flash.display.GraphicsStroke;
import flash.display.GraphicsSolidFill;

internal class QUAD extends Shape
{
    public var c : uint;
    public var p : Point;
    public var t : Number;
    public var w : Number;
    public var r : Number;

    public function QUAD (point : Point, thick : Number, width : Number, radian : Number = 0)
    {
        p = point;
        t = thick;
        w = width;
        r = radian;

        x = p.x;
        y = p.y;
    }

    public function draw (color : uint = 0, fill_a : Number = 0.15, stroke_a : Number = 1) : void
    {
        c = color;

        //

        graphics.clear ();

        var g_s : GraphicsStroke = new GraphicsStroke (t);
        g_s.fill = new GraphicsSolidFill (c, stroke_a);

        var g_f : GraphicsSolidFill = new GraphicsSolidFill (c, fill_a);

        var g_c : Vector.<int> = new Vector.<int> ();
        g_c.push (1, 2, 2, 2, 2);

        var g_d : Vector.<Number> = new Vector.<Number> ();

        g_d.push (0, w/6, w, 0, w, w/4, 0, w/4, 0, w/6);

        var g_p : GraphicsPath = new GraphicsPath (g_c, g_d);

        var g_v : Vector.<IGraphicsData> = new Vector.<IGraphicsData>();
        g_v.push (g_f, g_s, g_p);

        graphics.drawGraphicsData (g_v);
    }
}

//

import flash.geom.Matrix;

import flash.display.Shape;
import flash.display.GraphicsPath;
import flash.display.IGraphicsData;
import flash.display.GraphicsStroke;
import flash.display.GraphicsGradientFill;

/**
*    @author SPANVEGA // CHRISTIAN //
**/

internal class GRAPHIC_BAR extends Shape
{
    public var c : uint;
    public var m : Matrix;
    public var w : Number;
    public var h : Number;    

    private var g_p : GraphicsPath;
    private var g_s : GraphicsStroke;
    private var g_f : GraphicsGradientFill;

    private var g_c : Vector.<int> = new Vector.<int>();
    private var g_d : Vector.<Number> = new Vector.<Number>();
    private var g_v : Vector.<IGraphicsData> = new Vector.<IGraphicsData>();

    public function GRAPHIC_BAR (x : Number, y : Number, width : Number, height : Number, display : String = 'H' /* || 'V' */)
    {
        this.x = x;
        this.y = y;

        w =  width;
        h = height;

        m = new Matrix ();
        m.createGradientBox (2, 2);

        if (display == 'V')
        {
            rotation = -90;
        }

        //

        g_s = new GraphicsStroke (h);

        g_f = new GraphicsGradientFill
        (
            'linear', [c, 0], [1, 0], [64, 128], m, 'repeat'
        );
        g_s.fill = g_f;

        g_c.push (1, 2);

        g_p = new GraphicsPath (g_c, g_d);
    }

    public function draw (value : Number, color : uint) : void
    {
        clear ();

        g_f.colors = [c=color, 0];

        g_d.length = 0;
        g_d.push (0, 0, value, 0);

        g_p.data = g_d;

        g_v.length = 0;
        g_v.push (g_s, g_p);

        graphics.drawGraphicsData (g_v);
    }

    public function clear () : void
    {
        graphics.clear ();
    }

    public function reset () : void
    {
        draw (w, c);
    }
}

//

import mx.utils.Base64Decoder;

import flash.media.Sound;
import flash.utils.ByteArray;

import flash.display.Loader;
import flash.display.LoaderInfo;

import flash.events.Event;
import flash.events.EventDispatcher;

import com.codeazur.as3swf.SWF;
import com.codeazur.as3swf.SWFData;
    
import com.codeazur.as3swf.data.SWFScene;
import com.codeazur.as3swf.data.SWFSymbol;
import com.codeazur.as3swf.data.consts.SoundRate;
import com.codeazur.as3swf.data.consts.SoundSize;
import com.codeazur.as3swf.data.consts.SoundType;
import com.codeazur.as3swf.data.consts.SoundCompression;

import com.codeazur.as3swf.tags.TagEnd;
import com.codeazur.as3swf.tags.TagDoABC;
import com.codeazur.as3swf.tags.TagShowFrame;
import com.codeazur.as3swf.tags.TagSymbolClass;
import com.codeazur.as3swf.tags.TagDefineSound;
import com.codeazur.as3swf.tags.TagFileAttributes;
import com.codeazur.as3swf.tags.TagSetBackgroundColor;
import com.codeazur.as3swf.tags.TagDefineSceneAndFrameLabelData;

/**
* MP3FILE CLASS DERIVED FROM
* http://code.google.com/p/makc/source/browse/trunk/flash/fp10_fft/ClientMP3Loader.as
* 
* FURTHER INFORMATIONS AVAILABLE @
* http://wiki.github.com/claus/as3swf/play-mp3-directly-from-bytearray
* http://github.com/claus/as3swf/raw/master/bin/as3swf.swc
*/

internal class MP3FILE extends EventDispatcher
{
    public var sound : Sound;
    
    /** Dispatch MP3FILE.AVAILABLE Event **/

    static public const AVAILABLE : String = 'AVAILABLE';


    public function MP3FILE (b : ByteArray)
    {
        var swf : ByteArray = createSWFFromMP3 (b);

        var loader : Loader = new Loader();

        loader.contentLoaderInfo.addEventListener
        (
            Event.INIT, initHandler
        );
        loader.loadBytes(swf);    
    }

    private function initHandler(e:Event):void
    {
        var SoundClass : Class = LoaderInfo(e.currentTarget).applicationDomain.getDefinition('MP3Wrapper_soundClass') as Class;

        sound = new SoundClass() as Sound;

        dispatchEvent (new Event (MP3FILE.AVAILABLE));
    }

    private function createSWFFromMP3 (mp3 : ByteArray) : ByteArray
    {
        var swf : SWF = new SWF ();
        swf.tags.push (new TagFileAttributes());
        swf.tags.push (new TagSetBackgroundColor());

        var defineSceneAndFrameLabelData : TagDefineSceneAndFrameLabelData = new TagDefineSceneAndFrameLabelData ();
        defineSceneAndFrameLabelData.scenes.push (new SWFScene (0, 'Scene 1'));
        swf.tags.push (defineSceneAndFrameLabelData);
        swf.tags.push (TagDefineSound.createWithMP3(1, mp3));
        swf.tags.push (TagDoABC.create(abc));

        var symbolClass : TagSymbolClass = new TagSymbolClass ();
        symbolClass.symbols.push(SWFSymbol.create(1, 'MP3Wrapper_soundClass'));
        symbolClass.symbols.push(SWFSymbol.create(0, 'MP3Wrapper'));
        swf.tags.push(symbolClass);
        swf.tags.push(new TagShowFrame());
        swf.tags.push(new TagEnd());

        var swfData:SWFData = new SWFData();
        swf.publish(swfData);

        return swfData;
    }

    private static function abcDataToByteArray () : ByteArray
    {
        var decoder : Base64Decoder = new Base64Decoder ();

        decoder.decode (<![CDATA[
            nVBNb9NAEJ1Z77eT5qNtGoQiIXFDKFlRiUNvqC0oBygiEuQCtZtssVHiRLZpwr/MT2IcFyKujEf2
            +s17b57dhiFQPVHL7XC2yr0dv1347Zui8KWdrH5m8/0xvF/ERTJc+nkaiz3cfeRfHEhw+v7j+Zc8
            Xq99fltU8CWpCntAm7XNPC3Wi/iXnKzztPT2QBX7+4ukLNcXo9FmsxnG89Wdp0XL0SvnXo/uKdto
            uR2lWenzLF6oz9efJuObD3JS5mn2XZ0PXXWFy+3tH4q8ufvhZ2WjXu0ffFYWrevqcUUx4nKWUK6r
            OlFN7YwraTwr0wdfI71/5perrIzTzOe2hz3elz3V1z3bN/qodxIgIj9RyBQGignDUHGtuFEyVLyh
            eFPpluJthV0T0OhYmVOjmSIPeaZkvwn/UxxBAAMWkCcXIJgRoEEqoyBEDWAAiWMlhh1UYImMDQmg
            NaXlABIZBzQoOLAGSo5BA+gzWLBz74CkGARIh4ARZnfuK382haRCOEMhzc59sy87iSVAIEold243
            BnqTJBBnJGhGRy5quSignuJgMEgYjVVFrndoRKX/6uinoXxKuvZBx6inbFBpBVEsoja1NmRobEja
            SCS6NmiQgX6+cx4eDTou6rro2EWKehoM9pVIov4G
        ]]>);

        var decodedBytes : ByteArray = decoder.toByteArray ();

        decodedBytes.inflate ();

        return decodedBytes;
    }

    private static var abc : ByteArray = abcDataToByteArray ();
}