/**
 * Copyright haaalsan ( http://wonderfl.net/user/haaalsan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/abVy
 */

// forked from zoting's forked from: Explosion Rendering
// forked from keim_at_Si's Explosion Rendering
// Click screen to explode.
//   customized betweenas3
package {
    import flash.display.*;
    import flash.geom.*;
    import frocessing.display.*;
    import org.si.sion.*;
    import org.libspark.betweenas3.easing.*;
    
    [SWF(backgroundColor="0xffffff", frameRate="60")]
    public class main extends F5MovieClip2D {
        public var screen:BitmapData = new BitmapData(240, 240, false);
        public var exp:Vector.<BitmapData>, frameCounter:int, pt:Point = null;
        public var driver:SiONDriver = new SiONDriver(), data:SiONData;
        
        public function setup() : void {
            data = driver.compile("%2@al2i0@4@ml8i1@1,32@tl8@f40,1,48,24,0,0,80,68s22o2q0g32q8g8");
            exp = explosion();
            with(addChild(new Bitmap(screen))) scaleX = scaleY = 2;
        }

        public function mouseClicked() : void {
            pt = new Point(pmouseX*0.5-100, pmouseY*0.5-100);
            frameCounter = 0;
            driver.play(data);
        }
        
        public function draw() : void {
            screen.fillRect(screen.rect, 0);
            if (pt) {
                screen.copyPixels(exp[frameCounter], exp[frameCounter].rect, pt);
                if (++frameCounter==120) pt = null;
            }
        }
        
        private var cloud:BitmapData = Particle.cloud();
        private var fire:* = Particle.palette([0,0xffa0a060,0xff703810,0xc0301810,0], [0,0.05,0.2,0.6,1]);
        private var smoke:* = Particle.palette([0,0xff000000,0xff000000,0x00808080], [0,0.1,0.2,1]);
        public function explosion() : Vector.<BitmapData> {
            var init:*, i:int;
            var frame:Vector.<BitmapData> = new Vector.<BitmapData>(120);
            Particle.initialize();
            for (i=0; i<frame.length; i++) {
                Particle.begin(frame[i] = new BitmapData(200, 200, false, 0));
                if (Particle.counter<20) {
                    init = {size:30, x:random(0,30)-random(0,30), y:random(0,30)-random(0,30)};
                    Particle.alloc(cloud, fire, "add", {rot:random(-0.5,0.5), size:180}, init, random(50,100), Quint.easeOut, 0);
                    if (Particle.counter&1) {
                        init = {size:100, x:random(0,50)-random(0,50), y:random(0,50)-random(0,50)};
                        Particle.alloc(cloud, smoke, null, {y:init.y-20, rot:random(-1,1)}, init, 100, null, 0);
                    }
                }
                Particle.end();
            }
            return frame;
        }
    }
}




import flash.display.*;
import flash.geom.*;
import frocessing.color.ColorLerp;
import org.libspark.betweenas3.easing.*;
import org.libspark.betweenas3.tweens.*;
import org.libspark.betweenas3.core.easing.*;
import org.libspark.betweenas3.core.tweens.*;

class Particle {
    static public function palette(col32:Array, ratio:Array) : * {
        var a:Vector.<Number> = new Vector.<Number>(256), 
            r:Vector.<Number> = new Vector.<Number>(256), 
            g:Vector.<Number> = new Vector.<Number>(256), 
            b:Vector.<Number> = new Vector.<Number>(256), 
            i:int, c:int, col:uint;
        if (ratio[0] < 0) ratio.unshift(0);
        if (ratio[ratio.length-1] > 1) ratio.push(1);
        for (i=0; i<ratio.length; i++) ratio[i]=int(ratio[i]*256);
        for (c=0, i=0; i<256; i++, c+=(i>=ratio[c+1])) {
            col = ColorLerp.lerp(col32[c], col32[c+1], (i-ratio[c])/(ratio[c+1]-ratio[c]));
            a[i] = (col >>> 24) / 255;
            r[i] = ((col >> 16) & 255) / 255;
            g[i] = ((col >> 8) & 255) / 255;
            b[i] = (col & 255) / 255;
        }
        return {"a":a, "r":r, "g":g, "b":b};
    }
    static public function cloud() : BitmapData {
        var shp:Shape = new Shape(), mat:Matrix = new Matrix();
        var map:BitmapData = new BitmapData(256, 256, true);
        map.perlinNoise(64, 64, 4, Math.random()*int.MAX_VALUE, false, true, 7, true);
        mat.createGradientBox(256, 256, 0, 0, 0);
        shp.graphics.beginGradientFill(GradientType.RADIAL, [0xffffff,0x404040, 0], [1,1,1], [0,128,255], mat);
        shp.graphics.drawRect(0, 0, 256, 256);
        map.draw(shp, null, null, "multiply");
        map.copyChannel(map, map.rect, map.rect.topLeft, 1, 8);
        map.colorTransform(map.rect, new ColorTransform(1,1,1,1.5,128,128,128,-16));
        return map;
    }
    static public function initialize() : void {
        counter = 0;
    }
    static public function alloc(tex:BitmapData, pal:*, method:String, to:*=null, from:*=null, life:int=60, easing:IEasing=null, layer:int=0) : Particle {
        var p:Particle = _freeList.pop() || new Particle();
        p.texture = tex;
        p.a = pal.a;
        p.r = pal.r;
        p.g = pal.g;
        p.b = pal.b;
        p.method = method;
        p.aging = 1/life;
        p.age = 0;
        p.x = ("x" in from) ? from.x : 0;
        p.y = ("y" in from) ? from.y : 0;
        p.size = ("size" in from) ? from.size : 256;
        p.angle = Math.random() * 6.283185307179586;
        if ("rot" in to) {
            to["angle"] = p.angle + to.rot;
            delete to.rot;
        }
        var t:ITween = $.tween(p, to, from, life, easing, layer);
        t.onUpdate = p._update;
        t.onComplete = p._complete;
        t.play();
        return p;
    }
    static public function begin(screen:BitmapData) : void {
        _screen = screen;
    }
    static public function end() : void {
        $.update();
        counter++;
    }
    
    static public var counter:int = 0;
    static private var _freeList:Vector.<Particle> = new Vector.<Particle>();
    static private var _screen:BitmapData;
    public var x:Number, y:Number, angle:Number, size:Number, method:String, aging:Number, age:Number, layer:int;
    public var texture:BitmapData, a:Vector.<Number>, r:Vector.<Number>, g:Vector.<Number>, b:Vector.<Number>;
    public var mat:Matrix = new Matrix(), colt:ColorTransform = new ColorTransform();
    
    function Particle() {}
    private function _update() : void {
        var htxt:Number = texture.width * 0.5,
            hscr:Number = _screen.width * 0.5, 
            scale:Number = size/texture.width;
        mat.identity();
        mat.translate(-htxt, -htxt);
        mat.rotate(angle);
        mat.scale(scale, scale);
        mat.translate(x+hscr, y+hscr);
        var i:int = age * 255;
        if (i>255) i=255;
        colt.redMultiplier = r[i];
        colt.greenMultiplier = g[i];
        colt.blueMultiplier = b[i];
        colt.alphaMultiplier = a[i];
        _screen.draw(texture, mat, colt, method, null, true);
        age += aging;
    }
    private function _complete() : void { _freeList.push(this); }
}


// Customized betweenAS3. Free but naive ...
//--------------------------------------------------------------------------------
import org.libspark.betweenas3.core.ticker.*;
import org.libspark.betweenas3.core.updaters.*;
import org.libspark.betweenas3.core.updaters.display.*;
import org.libspark.betweenas3.core.updaters.geom.*;
import org.libspark.betweenas3.core.utils.*;

class ControlableTicker implements ITicker {
    private var _term:TickerListener = new TickerListener();
    private var _time:Number = 0;
    function ControlableTicker() { _term.nextListener = _term.prevListener = _term; }
    public function get time():Number { return _time; }
    public function addTickerListener(tl:TickerListener) : void {
        if (tl.nextListener != null || tl.prevListener != null) return;
        tl.prevListener = _term.prevListener;
        tl.nextListener = _term;
        _term.prevListener.nextListener = tl;
        _term.prevListener = tl;
    }
    public function removeTickerListener(tl:TickerListener) : void {
        tl.prevListener.nextListener = tl.nextListener;
        tl.nextListener.prevListener = tl.prevListener;
        tl.prevListener = tl.nextListener = null;
    }
    public function start() : void {}
    public function stop() : void {}
    public function update(deltaTime:Number) : void {
        _time += deltaTime;
        for (var tl:TickerListener = _term.nextListener; tl != _term; tl = tl.nextListener) {
            if (tl.tick(_time)) {
                tl.prevListener.nextListener = tl.nextListener;
                tl.nextListener.prevListener = tl.prevListener;
                var prev:TickerListener = tl.prevListener;
                tl.prevListener = tl.nextListener = null;
                tl = prev;
            }
        }
    }
} 

class $ {
    static private var _tickers:Vector.<ControlableTicker> = new Vector.<ControlableTicker>(4);
    static private var _updaterClassRegistry:ClassRegistry = new ClassRegistry();
    static private var _updaterFactory:UpdaterFactory = new UpdaterFactory(_updaterClassRegistry);
    {
        _tickers[0] = new ControlableTicker();
        _tickers[1] = new ControlableTicker();
        _tickers[2] = new ControlableTicker();
        _tickers[3] = new ControlableTicker();
        ObjectUpdater.register(_updaterClassRegistry);
        DisplayObjectUpdater.register(_updaterClassRegistry);
        MovieClipUpdater.register(_updaterClassRegistry);
        PointUpdater.register(_updaterClassRegistry);
    }
    
    static public function tween(target:*, to:*, from:*=null, time:Number=1.0, easing:IEasing=null, layer:int=0) : IObjectTween {
        var tween:ObjectTween = new ObjectTween(_tickers[layer]);
        tween.updater = _updaterFactory.create(target, to, from);
        tween.time = time;
        tween.easing = easing || Linear.easeNone;
        return tween;
    }
    
    static public function update() : void { 
        for (var i:int=0; i<_tickers.length; i++) _tickers[i].update(1); 
    }
}

