/**
 * Copyright djankey ( http://wonderfl.net/user/djankey )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/abRS
 */

// Getting started with stage video: http://www.adobe.com/devnet/flashplayer/articles/stage_video.html
package 
{
    import flash.display.Sprite;    
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.display.StageDisplayState;
    import flash.geom.Rectangle;
    import flash.events.Event;
    import flash.events.FullScreenEvent;
    import flash.events.MouseEvent;
    import flash.events.NetStatusEvent;
    import flash.events.StageVideoAvailabilityEvent;
    import flash.events.AsyncErrorEvent;
    import flash.events.StageVideoEvent;
    import flash.events.TimerEvent;
    import flash.events.VideoEvent;    
    import flash.media.SoundTransform;    
    import flash.media.Video;
    import flash.media.StageVideo;
    import flash.media.StageVideoAvailability;    
    import flash.net.NetConnection;
    import flash.net.NetStream;
    import flash.system.Security; 
    
    import net.hires.debug.Stats;
    import com.bit101.components.Label;
        
    [SWF(frameRate = '30', width=465, height=456, backgroundColor='0x000000')]
    public class Main extends Sprite 
    {
        private static const VIDEO_FILE:String = "http://www.as-flash.com/temp/video.mp4";
                       
        private var sv:StageVideo;
        private var nc:NetConnection;
        private var ns:NetStream;
        private var video:Video;
        private var totalTime:Number;
        private var rc:Rectangle;
        
        private var info:Label;
        private var info2:Label;
        private var info3:Label;
        private var holder:Sprite;
        
        private var sv_available:Boolean;        
        private var played:Boolean = false;      
        private var customClient:Object;
        
        // constructor
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            // stage
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            Security.loadPolicyFile("http://www.as-flash.com/crossdomain.xml");                
            
            // NetConnection
            nc = new NetConnection();
            nc.connect(null);
            ns = new NetStream(nc);
            ns.addEventListener(NetStatusEvent.NET_STATUS, onNetStatus);
            ns.addEventListener(AsyncErrorEvent.ASYNC_ERROR, asyncErrorHandler);
            
            customClient = new Object;
            customClient.onMetaData = metaDataHandler;
            ns.client = customClient;            
            
            
            // Events
            stage.addEventListener(StageVideoAvailabilityEvent.STAGE_VIDEO_AVAILABILITY, onStageVideoState);            
            stage.addEventListener(Event.RESIZE,  onResize);                       
            stage.addEventListener(FullScreenEvent.FULL_SCREEN, displayStateChangeHandler);
            //stage.addEventListener(MouseEvent.CLICK, stageClickHandler);
            
            // classic video holder
            holder = new Sprite();
            addChild(holder);
            
            // Labels, buttons
            info = new Label(this, 70, 0, "LOADING VIDEO...");
            info2 = new Label(this, 70, 15, "");    
            info3 = new Label(this, 70, 30, "");
            
            // Stats
            addChild(new Stats());
        }
        
        private function displayStateChangeHandler(event:FullScreenEvent):void
        {
           resize();              
        }
        
        private function stageClickHandler(event:MouseEvent):void
        {
            stage.displayState = (stage.displayState == StageDisplayState.FULL_SCREEN)? StageDisplayState.NORMAL : StageDisplayState.FULL_SCREEN;
        }      
        
                
        private function onStageVideoState(event:StageVideoAvailabilityEvent):void
        {    
            // Detect StageVideo
            sv_available = (event.availability == StageVideoAvailability.AVAILABLE);            
            info2.text =  "StageVideo is " + StageVideoAvailability.AVAILABLE;
            
            
            if (sv_available) {
                sv = stage.stageVideos[0];                
                
                sv.addEventListener(StageVideoEvent.RENDER_STATE, stageVideoStateChange);
                sv.attachNetStream(ns);
            } else {
                video = new Video();
                video.smoothing = true;
                video.addEventListener(VideoEvent.RENDER_STATE, videoStateChange);
                video.attachNetStream(ns);
                holder.addChild(video);
            }
            
            ns.play(VIDEO_FILE);
        }
        
        private function onNetStatus(event:NetStatusEvent):void
        {
            if (event.info.code == "NetStream.Play.StreamNotFound") info.text = "Video is not available!";
            else if (event.info.code == "NetStream.Play.Stop") ns.seek(0);
        }
        
        private function asyncErrorHandler(event:AsyncErrorEvent):void
        {            
            info.text = " asyncError " + event.text;
        }
        
        private function metaDataHandler(event:Object):void
        {
            totalTime = event.duration;
            info.text = "VIDEO: " + event.width + "x" + event.height + "px, " + Math.round(totalTime*100)/100 + " seconds";
        }
        
        private function stageVideoStateChange(event:StageVideoEvent):void
        {
            
            info3.text = "StageVideo Render State : " + event.status;
            resize();
        }
        
        private function videoStateChange(event:VideoEvent):void
        {
            info3.text = "VideoEvent Render State : " + event.status;
            resize();
        }
        
        private function onResize(event:Event):void
        {
            resize();    
        }
        
        private function resize():void
        {
            if (sv_available) {
                rc = getVideoRect(sv.videoWidth, sv.videoHeight);
                sv.viewPort = rc;
            } else {
                rc = getVideoRect(video.videoWidth, video.videoHeight);
                video.width = rc.width;
                video.height = rc.height;
                video.x = rc.x, video.y = rc.y;
            }
        }
        
        private function getVideoRect(width:uint, height:uint):Rectangle
        {    
            var videoRect:Rectangle = new Rectangle(0, 0, 0, 0);
            var videoWidth:uint = width;
            var videoHeight:uint = height;
            var scaling:Number = Math.min ( stage.stageWidth / videoWidth, stage.stageHeight / videoHeight );
            
            videoWidth *= scaling, videoHeight *= scaling;
            
            var posX:int = (stage.stageWidth - videoWidth) * 0.5;
            var posY:int = (stage.stageHeight - videoHeight) * 0.5
            
            videoRect.x = posX;
            videoRect.y = posY;
            videoRect.width = videoWidth;
            videoRect.height = videoHeight;
            
            return videoRect;
        }
    }
    
}