/**
 * Copyright kikiroom ( http://wonderfl.net/user/kikiroom )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/abLT
 */

// forked from tail_y's OSでのデバイスフォントの違いについてチェックするためのコード
package{
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.display.Stage;
	import flash.display.Bitmap;
	import flash.geom.Matrix;
	import flash.display.BitmapData;
	import flash.text.TextFormat;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextField;
	import flash.display.Sprite;

	/**
	 * OSでのデバイスフォントの違いについてチェックするためのコード
	 */
	public class DeviceFontCheck extends Sprite{
		public function DeviceFontCheck(){
			WonderflTemplate.Initialize(this, Initialize, 20, 0xffffffff, 5);
		}
		
		private static const _CHECK_STRING:String = "The brown fox\nあたらしい朝が来た\n希望の朝だ。";
		private static const _FONT_NAME:String = "_sans";
		private var _i:int = 0;
		private var _putX:int = 0;
		private static const _ANTIALIASING_SIZE:Number = 4.0;
		private static const _PUT_Y_LIST:Array = [0, 40, 86, 135, 184, 236, 291, 352];
		
		public function Initialize():void{
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			createTf(10, false);
			createTf(11, false);
			createTf(12, false);
			createTf(12, true);
			createTf(14, false);
			createTf(14, true);
			createTf(16, false);
			createTf(24, false);
			
			createAntialiasingFont();
		}
		private function createTf(size:int, bold:Boolean):void{
			var tf:TextField = new TextField();
			var format:TextFormat = tf.getTextFormat();
			format.size = size;
			format.bold = bold;
			format.color = 0xff0000;
			if (_FONT_NAME != "") format.font = _FONT_NAME;
			tf.defaultTextFormat = format;
			tf.autoSize = TextFieldAutoSize.LEFT;
			tf.text = size + "pt - " + _CHECK_STRING;
			tf.x = _putX;
			tf.y = _PUT_Y_LIST[_i++];
			addChild(tf);
		}
		
		private function createAntialiasingFont():void{
			var copyBmd:BitmapData = new BitmapData(465 * _ANTIALIASING_SIZE, 465 * _ANTIALIASING_SIZE);
			var matrix:Matrix = new Matrix();
			matrix.scale(_ANTIALIASING_SIZE, _ANTIALIASING_SIZE);
			copyBmd.draw(this, matrix);
			var bmp:Bitmap = new Bitmap(copyBmd);
			bmp.smoothing = true;
			bmp.scaleX = bmp.scaleY = 1 / _ANTIALIASING_SIZE;
			bmp.x = int(465 / 2);
			addChild(bmp);
		}
	}
}


import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.events.Event;


/* 初期化テンプレート*/
class WonderflTemplate{
	public static const WIDTH:int = 465;
	public static const HEIGHT:int = 465;
	
	private static var _target:Sprite;
	private static var _handler:Function;
	
	public static function Initialize(target:Sprite, handler:Function, fps:Number, bgColor:uint, captureDelay:int):void{
		_target = target;
		_handler = handler;

		target.stage.frameRate = fps;
		
		var bg:Bitmap = new Bitmap(new BitmapData(WIDTH, HEIGHT, false, bgColor));
		target.addChild(bg);

		Wonderfl.capture_delay(captureDelay);
		
		target.addEventListener(Event.ADDED_TO_STAGE, addToStageHandler);
	}
	private static function addToStageHandler(event:Event):void{
		_target.removeEventListener(Event.ADDED_TO_STAGE, addToStageHandler);
		_handler();
	}
}