/**
 * Copyright sadamitsu ( http://wonderfl.net/user/sadamitsu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/abH7
 */

//音注意！！
package{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.GradientType;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.ColorMatrixFilter
	import flash.filters.BlurFilter;
	import flash.filters.DisplacementMapFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.media.Sound;
	import flash.media.SoundChannel;
	import flash.media.SoundMixer;
	import flash.net.URLRequest;
	import flash.system.Security;
	import flash.utils.ByteArray;
	
	[SWF( backgroundColor='#000000',frameRate=60)]
	public class Main extends Sprite{
		private var snd:Sound = new Sound();
		private var channel:SoundChannel;
		private var ba:ByteArray = new ByteArray();
		private var array:Array;
		private var numCount:Number = 0;
		private var a:Number = 0;
		private var blur:BlurFilter = new BlurFilter(4,4,1);
		private var rate:Number = .90;
		private var colorMatrix:ColorMatrixFilter = new ColorMatrixFilter([
			rate,0,0,0,2,
			0,rate,0,0,3,
			0,0,rate/*+.10*/,0,4,
			0,0,0,.92,/*-0.9*/0
		]);

		private var bmpMain:BitmapData = new BitmapData(stage.stageWidth,stage.stageHeight,true,0);
		private var rectMain:Rectangle = new Rectangle(0,0,stage.stageWidth,stage.stageHeight);
		private var pntOrigin:Point = new Point(0,0);
		private var bmp:Bitmap;
		private varisPlaying:Boolean = true;
		private var currentRotation:Number = 500;
		private var rotationInc:Number = .05;
		private var mc:MovieClip
		private var lowSound:MovieClip
		private var middleSound:MovieClip
		private var highSound:MovieClip


		public function Main() {
			mc=new MovieClip()
			addChild(mc)
			
			lowSound=new MovieClip()
			mc.addChild(lowSound)
			lowSound.x=stage.stageWidth/2
			lowSound.y = stage.stageHeight / 2
			
			middleSound=new MovieClip()
			mc.addChild(middleSound)
			middleSound.x=stage.stageWidth/2
			middleSound.y = stage.stageHeight / 2
			
			highSound=new MovieClip()
			mc.addChild(highSound)
			highSound.x=stage.stageWidth/2
			highSound.y=stage.stageHeight/2
			
			Security.loadPolicyFile("http://sadamitsu.heteml.jp/crossdomain.xml"); 
			snd.load(new URLRequest(""));  
    		snd.play();  
    		snd.close(); 
			snd.load(new URLRequest("http://sadamitsu.heteml.jp/sounds/bgm01.mp3"));
			channel = snd.play();
			this.addEventListener(Event.ENTER_FRAME, spectrum);
		}
 
		private function spectrum(event:Event) {
			if(++numCount%2 == 0) {
				a = 0;
				lowSound.graphics.clear();
				middleSound.graphics.clear();
				highSound.graphics.clear();
				SoundMixer.computeSpectrum(ba,true,0);
				currentRotation += rotationInc;
				var radians:Number = 0;
				if(currentRotation == 0) {
					currentRotation = Math.random();
				}
				radians = currentRotation * Math.PI * 2;
			
				//低音域付近
				var numM:int=3
				for(var i:Number = 0; i < 100; i+=numM) {
					var sizeNum:Number=10
					a = ba.readFloat();
					var numX:Number = a*200;
					var numY:Number = -a*stage.stageHeight;
					lowSound.graphics.beginFill(0x0299FD|((a*500)*5 << 8),.75);
					var radiusRotate:Number = 0;
					var pointX:Number = (stage.stageWidth/3 * Math.cos(360/numM + (i/(100/numM))/numM * Math.PI * 2))+stage.stageWidth/2;
					var pointY:Number = (stage.stageWidth/3 * Math.sin(360/numM + (i/(100/numM))/numM* Math.PI * 2))+stage.stageHeight/2;
					lowSound.graphics.drawCircle(pointX-stage.stageWidth/2,pointY-stage.stageHeight/2,numX);
					lowSound.scaleX=lowSound.scaleY=a*2
				}
				//中音域付近
				numM=2
				for(i = 100; i < 156; i+=numM) {
					sizeNum=10
					a = ba.readFloat();
					numX = a*200;
					numY = -a*stage.stageHeight;
					middleSound.graphics.beginFill(Math.random()*0xFF0000|((a*500)*5 << 8),.75);
					radiusRotate = 0;
					pointX = (stage.stageWidth/3 * Math.cos(360/numM + (i/(56/numM))/numM * Math.PI * 2))+stage.stageWidth/2;
					pointY = (stage.stageWidth/3 * Math.sin(360/numM + (i/(56/numM))/numM* Math.PI * 2))+stage.stageHeight/2;
					middleSound.graphics.drawCircle(pointX-stage.stageWidth/2,pointY-stage.stageHeight/2,numX*2);
					middleSound.scaleX=middleSound.scaleY=a*3
				}
				//高音域付近
				numM=3
				for(i = 156; i < 256; i+=numM) {
					 sizeNum=10
					a = ba.readFloat();
					numX = a*400;
					numY = -a*stage.stageHeight;
					highSound.graphics.beginFill(0xFF0000|((a*500)*5 << 8),.75);
					radiusRotate = 0;
					pointX = (stage.stageWidth/3 * Math.cos(360/numM + (i/(100/numM))/numM * Math.PI * 2))+stage.stageWidth/2;
					pointY = (stage.stageWidth/3 * Math.sin(360/numM + (i/(100/numM))/numM* Math.PI * 2))+stage.stageHeight/2;
					highSound.graphics.drawCircle(pointX-stage.stageWidth/2,pointY-stage.stageHeight/2,numX*2);
					highSound.scaleX=highSound.scaleY=a*1
				}
		
				bmpMain.draw(mc);
				bmpMain.applyFilter(bmpMain,rectMain,pntOrigin,blur);
				bmpMain.applyFilter(bmpMain,rectMain,pntOrigin,colorMatrix);
				bmp = new Bitmap(bmpMain);
				mc.addChildAt(bmp,0);
				var child = mc.getChildAt(1);
				if(child && numCount > 2) {
					mc.removeChildAt(1);
				}
			}
		} 
	}
}
