/**
 * Copyright faunus ( http://wonderfl.net/user/faunus )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aasu
 */

// forked from hacker_nmyze_52's forked from: Mandelbrot fractal using palette
// forked from splashdust's Mandelbrot fractal using palette
// forked from splashdust's Mandelbrot fractal
// Now it uses a palette for rendering. FAST!
package {
    import flash.display.Sprite;
    import flash.events.TimerEvent;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.utils.Timer;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.geom.Point;
    
    [SWF(width="512", height="512", frameRate="60")]
    
    public class FlashTest extends Sprite {
        public static var width:int = 512;
        public static var height:int = 512;
        public function FlashTest() {
           var setBitmap:Bitmap = new Bitmap();
            var bitmapData:BitmapData = new BitmapData( stage.stageWidth , stage.stageHeight , false , 0x000000 );
            var paletteData:BitmapData = new BitmapData( stage.stageWidth , stage.stageHeight , false , 0x000000 );
            
            setBitmap.bitmapData = bitmapData;

            addChild( setBitmap );
            var rgbArray:Array = new Array();
            
            var beforeTime:int = flash.utils.getTimer();
            var xtemp:Number = 0;
            var x0:Number = 0;
            var y0:Number = 0;
            var iteration:int = 0;
            
            for(var ix:int=0; ix<width; ix++) {
	            for(var iy:int=0; iy<height; iy++) {
			
			x0 = 0;
			y0 = 0;
			iteration = 128;
			
			while ( x0*x0 + y0*y0 <= 4  &&  iteration > 0 ) 
  			{
				xtemp = x0*x0 - y0*y0 + (ix-14*5000)/50000;
				y0 = 2*x0*y0 + (iy-(height/0.6))/50000;
				x0 = xtemp;
				
				iteration--;
			}
			
			paletteData.setPixel(ix, iy, iteration);
		}
            }

            var afterTime = flash.utils.getTimer();

            var tf = new TextField();
            tf.width = 400;
            tf.text = "Generating fractal took "+(afterTime-beforeTime)+" ms";
            addChild(tf);

            var fps = new TextField();
            fps.width = 400;
            fps.y = 10;
            fps.text = "FPS: ";
            addChild(fps);

            var colorModifier:int = 0;
            //var timer:Timer = new Timer(10);
            var pixel;
            addEventListener(Event.ENTER_FRAME, function(){
	    var r:int=0, b:int=0, g:int=0;
	
	    var beforeTime:int = flash.utils.getTimer();
	for(var i:int=1; i<128; i++) {
	    r = i + colorModifier;
	    g = i + colorModifier + r;
	    b = i + colorModifier + g;
				
            rgbArray[i] = (r<<16 | g<<8 | b);
	}
        bitmapData.paletteMap(paletteData, bitmapData.rect, new Point(0,0), rgbArray, rgbArray, rgbArray);
	var afterTime = flash.utils.getTimer();
	
	fps.text = "FPS: "+Math.round(1000/(afterTime-beforeTime));
	
	colorModifier += 1;
	if(colorModifier > 254)
			colorModifier = 0; 
});
            
        }
    }
}