/**
 * Copyright vuja22 ( http://wonderfl.net/user/vuja22 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aZEp
 */

// forked from yuuganisakase's batting game
// ボールを出来るだけ遠くに打ちましょう。
//＊＊点数計算の方法を小数点込みに変更＊＊

package 
{
    import Box2D.Common.Math.b2Vec2;
    import com.actionsnippet.qbox.QuickBox2D;
    import com.actionsnippet.qbox.QuickObject;
    import com.bit101.components.Label;
    import com.bit101.components.PushButton;
    import flash.display.*;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.geom.Matrix;
    import flash.geom.ColorTransform;
         import net.wonderfl.score.basic.BasicScoreForm;
    import net.wonderfl.score.basic.BasicScoreRecordViewer;
         import net.wonderfl.widget.Wanco;    
    [SWF(width=465, height=465, frameRate=60, backgroundColor=0xffffff)]
    public class Batting extends Sprite
    {
        private var bat:Bat;
        private var ball:QuickObject;
        private var box:QuickBox2D;
        private var boxBat:QuickObject;
        private var backGround:Sprite;
        private var layer:MovieClip;
        private var angle:Number;
        private var score:Label;
        private var button:PushButton;
        private var gameEnd:Boolean = false;
                  private var form:BasicScoreForm;
                  private var rank:BasicScoreRecordViewer;
        public function Batting():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            layer = new MovieClip();
            addChild(layer);
            
            button = new PushButton(this, 190, 50, "start", onButton);
            bat = new Bat();
            layer.addChild(bat);
            bat.x = 30;
            bat.y = 320;
            createBoxWorld();
            createBackgroundImage();
            createScoreBoard();
            button.label = "start";
            addEventListener(Event.ENTER_FRAME, onEnter);
            stage.addEventListener(MouseEvent.CLICK, onClick);
        }
        private function createScoreBoard():void
        {
            score = new Label(this, 370, 50, "0m");
            score.scaleX = score.scaleY = 2;
        }
        private function onButton(e:Event = null):void
        {
                           button.label = "retry";
            layer.x = layer.y = 0;
            e.stopPropagation();
            ball.body.SetLinearVelocity(new b2Vec2(0, 0));
            ball.body.SetAngularVelocity(0);
            ball.setLoc(1, 2);
            gameEnd = false;
        }
        private function makeBall():void
        {
            ball = box.addCircle( {skin:Unko ,x:1, y:12, 
                                    radius:0.5 , density:0.4, 
                                    friction:0.9 , restitution:0.7, 
                                    linearDamping:0.17, angularDamping:0.35, isBullet:true , maskBits:0x01} );
        }
        private function createBackgroundImage():void
        {
            backGround = new Sprite();
            layer.addChildAt(backGround, 0);
            backGround.y = 400;
            var s:Wanco = new Wanco();
            //s.graphics.beginFill(0xff0000, 0.5);
            //s.graphics.drawCircle(50, 50, 50);
                             var bd:BitmapData = new BitmapData(400, 400);
            bd.draw(s,new Matrix(4,0,0,4,140,240),new ColorTransform(1,1,1,0.1));
            
            for (var i:int = 0; i < 22; i++) 
            {
                for (var j:int = 0; j < 5; j++) 
                {
                    var bm:Bitmap = new Bitmap(bd);
                    backGround.addChildAt(bm,0);
                    bm.x = i * 400 -100;
                    bm.y = j * -290-30;
                }
            }
        }
        private function createBoxWorld():void
        {
            box = new QuickBox2D(layer,{gravityX:0.0, gravityY:8, 
                                        iterations: 8, timeStep: 1 / 60, 
                                        bounds: [ -50, -550, 5000, 50], debug:false, 
                                        simpleRender:true, renderJoints:true});
            var o1:QuickObject = box.addBox( { x:190, y:15, width:400, height:1.5 , density:0 , friction:0.8,fillColor:0xaa8855} );
            
            createBat();
            makeBall();
            box.start();
        }
        private function createBat():void
        {
            boxBat = box.addCircle( { x:-10, y:8, radius:0.1,density:90,friction:0.8,linearDamping:0.9, fillAlpha:0,lineAlpha:0} );
        }
        private function onClick(e:MouseEvent):void 
        {
            bat.swing();
            box.addTimeStepSequence( { time:box.totalTimeSteps+6, callback:shot } );
        }
        private function shot():void
        {
            boxBat.body.SetLinearVelocity(new b2Vec2(0, 0));
            boxBat.setLoc( 0.5, 10);
            const Power:Number = 90;
            
            boxBat.body.ApplyImpulse(new b2Vec2(Power*Math.cos(angle), Power*Math.sin(angle)), boxBat.body.GetPosition());
        }
        private function onEnter(e:Event):void 
        {
            angle = Math.atan2(mouseY - bat.y, mouseX - bat.x);
            bat.changeAimAngle(angle);
            
            if (ball.x > 0) {
                layer.x = -ball.x * 30 + 465/2;
                if (ball.y < 2) layer.y = -ball.y * 30;
                
                score.text = ball.x.toFixed(2).toString()+"m";//Math.floor(ball.x).toString() + "." + (Math.floor(ball.x*100)-Math.floor(ball.x)*100).toString() + "m";
                if (gameEnd == false && ball.x > 30 && ball.body.GetLinearVelocity().Length() < 0.09) {
                            form = new BasicScoreForm(this, 100, 100, Math.floor(ball.x*100),"Score",onClosed);
                            gameEnd = true;
ball.body.SetLinearVelocity(new b2Vec2(0, 0));
ball.body.SetAngularVelocity(0);


                                    }            
                        }
        }
                  private function onClosed(sendCompete:Boolean):void
                    {
                       rank = new BasicScoreRecordViewer(this, 100, 100, 'RECORD RANKING', 99, true);
                        removeChild(form);

                    }

    }
    
}

import flash.display.MovieClip;
import net.wonderfl.widget.Wanco;    
class Unko extends MovieClip
{
    public function Unko()
    {
                  var w:Wanco = new Wanco();
                  addChild(w);
                  w.x = 0;//-w.width/2;
                  w.y = w.height/2;
//        this.graphics.beginFill(0x00ff00);
//        this.graphics.drawRect(-4, -1, 8,2);
    }
}
import flash.display.Sprite;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.easing.Cubic;
import org.libspark.betweenas3.tweens.ITween;
import flash.display.Shape;
class Bat extends Sprite
{
    private var initY:Number = -11;
    private var sh:Shape;
    public function Bat()
    {
        super();
        const ww:int = 130;
        const hh:int = 15;
        this.graphics.beginFill(0x775533);
        this.graphics.drawRoundRect( -ww, -hh / 2, ww, hh, 20, 20);
        rotationY = initY;
        
        makeAiming();
        
    }
    private function makeAiming():void
    {
        sh = new Shape();
        sh.graphics.beginFill(0xffcc88, 0.1);
        sh.graphics.drawRect(0, 0, 160, 10);
        addChild(sh);
    }
    public function changeAimAngle(a:Number):void
    {
        var angle:Number = a * 180 / Math.PI;
        this.rotationZ = angle;
    }
    public function swing():void
    {
        var tween:ITween = BetweenAS3.tween(this, { rotationY:160 }, { rotationY:initY }, 0.4, Cubic.easeOut);
        tween.onComplete = setPosition; 
        tween.play();
    }
    private function setPosition():void
    {
        var t:ITween = BetweenAS3.tween(this, { rotationY:initY }, { rotationY:160 }, 0.3, Cubic.easeOut);
        var tween:ITween = BetweenAS3.delay(t, 0.4);
        tween.play();

    }
}