/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aZ5r
 */

package {

import flash.display.*;
import flash.geom.*;
import flash.events.*;
import flash.text.*;
import flash.utils.*;
import flash.filters.*;

public class Main extends Sprite
{
    static private const N:uint = 10;
    
    private function _init():void
    {
        _debug(
            "BitmapData同士の差の数値化てすと\n" + 
            "各テスト " + N + " 回処理させた計算結果 [単位 ： ミリ秒]\n" +
            "(誤差は多少生じます)\n"
        );
        
        var W : int = 465;
        var H : int = 465;
        var a : BitmapData = new BitmapData(W, H, false, 0x000000);
        var b : BitmapData = new BitmapData(W, H, false, 0x000000);
        a.lock();
        b.lock();
        a.noise(getTimer());
        b.noise(getTimer());
        
        _measure("ループのみ", function ():void
        {
            for (var i:uint = 0; i < N; i++) {
            }
        });
        
        _measure("愚直にgetPixel", function ():void
        {
            for (var i:uint = 0; i < N; i++) {
                var diff : Number = 0;
                for(var x : int = 0;x < W;x++){
                    for(var y : int = 0;y < H;y++){
                        var pa : uint = a.getPixel(x, y);
                        var pb : uint = b.getPixel(x, y);
                        
                        var dr : int = (pa >> 16) - (pb >> 16);
                        var dg : int = ((pa >> 8) & 255) - ((pb >> 8) & 255);
                        var db : int = (pa & 255) - (pb & 255);
                        diff += dr * dr + dg * dg + db * db;
                    }
                }
            }
            _debug("\n" + diff);
        });
        
        _measure("compare + histogram", function ():void
        {
            for (var i:uint = 0; i < N; i++) {
                var comp : BitmapData = BitmapData(a.compare(b));
                
                var hist : Vector.<Vector.<Number>> = comp.histogram();
                var diff : Number = 0;
                for(var ch : int = 0;ch < 3;ch++){
                    for(var j : int = 0;j <= 255;j++){
                        diff += hist[ch][j] * hist[ch][j] * j;
                    }
                }
                comp.dispose();
            }
            _debug("\n" + diff);
        });
        
        b.unlock();
        var bmpb : Bitmap = new Bitmap(b);
        b.lock();
            
        _measure("draw(BlendMode.DIFFERENCE) + histogram", function ():void
        {
            for (var i:uint = 0; i < N; i++) {
                var comp : BitmapData = a.clone();
                comp.draw(bmpb, null, null, BlendMode.DIFFERENCE);
                
                var hist : Vector.<Vector.<Number>> = comp.histogram();
                var diff : Number = 0;
                for(var ch : int = 0;ch < 3;ch++){
                    for(var j : int = 0;j <= 255;j++){
                        diff += hist[ch][j] * hist[ch][j] * j;
                    }
                }
                comp.dispose();
            }
            _debug("\n" + diff);
        });
        
        _measure("getVector", function ():void
        {
            for (var i:uint = 0; i < N; i++) {
                var va : Vector.<uint> = a.getVector(a.rect);
                var vb : Vector.<uint> = b.getVector(a.rect);
                var l : int = va.length;
                
                var diff : Number = 0;
                for(var j : int = 0;j < l;j++){
                    var dr : int = (va[j] >> 16) - (vb[j] >> 16);
                    var dg : int = ((va[j] >> 8) & 255) - ((vb[j] >> 8) & 255);
                    var db : int = (va[j] & 255) - (vb[j] & 255);
                    diff += dr * dr + dg * dg + db * db;
                }
            }
            _debug("\n" + diff);
        });
        
        a.dispose();
        b.dispose();
        _debug("\nなにかいい方法ないかな。");
    }
    
    private var _field:TextField;
    private var _time:uint;
    
    public function Main():void
    {
        _setup();
        _init();
    }
    
    private function _measure(title:String, func:Function, ...params):void
    {
        _time = getTimer();
        func.apply(null, params);
        _time = getTimer() - _time;
        
        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private function _setup():void
    {
        _field = new TextField();
        _field.width = stage.stageWidth - 40;
        _field.height = stage.stageHeight - 60;
        _field.x = 20;
        _field.y = 60;
        _field.multiline = true;
        _field.wordWrap = true;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
        
        var button:Sprite = new Sprite();
        button.graphics.lineStyle(1, 0xBBBBBB);
        button.graphics.beginFill(0xEEEEEE);
        button.graphics.drawRoundRect(0, 0, 100, 20, 5, 5);
        button.graphics.endFill();
        
        addChild(button);
        
        button.x = 20;
        button.y = 20;
        button.mouseChildren = false;
        button.buttonMode = true;
        
        var field:TextField = new TextField();
        field.width = 100;
        field.height = 20;
        field.htmlText = "<p align='center'><font face='_sans'>再計算</span></p>";
        
        button.addChild(field);
        
        button.addEventListener(MouseEvent.CLICK, function ():void
        {
            _field.text = "";
            _init();
        });
    }
}

}
