/**
 * Copyright fakestar0826 ( http://wonderfl.net/user/fakestar0826 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aYJm
 */

// forked from fakestar0826's forked from: flash on 2011-4-6
// forked from fakestar0826's flash on 2011-4-6
package {
    import flash.display.Bitmap;
    import flash.geom.Vector3D;
    import flash.geom.Matrix3D;
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.geom.Matrix;
    import flash.utils.Proxy;
    import flash.geom.Point;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        private var nX:Number = stage.stageWidth / 2;
        private var nY:Number = stage.stageHeight / 2;
        private var nUnit:Number = 100 / 2;
        private var nDeceleration:Number = 0.2;
        private var front:Rect;
        private var back:Rect;
        private var left:Rect;
        private var right:Rect;
        private var top:Rect;
        private var bottom:Rect;
        private var container:Sprite;
        private var matrix3D:Matrix3D;
        
        public function FlashTest() {
            // write as3 code here..
            
            front = new Rect(100, 100, Math.random() * 0xFFFFFF);
            back = new Rect(100, 100, Math.random() * 0xFFFFFF);
            left = new Rect(100, 100, Math.random() * 0xFFFFFF);
            right = new Rect(100, 100, Math.random() * 0xFFFFFF);
            top = new Rect(100, 100, Math.random() * 0xFFFFFF);
            bottom = new Rect(100, 100, Math.random() * 0xFFFFFF);
            
            container = new Sprite();
            addChild(container);
            container.z = 0;
            matrix3D = container.transform.matrix3D;
            container.x = nX; container.y = nY;
            container.addChild(xCreateFace(front, 0, 0, -nUnit));
            container.addChild(xCreateFace(back, 0, 0, nUnit, 180, 0));
            container.addChild(xCreateFace(right, nUnit, 0, 0, -90, 0));
            container.addChild(xCreateFace(left, -nUnit, 0, 0, 90, 0));
            container.addChild(xCreateFace(top, 0, -nUnit, 0, 0, -90));
            container.addChild(xCreateFace(left, 0, nUnit, 0, 0, 90));
            
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            
            xSetOrder();
        }
        
        private function xSetOrder():void
        {
            var faces_array:Array = [];
            var nChildren:uint = container.numChildren;
            var faceSprite:Sprite;
            for(var i:int = 0;i < nChildren;i++)
            {
                faceSprite = container.getChildAt(i) as Sprite;
                var myVector3D:Vector3D = faceSprite.transform.getRelativeMatrix3D(this).position;
                var nZ:Number = myVector3D.z;
                faces_array.push({face:faceSprite, z:nZ});
                
            }
            faces_array.sortOn("z", Array.NUMERIC | Array.DESCENDING);
            for(i = 0;i < nChildren;i++)
            {
                faceSprite = faces_array[i].face;
                container.setChildIndex(faceSprite, i);
            }

        }
        
        private function xCreateFace(face:Rect, nX:Number, nY:Number, nZ:Number, nR:Number = 0, nRx:Number = 0):Sprite
        {
            var faceSprite:Sprite = new Sprite();
            faceSprite.addChild(face);
            faceSprite.x = nX;
            faceSprite.y = nY;
            faceSprite.z = nZ;
            face.rotationY = nR;
            face.rotationX = nRx;
            face.x = -nUnit;
            face.y = -nUnit;
            return faceSprite;
        }
        
        private function onEnterFrame(e:Event):void
        {
            var nR:Number = (mouseX - nX) * nDeceleration;
            var nRx:Number = (mouseY - nY) * nDeceleration;
            this.matrix3D.appendTranslation(-nX, -nY, 0);
            this.matrix3D.appendRotation(nR, Vector3D.Y_AXIS);
            this.matrix3D.appendRotation(nRx, Vector3D.X_AXIS);
            this.matrix3D.appendTranslation(nX, nY, 0);
            xSetOrder();
            
        }


    }
}
import flash.display.Sprite;

class Rect extends Sprite
{
    public function Rect(w:int = 50, h:int = 50, c:uint = 0xFF0000)
    {
        this.graphics.beginFill(c);
        this.graphics.drawRect(-w / 2, -h / 2, w, h);
        this.graphics.endFill();
    }

}

class Circle extends Sprite
{
    public function Circle(r:int = 10, c:uint = 0x00FF00)
    {
        this.buttonMode = true;
        this.graphics.beginFill(c);
        this.graphics.drawCircle(0, 0, r);
        this.graphics.endFill();
    }

}
