/**
 * Copyright t2421 ( http://wonderfl.net/user/t2421 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aY3y
 */

package {
    import flash.display.Sprite;
    public class ButtonPradiso extends Sprite {
        private var model:Model;
        private var controller:Controller;
        public function ButtonPradiso() {
            model = Model.getInstance();
            controller = new Controller();
            this.addChild(controller);
            //makeBt();
            controller.init();
            controller.x = stage.stageWidth/2-controller.width/2;
            controller.y = stage.stageHeight/2-controller.height/2;
            
            
        }

    }
}

    import flash.events.Event;
    import flash.events.EventDispatcher;
    /**
     * ...
     * @author kiyo
     */
    class Model extends EventDispatcher
    {
        private static var instance:Model;       
        public function Model(p_key:SingletonBlocker) 
        {
            if (p_key == null) {
                throw new Error("Error;Instantiation");
            }
        }
        
        static public function getInstance():Model
        {
            if (instance == null) {
                instance = new Model(new SingletonBlocker());
            }
            
            return instance;            
        }
        
        internal function onOver():void
        {
            instance.dispatchEvent(new Event(Event.CHANGE));
        }
        
        internal function onOut():void
        {
            instance.dispatchEvent(new Event(Event.CHANGE));
        }        
    }


class SingletonBlocker{}



    import flash.display.Sprite;
    import flash.events.MouseEvent;
    /**
     * ...
     * @author kiyo
     */
    class Controller extends Sprite
    {
        private var bt_arr:/*View*/Array;
        private var numBt:uint = 9;
        private var model:Model;
        private var overMax:Number = 1.1;
        public function Controller() 
        {
            
        }
        
        public function init():void
        {
            model = Model.getInstance();
            bt_arr = [];
            makeBt();
            
            for (var i:int = 0; i < numBt ; i++) 
            {
                bt_arr[i].buttonMode = true;
                bt_arr[i].addEventListener(MouseEvent.ROLL_OVER, overHandler);
                bt_arr[i].addEventListener(MouseEvent.ROLL_OUT, outHandler);
                ScaleBeans.scale_arr[i] = 1;
            }
        }
        
        private function makeBt():void{
            var horizonMax:uint = 3;
            var rowCounter:uint = 1;
            var offset:Number = 25;
            for(var i:int=0;i<9;i++){
                var view:View = new View(i);
                if(i!=0){
                    view.x = bt_arr[i-1].x+view.width+offset;
                    view.y = bt_arr[i-1].y;
                    
                    if(i==horizonMax*rowCounter){
                        rowCounter++;
                        view.x = bt_arr[0].x;
                        view.y = bt_arr[i-horizonMax].y+view.height + offset;
                   }
                }else{
                    view.x = view.width/2;
                    view.y = view.height/2;
                }
                

                bt_arr.push(view);
                this.addChild(view);
                //controller.init(bt_arr);
            }
        }

        
        private function outHandler(e:MouseEvent):void 
        {
            for (var i:int = 0; i < numBt; i++) 
            {
                ScaleBeans.scale_arr[i] = 1;
            }
            model.onOut();
        }
        
        private function overHandler(e:MouseEvent):void 
        {
            var overObj:View = View(e.target);
            addChild(overObj);
            culcTargetScale(overObj);
        }
        
        private function culcTargetScale(overObj:View):void
        {
            var overID:uint = uint(overObj.id);
            var dist:Number;
            var distX:Number;
            var distY:Number;
            for (var i:int = 0; i < numBt; i++) 
            {
                if (i != overID) {
                    distX = overObj.x - bt_arr[i].x;
                    distY = overObj.y - bt_arr[i].y;
                    dist = Math.sqrt(distX * distX + distY * distY);
                    //trace(i + "ボタンのdist : " + uint(dist / 100));
                    ScaleBeans.scale_arr[i] = overMax / (dist / 80);
                    
                }else {
                    ScaleBeans.scale_arr[i] = overMax;
                }
            }
            model.onOver();
        }
        
    }

    import flash.display.Sprite;
    import flash.events.Event;
    /**
     * ...
     * @author kiyo
     */
    class View extends Sprite
    {
        private var model:Model;
        private var targetScale:Number;
        private var _id:uint;
        public function get id():uint{return _id}

    
        public function View(id:uint) 
        {
            _id = id;
            init();
            this.graphics.lineStyle(10,0xff0000);
            this.graphics.beginFill(0x000000);
            this.graphics.drawCircle(0,0,50);
            this.graphics.endFill();
        }
        
        private function init():void
        {
            model = Model.getInstance();
            model.addEventListener(Event.CHANGE, changeHandler);
            //trace("model : " + model);
        }
        
        private function changeHandler(e:Event):void 
        {
            targetScale = ScaleBeans.scale_arr[id];
            this.addEventListener(Event.ENTER_FRAME,enterframeHandler);
            
        }
        
        private function enterframeHandler(e:Event):void
        {
            var dx:Number = (targetScale - scaleX)*0.2;
            var dy:Number = (targetScale - scaleY)*0.2;
            scaleX += dx;
            scaleY += dy;
        }
        
    }
    
    /**
     * ...
     * @author kiyo
     */
    class ScaleBeans
    {
        public static var scale_arr:Array = [];       
    }

