/**
 * Copyright Phuong.Luna ( http://wonderfl.net/user/Phuong.Luna )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aXcO
 */

// forked from ProjectNya's Calendar (祝日あり)
////////////////////////////////////////////////////////////////////////////////
// [AS3.0] Calendarクラスに挑戦！ (1)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1043
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;

    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var display:Display;

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            display = new Display();
            addChild(display);
            display.x = 18;
            display.y = 72;
        }

    }

}


import flash.display.Sprite;
import flash.display.Shape;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.DropShadowFilter;

class Display extends Sprite {
    private var calendar:Array;
    private var year:uint;
    private var month:uint;
    private var today:Object;
    private static var limit:uint = 2010;
    private static var max:uint = 37;
    private var dayList:Array;
    private var monthTitle:TextField;
    private var eTitle:TextField;
    private var yearTitle:TextField;
    private static var fontType:String = "I love Luna";
    private static var _width:uint;
    private static var _height:uint;
    private static var hHeight:uint = 20;
    private static var wHeight:uint = 12;
    private static var bWidth:uint = 60;
    private static var bHeight:uint = 44;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var headerColor:uint = 0xCCFF00;
    private var months:Array;
    private var weekdays:Array;
    private var colors:Array;
    private static var sunColor:uint = 0xFF6699;
    private static var weekColor:uint = 0x66CC00;
    private static var satColor:uint = 0x6699CC;
    private var yPrevBtn:IconBtn;
    private var mPrevBtn:IconBtn;
    private var todayBtn:IconBtn;
    private var mNextBtn:IconBtn;
    private var yNextBtn:IconBtn;
    private var help:HelpPanel;

    public function Display() {
        init();
        draw();
        getToday();
        if (stage) initialize();
        else addEventListener(Event.ADDED_TO_STAGE, initialize, false, 0, true);
    }

    private function getToday():void {
        var todayDate:Date = new Date();
        year = todayDate.getFullYear();
        month = todayDate.getMonth() + 1;
        var day:uint = todayDate.getDate();
        today = {year: year, month: month, day: day};
        create(year, month);
    }
    private function create(y:uint, m:uint):void {
        calendar = Calendar.create(y, m);
        createDates();
        monthTitle.text = String(m);
        eTitle.text = months[m-1];
        yearTitle.text = String(y);
        manageBtns();
    }
    private function createDates():void {
        var first:uint = calendar[1].weekday;
        for (var n:uint = 0; n < max; n++) {
            var d:int = n - first + 1;
            var day:Day = dayList[n];
            if (d > 0) {
                var date:CalendarDate = calendar[d];
                if (date) {
                    if (year == today.year && month == today.month && date.day == today.day) {
                        day.init(date, true);
                    } else {
                        day.init(date);
                    }
                    if (date.holiday) {
                        day.addEventListener(MouseEvent.MOUSE_OVER, showHelp, false, 0, true);
                        day.addEventListener(MouseEvent.MOUSE_OUT, hideHelp, false, 0, true);
                    } else {
                        day.removeEventListener(MouseEvent.MOUSE_OVER, showHelp);
                        day.removeEventListener(MouseEvent.MOUSE_OUT, hideHelp);
                    }
                } else {
                    day.init();
                }
            } else {
                day.init();
            }
        }
    }
    private function init():void {
        calendar = new Array();
        today = new Object();
        _width = bWidth*7 + 8;
        _height = hHeight + wHeight + bHeight*6 + 10;
        months = new Array();
        months.push("January");
        months.push("February");
        months.push("March");
        months.push("April");
        months.push("May");
        months.push("June");
        months.push("July");
        months.push("August");
        months.push("September");
        months.push("October");
        months.push("November");
        months.push("December");
        weekdays = new Array();
        weekdays.push(Calendar.SUN);
        weekdays.push(Calendar.MON);
        weekdays.push(Calendar.TUE);
        weekdays.push(Calendar.WED);
        weekdays.push(Calendar.THU);
        weekdays.push(Calendar.FRI);
        weekdays.push(Calendar.SAT);
        colors = new Array();
        colors.push(sunColor);
        colors.push(weekColor);
        colors.push(weekColor);
        colors.push(weekColor);
        colors.push(weekColor);
        colors.push(weekColor);
        colors.push(satColor);
    }
    private function draw():void {
        graphics.beginFill(bColor);
        graphics.drawRoundRect(0, 0, _width, _height, 10);
        graphics.endFill();
        graphics.beginFill(headerColor);
        graphics.moveTo(5, 0);
        graphics.lineTo(_width - 5, 0);
        graphics.curveTo(_width, 0, _width, 5);
        graphics.lineTo(_width, hHeight);
        graphics.lineTo(0, hHeight);
        graphics.lineTo(0, 5);
        graphics.curveTo(0, 0, 5, 0);
        graphics.endFill();
        drawTitle();
        createWeek();
        createDays();
        createBtns();
        var shade:DropShadowFilter = new DropShadowFilter(0, 90, sColor, 0.5, 4, 4, 1.5, 2, false, false);
        filters = [shade];
    }
    private function initialize(evt:Event = null):void {
        removeEventListener(Event.ADDED_TO_STAGE, initialize);
        help = new HelpPanel();
        stage.addChild(help);
        help.init({width: 80, height: 32});
    }
    private function createDays():void {
        dayList = new Array();
        for (var n:uint = 0; n < max; n++) {
            var day:Day = new Day();
            addChild(day);
            dayList.push(day);
            day.x = (bWidth + 1)*(n%7) + 1;
            day.y = (bHeight + 1)*Math.floor(n/7) + hHeight + wHeight + 2;
        }
    }
    private function createBtns():void {
        yPrevBtn = new IconBtn(PrevDouble);
        addChild(yPrevBtn);
        yPrevBtn.x = 240;
        yPrevBtn.y = 285;
        yPrevBtn.init({width: 20});
        yPrevBtn.addEventListener(MouseEvent.CLICK, prevYear, false, 0, true);
        mPrevBtn = new IconBtn(Prev);
        addChild(mPrevBtn);
        mPrevBtn.x = 270;
        mPrevBtn.y = 285;
        mPrevBtn.init({width: 20});
        mPrevBtn.addEventListener(MouseEvent.CLICK, prevMonth, false, 0, true);
        todayBtn = new IconBtn(Today);
        addChild(todayBtn);
        todayBtn.x = 320;
        todayBtn.y = 285;
        todayBtn.init({width: 60});
        todayBtn.addEventListener(MouseEvent.CLICK, setToday, false, 0, true);
        mNextBtn = new IconBtn(Next);
        addChild(mNextBtn);
        mNextBtn.x = 370;
        mNextBtn.y = 285;
        mNextBtn.init({width: 20});
        mNextBtn.addEventListener(MouseEvent.CLICK, nextMonth, false, 0, true);
        yNextBtn = new IconBtn(NextDouble);
        addChild(yNextBtn);
        yNextBtn.x = 400;
        yNextBtn.y = 285;
        yNextBtn.init({width: 20});
        yNextBtn.addEventListener(MouseEvent.CLICK, nextYear, false, 0, true);
    }
    private function prevYear(evt:MouseEvent):void {
        manage(-1, 0);
    }
    private function prevMonth(evt:MouseEvent):void {
        manage(0, -1);
    }
    private function setToday(evt:MouseEvent):void {
        getToday();
        create(year, month);
    }
    private function nextMonth(evt:MouseEvent):void {
        manage(0, 1);
    }
    private function nextYear(evt:MouseEvent):void {
        manage(1, 0);
    }
    private function manage(y:int, m:int):void {
        year += y;
        month += m;
        if (month > 12) {
            year += 1;
            month = 1;
        }
        if (month < 1) {
            year -= 1;
            month = 12;
        }
        create(year, month);
    }
    private function manageBtns():void {
        if (year > limit) {
            yPrevBtn.enabled = true;
        } else {
            yPrevBtn.enabled = false;
        }
        var ym:uint = uint(year + ("0"+month).substr(-2));
        if (ym > uint(limit+"01")) {
            mPrevBtn.enabled = true;
        } else {
            mPrevBtn.enabled = false;
        }
    }
    private function showHelp(evt:MouseEvent):void {
        var date:CalendarDate = evt.currentTarget.date;
        if (date) help.show(date.holiday);
    }
    private function hideHelp(evt:MouseEvent):void {
        help.hide();
    }
    private function drawTitle():void {
        var tfr:TextFormat = new TextFormat();
        tfr.font = fontType;
        tfr.size = 14;
        tfr.align = TextFormatAlign.RIGHT;
        var tfl:TextFormat = new TextFormat();
        tfl.font = fontType;
        tfl.size = 14;
        tfl.align = TextFormatAlign.LEFT;
        var shade:DropShadowFilter = new DropShadowFilter(0, 90, sColor, 0.5, 2, 2, 3, 2, false, false);
        monthTitle = new TextField();
        addChild(monthTitle);
        monthTitle.x = 130;
        monthTitle.y = 0;
        monthTitle.width = 30;
        monthTitle.height = 21;
        monthTitle.type = TextFieldType.DYNAMIC;
        monthTitle.selectable = false;
        //monthTitle.embedFonts = true;
        //monthTitle.antiAliasType = AntiAliasType.ADVANCED;
        monthTitle.defaultTextFormat = tfr;
        monthTitle.textColor = 0xFFFFFF;
        monthTitle.filters = [shade];
        eTitle = new TextField();
        addChild(eTitle);
        eTitle.x = 160;
        eTitle.y = 0;
        eTitle.width = 90;
        eTitle.height = 21;
        eTitle.type = TextFieldType.DYNAMIC;
        eTitle.selectable = false;
        //eTitle.embedFonts = true;
        //eTitle.antiAliasType = AntiAliasType.ADVANCED;
        eTitle.defaultTextFormat = tfl;
        eTitle.textColor = 0xFFFFFF;
        eTitle.filters = [shade];
        yearTitle = new TextField();
        addChild(yearTitle);
        yearTitle.x = 250;
        yearTitle.y = 0;
        yearTitle.width = 40;
        yearTitle.height = 21;
        yearTitle.type = TextFieldType.DYNAMIC;
        yearTitle.selectable = false;
        //yearTitle.embedFonts = true;
        //yearTitle.antiAliasType = AntiAliasType.ADVANCED;
        yearTitle.defaultTextFormat = tfl;
        yearTitle.textColor = bColor;
        yearTitle.filters = [shade];
    }
    private function createWeek():void {
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 10;
        tf.align = TextFormatAlign.CENTER;
        for (var n:uint = 0; n < 7; n++) {
            var base:Shape = new Shape();
            addChild(base);
            base.graphics.beginFill(colors[n]);
            base.graphics.drawRect(0, 0, bWidth, wHeight);
            base.graphics.endFill();
            base.x = (bWidth + 1)*n + 1;
            base.y = hHeight + 1;
            var txt:TextField = new TextField();
            addChild(txt);
            txt.x = (bWidth + 1)*n + 11;
            txt.y = hHeight - 1;
            txt.width = 40;
            txt.height = 17;
            txt.type = TextFieldType.DYNAMIC;
            txt.selectable = false;
            //txt.embedFonts = true;
            //txt.antiAliasType = AntiAliasType.ADVANCED;
            txt.defaultTextFormat = tf;
            txt.textColor = bColor;
            txt.text = weekdays[n];
        }
    }

}


import flash.display.Sprite;
import flash.display.Shape;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.DropShadowFilter;
import flash.filters.GlowFilter;

class Day extends Sprite {
    public var date:CalendarDate;
    private var txt:TextField;
    private static var fontType:String = " i love luna 2";
    private var base:Sprite;
    private static var bWidth:uint = 60;
    private static var bHeight:uint = 44;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var sunColor:uint = 0xFF6699;
    private static var sunLight:uint = 0xFF3366;
    private static var weekColor:uint = 0x66CC00;
    private static var satColor:uint = 0x6699CC;
    private static var satLight:uint = 0x3399CC;
    private static var todayColor:uint = 0x66CC00;
    private var today:Shape;
    private var flag:Flag;

    public function Day() {
        draw();
    }

    public function init(d:CalendarDate = null, now:Boolean = false):void {
        date = d;
        var type:* = Calendar.NONE;
        var holiday:* = null;
        if (date) {
            type = date.weekday;
            holiday = date.holiday;
        }
        if (holiday) type = Calendar.HOLI;
        var bgColor:uint;
        var bgAlpha:Number;
        var filter:*;
        switch (type) {
            case 0 :
                bgColor = sunColor;
                bgAlpha = 0.16;
                filter = new GlowFilter(sunLight, 1, 2, 2, 3, 2, false, false);
                break;
            case 6 :
                bgColor = satColor;
                bgAlpha = 0.16;
                filter = new GlowFilter(satLight, 1, 2, 2, 3, 2, false, false);
                break;
            case Calendar.HOLI :
                bgColor = sunColor;
                bgAlpha = 0.16;
                filter = new GlowFilter(sunLight, 1, 2, 2, 3, 2, false, false);
                break;
            case Calendar.NONE :
                bgColor = bColor;
                bgAlpha = 1;
                filter = null;
                break;
            default :
                bgColor = bColor;
                bgAlpha = 1;
                filter = new DropShadowFilter(0, 90, sColor, 0.75, 2, 2, 3, 2, false, false, false);
                break;
        }
        base.graphics.clear();
        base.graphics.beginFill(bgColor, bgAlpha);
        base.graphics.drawRect(0, 0, bWidth, bHeight);
        base.graphics.endFill();
        if (date && date.day > 0) txt.text = String(date.day);
        if (filter) {
            txt.filters = [filter];
        } else {
            txt.filters = [];
        }
        today.visible = now;
        if (holiday) {
            flag.visible = true;
        } else {
            flag.visible = false;
        }
    }
    private function draw():void {
        base = new Sprite();
        addChild(base);
        mouseChildren = false;
        hitArea = base;
        today = new Shape();
        addChild(today);
        today.graphics.beginFill(todayColor);
        today.graphics.drawRect(0, 0, bWidth, bHeight);
        today.graphics.drawRect(1, 1, bWidth-2, bHeight-2);
        today.graphics.endFill();
        today.visible = false;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 14;
        tf.align = TextFormatAlign.CENTER;
        txt = new TextField();
        addChild(txt);
        txt.x = -3;
        txt.y = 1;
        txt.width = 28;
        txt.height = 21;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        txt.defaultTextFormat = tf;
        txt.textColor = bColor;
        flag = new Flag();
        addChild(flag);
        flag.x = 42;
        flag.y = 3;
        flag.visible = false;
    }

}


//////////////////////////////////////////////////
//    var calendar:Array = Calendar.create(2009, 5);
//    # 2009年5月のカレンダー情報(配列)を返す
//
//    var date:CalendarDate = calendar[3];
//    # 2009年5月3日のカレンダー情報(CalendarDate)を返す
//    # date のプロパティ
//    #    @year: 2009
//    #    @month: 5
//    #    @day: 3
//    #    @week: 1 (1週目)
//    #    @weekday: 0 (日曜日)
//    #    @holiday: "憲法記念日"
//
//    # 祝日については2009年以降適用
//////////////////////////////////////////////////

class Calendar {
    private static var year:uint;
    private static var month:uint;
    private static var first:uint;
    private static var days:uint;
    private static var calendarList:Object;
    private static var calendar:Array;
    private static var holidays:Array;
    private static var initialized:Boolean = init();
    public static const SUN:String = "Sun";
    public static const MON:String = "Mon";
    public static const TUE:String = "Tue";
    public static const WED:String = "Wed";
    public static const THU:String = "Thu";
    public static const FRI:String = "Fri";
    public static const SAT:String = "Sat";
    public static const NONE:String = "none";
    public static const HOLI:String = "holiday";
    public static const EQUINOX_SPRING:String = "春分の日";
    public static const EQUINOX_AUTUMN:String = "秋分の日";
    public static const HOLIDAY_IN_LIEU:String = "振替休日";
    public static const HOLIDAY_BY_LAW:String = "国民の休日";

    public function Calendar() {
    }

    private static function init():Boolean {
        if (!initialized) initialize();
        return true;
    }
    // 月の基本情報・祝日
    private static function initialize():void {
        calendarList = new Object();
        holidays = new Array();
        for (var n:uint = 1; n <= 12; n++) {
            holidays[n] = new Object();
        }
        holidays[1][1] = "元旦";
        holidays[1]["Mon2"] = "成人の日";
        holidays[2][11] = "建国記念の日";
        holidays[4][29] = "昭和の日";
        holidays[5][3] = "憲法記念日";
        holidays[5][4] = "みどりの日";
        holidays[5][5] = "こどもの日";
        holidays[7]["Mon3"] = "海の日";
        holidays[9]["Mon3"] = "敬老の日";
        holidays[10]["Mon2"] = "体育の日";
        holidays[11][3] = "文化の日";
        holidays[11][23] = "勤労感謝の日";
        holidays[12][23] = "天皇誕生日";
    }
    // カレンダー情報の配列生成
    public static function create(y:uint, m:uint):Array {
        year = y;
        month = m;
        if (year < 2009) return null;
        var monthID:String = "m" + year + ("0"+month).substr(-2);
        if (!calendarList[monthID]) {
            calendarList[monthID] = createDate();
        }
        return calendarList[monthID];
    }
    private static function createDate():Array {
        var last:Date = new Date(year, month, 0);
        days = last.getDate();
        calendar = new Array();
        if (month == 3) equinoxSpring(year);
        if (month == 9) equinoxAutumn(year);
        for (var n:uint = 0; n < days; n++) {
            var date:CalendarDate = new CalendarDate(year, month, n+1);
            var holiday:* = getHoliday(date);
            if (holiday) date.holiday = holiday;
            calendar[n+1] = date;
        }
        switch (month) {
        case 1 :
        case 2 :
        case 3 :
        case 4 :
        case 11 :
        case 12 :
            holidayInLieu();
            break;
        case 5 :
            holidayInMay();
            break;
        case 9 :
            holidayInLieu();
            holidayBetween();
            break;
        default :
            break;
        }
        return calendar;
    }
    // 祝日の基本処理
    private static function getHoliday(date:CalendarDate):* {
        var holiday1:String = holidays[date.month][date.day];
        if (date.weekday == 1) {
            var holiday2:String = holidays[date.month]["Mon"+date.week];
        }
        if (!holiday1 && !holiday2) return null;
        if (holiday1) return holiday1;
        if (holiday2) return holiday2;
    }
    // 春分・秋分の日
    private static function equinoxSpring(y:uint):void {
        var d:uint = Math.floor(20.8431+0.242194*(y-1980)-Math.floor((y-1980)/4));
        holidays[3][d] = Calendar.EQUINOX_SPRING;
    }
    private static function equinoxAutumn(y:uint):void {
        var d:uint = Math.floor(23.248+0.242194*(y-1980)-Math.floor((y-1980)/4));
        holidays[9][d] = Calendar.EQUINOX_AUTUMN;
    }
    // 振替休日・国民の休日
    private static function holidayInLieu():void {
        for (var n:uint = 0; n < days; n++) {
            var date1:CalendarDate = calendar[n+1];
            var date2:CalendarDate = calendar[n+2];
            if (date1.weekday == 0 && date1.holiday) {
                if (date2.weekday != 0 && !date2.holiday) {
                    date2.holiday = Calendar.HOLIDAY_IN_LIEU;
                }
            }
        }
    }
    private static function holidayInMay():void {
        var date1:CalendarDate = calendar[3];
        var date2:CalendarDate = calendar[4];
        var date3:CalendarDate = calendar[5];
        var date4:CalendarDate = calendar[6];
        if (date1.weekday == 0 || date2.weekday == 0 || date3.weekday == 0) {
            if (!date4.holiday) {
                date4.holiday = Calendar.HOLIDAY_IN_LIEU;
            }
        }
    }
    private static function holidayBetween():void {
        for (var n:uint = 0; n < days; n++) {
            var date1:CalendarDate = calendar[n+1];
            var date2:CalendarDate = calendar[n+2];
            var date3:CalendarDate = calendar[n+3];
            if (date1.holiday && date3.holiday) {
                if (!date2.holiday) {
                    date2.holiday = Calendar.HOLIDAY_BY_LAW;
                }
            }
        }
    }

}


class CalendarDate {
    private var _year:uint;
    private var _month:uint;
    private var _day:uint;
    private var _week:uint;
    private var _weekday:uint;
    private var _holiday:* = null;

    public function CalendarDate(y:uint, m:uint, d:uint) {
        _year = y;
        _month = m;
        _day = d;
        init();
    }

    private function init():void {
        _week = Math.floor((_day - 1)/7)+1;
        var date:Date = new Date(year, month - 1, day);
        _weekday = date.getDay();
    }
    public function get year():uint {
        return _year;
    }
    public function get month():uint {
        return _month;
    }
    public function get day():uint {
        return _day;
    }
    public function get week():uint {
        return _week;
    }
    public function get weekday():uint {
        return _weekday;
    }
    public function get holiday():String {
        return _holiday;
    }
    public function set holiday(param:String):void {
        _holiday = param;
    }

}


import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.filters.DropShadowFilter;

class HelpPanel extends Sprite {
    private var base:Sprite;
    private var panel:Shape;
    private var arrow:Shape;
    private var board:Shape;
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private var px:uint;
    private var py:uint;
    private var _width:uint = 100;
    private var _height:uint = 60;
    private var type:uint = 1;
    private static var xOffset:uint = 15;
    private static var yOffset:uint = 10;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var cColor:uint = 0xEEEEEE;
    private static var tColor:uint = 0x000000;
    private var shade:DropShadowFilter;
    private var deceleration:Number = 0.25;
    private var step:uint = 10;
    private var _visible:Boolean = false;

    public function HelpPanel() {
        if (stage) initialize();
        else addEventListener(Event.ADDED_TO_STAGE, initialize, false, 0, true);
    }

    public function init(option:Object):void {
        if (option.width != undefined) _width = option.width;
        if (option.height != undefined) _height = option.height;
        if (option.type != undefined) type = option.type;
        if (option.dec) deceleration = option.dec;
        if (option.step) step = option.step;
        draw();
    }
    private function draw():void {
        switch (type) {
        case 1 :
            bColor = 0xFFFFFF;
            cColor = 0xEEEEEE;
            tColor = 0x000000;
            break;
        case 2 :
            bColor = 0x000000;
            cColor = 0x333333;
            tColor = 0xFFFFFF;
            break;
        }
        shade = new DropShadowFilter(1, 90, sColor, 0.4, 4, 4, 1.5, 2, false, false);
        base = new Sprite();
        panel = new Shape();
        arrow = new Shape();
        board = new Shape();
        txt = new TextField();
        addChild(base);
        base.addChild(panel);
        base.addChild(arrow);
        base.addChild(board);
        base.addChild(txt);
        createBox(panel, -_width*0.5, -_height, _width, _height, 4);
        createArrow(arrow, 6, 8);
        createBase(board, -_width*0.5+5, -_height+5, _width-10, _height-10);
        base.y = - yOffset;
        txt.x = -_width*0.5 + 8;
        txt.y = -_height + 8;
        txt.width = _width - 16;
        txt.height = _height - 16;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        txt.multiline = true;
        txt.wordWrap = true;
        txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 10;
        tf.align = TextFormatAlign.LEFT;
        txt.defaultTextFormat = tf;
        txt.textColor = tColor;
        filters = [shade];
    }
    private function initialize(evt:Event = null):void {
        removeEventListener(Event.ADDED_TO_STAGE, initialize);
        visible = false;
        x = stage.stageWidth*0.5;
        y = stage.stageHeight*0.5;
        stage.addEventListener(Event.ENTER_FRAME, move, false, 0, true);
        mouseChildren = false;
        mouseEnabled = false;
    }
    private function move(evt:Event):void {
        var xMouse:uint = stage.mouseX;
        var yMouse:uint = stage.mouseY;
        if (xMouse >= 0 && xMouse <= stage.stageWidth) {
            px += (xMouse - px)*deceleration;
            py += (yMouse - py)*deceleration;
        }
        x = Math.round(px);
        y = Math.round(py);
        showPanel();
    }
    private function showPanel():void {
        var a:Number = 1/step;
        if (_visible) {
            visible = true;
            alpha += a;
            if (alpha >= 1) alpha = 1;
        } else {
            alpha -= a;
            if (alpha <= 0) {
                alpha = 0;
                visible = false;
            }
        }
    }
    public function show(t:String):void {
        txt.text = t;
        _visible = true;
    }
    public function hide():void {
        _visible = false;
    }
    private function createBox(target:Shape, x:int, y:int, w:uint, h:uint, c:uint):void {
        target.graphics.beginFill(bColor);
        target.graphics.drawRoundRect(x, y, w, h, c*2);
        target.graphics.endFill();
    }
    private function createArrow(target:Shape, w:uint, h:uint):void {
        target.graphics.beginFill(bColor);
        target.graphics.moveTo(0, 0);
        target.graphics.lineTo(-w*0.5, 0);
        target.graphics.lineTo(0, h);
        target.graphics.lineTo(w*0.5, 0);
        target.graphics.lineTo(0, 0);
        target.graphics.endFill();
    }
    private function createBase(target:Shape, x:int, y:int, w:uint, h:uint):void {
        target.graphics.beginFill(cColor);
        target.graphics.drawRect(x, y, w, h);
        target.graphics.endFill();
    }

}


import flash.display.Sprite;
import flash.display.Shape;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;
import flash.geom.ColorTransform;

class IconBtn extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var bottom:Shape;
    private var light:Shape;
    private var base:Shape;
    private var icon:Shape;
    private var _width:uint = 60;
    private static var _height:uint = 20;
    private static var corner:uint = 5;
    private var type:uint = 1;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var upColor:uint = 0x666666;
    private static var overColor:uint = 0x333333;
    private static var offColor:uint = 0x999999;
    private static var upColorTrans:ColorTransform;
    private static var overColorTrans:ColorTransform;
    private static var offColorTrans:ColorTransform;
    private var cColor:uint = 0x0099FF;
    private var colorGlow:GlowFilter;
    private var shadeGlow:GlowFilter;
    private var _clicked:Boolean = false;
    private var _enabled:Boolean = true;

    public function IconBtn(Icon:Class) {
        icon = new Icon();
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.width != undefined) _width = option.width;
        if (option.type != undefined) type = option.type;
        if (option.color != undefined) cColor = option.color;
        draw();
    }
    private function draw():void {
        switch (type) {
        case 1 :
            bColor = 0xFFFFFF;
            sColor = 0x000000;
            upColor = 0x666666;
            overColor = 0x333333;
            offColor = 0x999999;
            break;
        case 2 :
            bColor = 0x000000;
            sColor = 0xFFFFFF;
            upColor = 0x666666;
            overColor = 0x999999;
            offColor = 0x333333;
            break;
        }
        colorGlow = new GlowFilter(cColor, 0.6, 5, 5, 2, 3, false, true);
        shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);
        upColorTrans = new ColorTransform();
        upColorTrans.color = upColor;
        overColorTrans = new ColorTransform();
        overColorTrans.color = overColor;
        offColorTrans = new ColorTransform();
        offColorTrans.color = offColor;
        shade = new Shape();
        bottom = new Shape();
        light = new Shape();
        base = new Shape();
        addChild(shade);
        addChild(bottom);
        addChild(light);
        addChild(base);
        addChild(icon);
        createBase(shade, _width, _height, corner, sColor);
        shade.filters = [shadeGlow];
        createBase(bottom, _width, _height, corner, sColor, 0.3);
        createBase(light, _width, _height, corner, cColor);
        light.filters = [colorGlow];
        createBase(base, _width, _height, corner, bColor);
        icon.y = -1;
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
    }
    private function release(evt:MouseEvent):void {
        _up();
    }
    private function click(evt:MouseEvent):void {
    }
    private function _up():void {
        icon.y = -1;
        icon.transform.colorTransform = upColorTrans;
        base.y = -1;
        light.visible = false;
        light.y = -1;
    }
    private function _over():void {
        icon.y = -1;
        icon.transform.colorTransform = overColorTrans;
        base.y = -1;
        light.visible = true;
        light.y = -1;
    }
    private function _down():void {
        icon.y = 0;
        icon.transform.colorTransform = overColorTrans;
        base.y = 0;
        light.visible = true;
        light.y = 0;
    }
    private function _off():void {
        icon.y = 0;
        icon.transform.colorTransform = offColorTrans;
        base.y = 0;
        light.visible = false;
        light.y = 0;
    }
    public function get clicked():Boolean {
        return _clicked;
    }
    public function set clicked(param:Boolean):void {
        _clicked = param;
        if (_clicked) {
            _down();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
        } else {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
            _off();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
            removeEventListener(MouseEvent.CLICK, click);
        }
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w*0.5, -h*0.5, w, h, c*2);
        target.graphics.endFill();
    }

}


import flash.display.Shape;

class Today extends Shape {
    private static var bColor:uint = 0x000000;

    public function Today() {
        draw();
    }

    private function draw():void {
        graphics.beginFill(bColor);
        graphics.drawRect(-4, -4, 8, 8);
        graphics.endFill();
    }

}


import flash.display.Shape;

class Prev extends Shape {
    private static var bColor:uint = 0x000000;

    public function Prev() {
        draw();
    }

    private function draw():void {
        graphics.beginFill(bColor);
        graphics.moveTo(4, -4);
        graphics.lineTo(4, 4);
        graphics.lineTo(-6, 0);
        graphics.endFill();
    }

}


import flash.display.Shape;

class PrevDouble extends Shape {
    private static var bColor:uint = 0x000000;

    public function PrevDouble() {
        draw();
    }

    private function draw():void {
        graphics.beginFill(bColor);
        graphics.moveTo(5, -3);
        graphics.lineTo(5, 3);
        graphics.lineTo(-1, 0);
        graphics.moveTo(-1, -3);
        graphics.lineTo(-1, 3);
        graphics.lineTo(-7, 0);
        graphics.endFill();
    }

}


import flash.display.Shape;

class Next extends Shape {
    private static var bColor:uint = 0x000000;

    public function Next() {
        draw();
    }

    private function draw():void {
        graphics.beginFill(bColor);
        graphics.moveTo(-4, -4);
        graphics.lineTo(-4, 4);
        graphics.lineTo(6, 0);
        graphics.endFill();
    }

}


import flash.display.Shape;

class NextDouble extends Shape {
    private static var bColor:uint = 0x000000;

    public function NextDouble() {
        draw();
    }

    private function draw():void {
        graphics.beginFill(bColor);
        graphics.moveTo(-5, -3);
        graphics.lineTo(-5, 3);
        graphics.lineTo(1, 0);
        graphics.moveTo(1, -3);
        graphics.lineTo(1, 3);
        graphics.lineTo(7, 0);
        graphics.endFill();
    }

}

import flash.display.Shape;
import flash.filters.DropShadowFilter;

class Flag extends Shape {
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var cColor:uint = 0xFF0000;

    public function Flag() {
        draw();
    }

    private function draw():void {
        graphics.beginFill(bColor);
        graphics.drawRect(0, 0, 16, 10);
        graphics.endFill();
        graphics.beginFill(cColor);
        graphics.drawCircle(8, 5, 3);
        graphics.endFill();
        var shade:DropShadowFilter = new DropShadowFilter(0, 90, sColor, 0.5, 2, 2, 1.5, 2, false, false);
        filters = [shade];
    }

}
