/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aXYr
 */

package  {
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.Bitmap;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.display.Shape;
    import flash.utils.ByteArray;
    import flash.media.SoundMixer;
    
    [SWF(width="465", height="465", backgroundColor="0", frameRate="30")]
    
    public class Main extends Sprite{
        private const W:int = 465;
        private const H:int = 465;
        
        private var _bmd:BitmapData = new BitmapData(400, 300);
        
        private var _r:BitmapData = new BitmapData(_bmd.width, _bmd.height, true, 0xFF000000);
        private var _g:BitmapData = new BitmapData(_bmd.width, _bmd.height, true, 0xFF000000);
        private var _b:BitmapData = new BitmapData(_bmd.width, _bmd.height, true, 0xFF000000);
        
        private var _rbm:Bitmap;
        private var _gbm:Bitmap;
        private var _bbm:Bitmap;
        
        private var _camContaner:Sprite = new Sprite();
        
        private var _noiseBmd:BitmapData;
        
        private var _container:Sprite;
        private var _mask:Shape;
        
        private var _waveBytes:ByteArray = new ByteArray();
        private var _sound:SoundPlayStop;

        public function Main() {
            graphics.beginFill(0);
            graphics.drawRect(0, 0, W, H)
            graphics.endFill()
            
            setup();
        }
        
        private function setup():void {
            _container = new Sprite();
            addChild(_container);
            
            var cam:CameraCapture = new CameraCapture(400, 300, 15);
            _camContaner.addChild(cam);
            
            _mask = new Shape();
            _mask.graphics.beginFill(0);
            _mask.graphics.drawRect(10, 20, 380, 260);
            _mask.graphics.endFill()
            
            _rbm = new Bitmap(_r);
            _gbm = new Bitmap(_g);
            _bbm = new Bitmap(_b);
            
            _noiseBmd = _bmd.clone();
            
            _container.addChild(_rbm);
            _container.addChild(_gbm);
            _container.addChild(_bbm);
            addChild(_mask);
            
            _container.mask = _mask;
            
            _rbm.blendMode = _gbm.blendMode = _bbm.blendMode = "screen";
            _camContaner.x = _mask.x = _rbm.x = _gbm.x = _bbm.x = W/2 - 400/2;
            _camContaner.y = _mask.y = _rbm.y = _gbm.y = _bbm.y = H/2 - 300/2;
            
            _sound=new SoundPlayStop()
            _sound.soundStart("http://www.digifie.jp/files/100922.mp3", 100);
            addEventListener(Event.ENTER_FRAME,update);
        }
        
        private function colorSeparation():void{
            _bmd.lock();
            _bmd.draw(_camContaner);
            _noiseBmd.noise((Math.random() * 100 | 0),  127, 200, 7, false);
            _bmd.unlock();
            
            _bmd.draw(_noiseBmd, null, null, "overlay");
            _r.copyChannel(_bmd, _bmd.rect, new Point(), BitmapDataChannel.RED, BitmapDataChannel.RED);
            _g.copyChannel(_bmd, _bmd.rect, new Point(), BitmapDataChannel.GREEN, BitmapDataChannel.GREEN);
            _b.copyChannel(_bmd, _bmd.rect, new Point(), BitmapDataChannel.BLUE, BitmapDataChannel.BLUE);
        }
        
        private function update(e:Event):void{
            colorSeparation();
            //
            var n:int;
            try{
                SoundMixer.computeSpectrum(_waveBytes, true, 0);
                n = _waveBytes.readFloat() * 10;
            }catch(e:Error){
                return;
            }
            //
            _rbm.x = _camContaner.x + n;
            _gbm.x = _camContaner.x - n;
            _bbm.x = _camContaner.x + n * 2;
            //
            _rbm.y = _camContaner.y + n * 2;
            _gbm.y = _camContaner.y + n;
            _bbm.y = _camContaner.y - n;
        }

    }
    
}


// Camera
import flash.events.ActivityEvent;
import flash.events.Event;
import flash.media.Camera;
import flash.display.Sprite;
import flash.media.Video;

class CameraCapture extends Video{
    private var _cam:Camera;
    private var _camW:int;
    private var _camH:int;
    private var _fps:Number;
    private var _activityThreshold:Number;
    private var _actLevel:int;
    public static const ACTIVE:String = "active"
    public static const INACTIVE:String = "inactive"

    public function CameraCapture(camW:Number, camH:Number, fps:Number=30, activityThreshold:Number=10) {
        this.width = camW;
        this.height = camH;
        _camW = camW;
        _camH = camH;
        _fps = fps;
        _activityThreshold = activityThreshold;
        setUpCamera();
    }

    private function setUpCamera():void {
        _cam = Camera.getCamera();
        _cam.setMode(_camW, _camH, _fps);
        this.attachCamera(_cam);
        _cam.addEventListener(ActivityEvent.ACTIVITY, CamActivityCheck);
    }
        
    private function CamActivityCheck(e:ActivityEvent):void {
        if (_cam.activityLevel >= _activityThreshold) {
            dispatchEvent(new Event(CameraCapture.ACTIVE));
        } else {
            dispatchEvent(new Event(CameraCapture.INACTIVE));
        }
        _actLevel = _cam.activityLevel;
    }
        
    public function get actLevel():Number{
        return _actLevel;
    }
        
}


//Sound
import flash.events.Event;
import flash.events.EventDispatcher;
import flash.media.Sound;
import flash.media.SoundChannel;
import flash.media.SoundTransform;
import flash.media.SoundLoaderContext;
import flash.net.URLRequest;
import flash.system.Security;

class SoundPlayStop extends EventDispatcher{
        
    public var my_sc:SoundChannel;
    public var my_sound:Sound;                
    public var _flg:Boolean = true;
    
    public function SoundPlayStop(){
        Security.loadPolicyFile("http://www.digifie.jp/crossdomain.xml");
    }

    public function soundStart(Url:String, ref:uint = 1, vol:Number = 1):void {
        if(_flg){
            var trans:SoundTransform = new SoundTransform(vol,0);
            var context:SoundLoaderContext = new SoundLoaderContext(); 
            context.checkPolicyFile = true;
            //
            if (my_sc != null) {
                my_sc.stop();
                my_sc = null;
            }
            try{
                my_sound = new Sound(new URLRequest(Url),context);
                my_sc = my_sound.play(0,ref);
                my_sc.soundTransform = trans;
            }catch(e:Error){
                trace(e,Url);
            }
        }
    }

    public function soundStop():void {
        if (my_sc != null) {
            my_sc.stop();
            my_sc = null;
            my_sound = null;
        }
    }
}