/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aWwz
 */

package
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    
    [SWF(frameRate = 60, width = 465, height = 465)]
    public class Main extends Sprite
    {
        private var $score :Number = 0;
        private var scoreOutput :Output = new Output("$score: ");
        
        private var expandPhase :Boolean = false;
        private var contractPhase :Boolean = false;
        private var mouseDraw :Boolean = false;
        
        private var oldPoint :Point = new Point();
        private var newPoint :Point = new Point();
        private var clcPoint :Point = new Point();
        
        public function Main()
        {
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        }
        
        public function _init() :void
        {
            graphics.clear();
            graphics.lineStyle(1, 0, 0.75);
            graphics.drawRect(0, 0, 464, 464);
            
            if (mouseDraw)
            {
                graphics.lineStyle(5, 0, 0.5);
                
                graphics.moveTo(oldPoint.x, oldPoint.y);
                graphics.lineTo(newPoint.x, newPoint.y);
            }
        }
        
        public function addedToStage($e:Event) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            addChild(scoreOutput);
            
            _init();
            
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
        }
        
        public function onMouseDown($e:MouseEvent) :void
        {
            mouseDraw = true;
            oldPoint = new Point($e.stageX, $e.stageY);
            
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        }
        
        public function onMouseUp($e:MouseEvent) :void
        {
            stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        
            mouseDraw = false;
            expandPhase = true;
            $score = pointDistance(oldPoint, newPoint);
            scoreOutput.content = ("$score: " + $score);
        }

        public function onEnterFrame($e:Event) :void
        {
            newPoint = new Point(mouseX, mouseY);
            _init();    

            if (expandPhase)
            {
                if (contractPhase)
                {
                    scoreOutput.y -= 4;    
                        
                    if (scoreOutput.y <= 0)
                    {
                        contractPhase = expandPhase = false;
                    }
                }else{
                    scoreOutput.y = (2 * $score);
                    contractPhase = true;
                }
            }
        }
        
        public function pointDistance($start:Point, $end:Point) :Number
        {
            var $1:Number = (($start.x - $end.x) * ($start.x - $end.x));
            var $2:Number = (($start.y - $end.y) * ($start.y - $end.y));
            
            return int(Math.sqrt($1 + $2) / 10);
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.text.*;

class Output extends TextField
{
    private var textFormat :TextFormat;
    
    protected var _content :String;
    protected var _x :Number;
    protected var _y :Number;
    protected var _font :String;
    
    public function Output($content:String, $x:Number = 1, $y:Number = 0, $font:String = "Helvetica")
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _content = $content;
        _x = $x;
        _y = $y;
        _font = $font;
        
        multiline = true;
        autoSize = "left";
        selectable = mouseEnabled = false;
        antiAliasType = AntiAliasType.ADVANCED;
    }
    
    public function _init() :void
    {
        text = _content;
        x = _x;
        y = _y;
        
        textFormat = new TextFormat(_font);
        setTextFormat(textFormat);
    }
    
    public function addedToStage($e:Event) :void
    {
       removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
       
       _init(); 
    }
    
    public function get font() :String
    { return _font }
    public function get nWidth() :Number
    { return width }
    
    public function set defaultX($:Number) :void
    { _x = $;}
    public function set defaultY($:Number) :void
    { _y = $; }
    public function set font($:String) :void
    { _font = $; _init(); }
    public function set content($:String) :void
    { _content = $; _init(); }
}