/**
 * Copyright nappingjellyfish ( http://wonderfl.net/user/nappingjellyfish )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aWuq
 */

package  
{
    import away3d.cameras.Camera3D;
    import away3d.containers.ObjectContainer3D;
    import away3d.containers.Scene3D;
    import away3d.containers.View3D;
    import away3d.controllers.FirstPersonController;
    import away3d.filters.BloomFilter3D;
    import away3d.filters.BlurFilter3D;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import org.flintparticles.threeD.emitters.Emitter3D;
    import org.flintparticles.integration.away3d.v4.A3D4Renderer;
    /**
     * ...
     * @author njf
     */
    public class FlintFireForWonderfl extends Sprite
    {
        [SWF(width = "465", height = "465", frameRate = "30", backgroundColor="#000000")]
        protected var view:View3D;
        protected var camera:Camera3D;
        protected var scene:Scene3D;
        private var cameraController:FirstPersonController;
        private var renderer:A3D4Renderer;
        private var fireCenter:Emitter3D;
        private var fireOuter:Emitter3D;
        
        protected var stageX:int;
        protected var stageY:int;
        //movement variables
        protected var drag:Number = 0.5;
        protected var walkIncrement:Number = 2;
        protected var strafeIncrement:Number = 2;
        protected var walkSpeed:Number = 0;
        protected var strafeSpeed:Number = 0;
        protected var walkAcceleration:Number = 0;
        protected var strafeAcceleration:Number = 0;
        //rotation variables
        private var move:Boolean = false;
        private var lastPanAngle:Number;
        private var lastTiltAngle:Number;
        private var lastMouseX:Number;
        private var lastMouseY:Number;
        public function FlintFireForWonderfl() 
        {
            
            init();
        }
        private function init():void 
        {
            stageX = stage.stageWidth;
            stageY = stage.stageHeight;
            
            initEngine();
            initObjects();
            initListeners();
        }
        private function initEngine():void 
        {
            view = new View3D();
            scene = view.scene;
            camera = view.camera;
            camera.lens.far = 14000;
            camera.lens.near = .05;
            camera.y = 0;
            camera.z = 600;
            cameraController = new FirstPersonController(camera, 180, 0, -80, 80);
            addChild(view);
        }

        private function initObjects():void 
        {
            fireCenter = new FireCenter();
            fireOuter = new FireOuter();
            fireCenter.start();
            fireOuter.start();
            var particleContainer:ObjectContainer3D = new ObjectContainer3D();
            view.scene.addChild( particleContainer );
            renderer = new A3D4Renderer( particleContainer );
            
            renderer.addEmitter(fireCenter);
            renderer.addEmitter( fireOuter );

            view.filters3d = [new BloomFilter3D(10, 10, 0.75, 10, 3),new BlurFilter3D(10,10)];
        }
        private function initListeners():void 
        {
            addEventListener(Event.ENTER_FRAME, onEnterFrameHandler);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        }
        
        private function onEnterFrameHandler(e:Event):void 
        {
            
            if (move) {
                cameraController.panAngle = 0.3*(stage.mouseX - lastMouseX) + lastPanAngle;
                cameraController.tiltAngle = 0.3*(stage.mouseY - lastMouseY) + lastTiltAngle;
                
            }
            
            view.render();
        }
        /**
         * Mouse down listener for navigation
         */
        private function onMouseDown(event:MouseEvent):void
        {
            move = true;
            lastPanAngle = cameraController.panAngle;
            lastTiltAngle = cameraController.tiltAngle;
            lastMouseX = stage.mouseX;
            lastMouseY = stage.mouseY;
            stage.addEventListener(Event.MOUSE_LEAVE, onStageMouseLeave);
        }
        
        /**
         * Mouse up listener for navigation
         */
        private function onMouseUp(event:MouseEvent):void
        {
            move = false;
            stage.removeEventListener(Event.MOUSE_LEAVE, onStageMouseLeave);
        }
        /**
         * Mouse stage leave listener for navigation
         */
        private function onStageMouseLeave(event:Event):void
        {
            move = false;
            stage.removeEventListener(Event.MOUSE_LEAVE, onStageMouseLeave);
        }
    }

}
import away3d.entities.Mesh;
import away3d.materials.ColorMaterial;
import away3d.primitives.SphereGeometry;
import flash.geom.Vector3D;
import org.flintparticles.common.actions.Age;
import org.flintparticles.common.actions.Fade;
import org.flintparticles.common.actions.ScaleImage;
import org.flintparticles.common.counters.Steady;
import org.flintparticles.common.initializers.Lifetime;
import org.flintparticles.integration.away3d.v4.initializers.A3D4CloneObject;
import org.flintparticles.threeD.actions.Friction;
import org.flintparticles.threeD.actions.LinearDrag;
import org.flintparticles.threeD.actions.Move;
import org.flintparticles.threeD.actions.RandomDrift;
import org.flintparticles.threeD.emitters.Emitter3D;
import org.flintparticles.threeD.initializers.Velocity;
import org.flintparticles.threeD.zones.ConeZone;
class FireCenter extends Emitter3D
{
    public function FireCenter()
    {
        counter = new Steady( 20 );
  
        addInitializer( new Lifetime( 2, 3 ) );
        addInitializer( new Velocity( new ConeZone( new Vector3D( 0, 0, 0 ), new Vector3D( 0, 1, 0 ), 0.2, 40, 30 ) ) );
        var sphereGeometry:SphereGeometry = new SphereGeometry(20, 2 ,2);
        var material:ColorMaterial = new ColorMaterial(0xFFA000,0.3);
        var mesh:Mesh = new Mesh(sphereGeometry, material);
        addInitializer(new A3D4CloneObject(mesh));

        addAction( new Age( ) );
        addAction( new Move( ) );
        addAction( new LinearDrag( 0.01 ) );
        addAction( new ScaleImage( 1, 2 ) );
        addAction( new Fade( 0.5, 0 ) );
        addAction(new Friction(0.3));
        addAction( new RandomDrift( 30, 30, 30 ) );
    }
}
class FireOuter extends Emitter3D
{
    public function FireOuter()
    {
        counter = new Steady( 40 );
  
        addInitializer( new Lifetime( 2, 4 ) );
        addInitializer( new Velocity( new ConeZone( new Vector3D( 0, 0, 0 ), new Vector3D( 0, 1, 0 ), 0.8, 40, 30 ) ) );
        var sphereGeometry:SphereGeometry = new SphereGeometry(20, 2 ,2);
        var material:ColorMaterial = new ColorMaterial(0xFF0000,0.3);
        var mesh:Mesh = new Mesh(sphereGeometry, material);
        addInitializer(new A3D4CloneObject(mesh));

        addAction( new Age( ) );
        addAction( new Move( ) );
        addAction( new LinearDrag( 0.01 ) );
        addAction( new ScaleImage( 1, 2 ) );
        addAction( new Fade( 0.5, 0 ) );
        addAction(new Friction(0.3));
        addAction( new RandomDrift( 30, 30, 30 ) );
    }
}


