/**
 * Copyright hacker_szoe51ih ( http://wonderfl.net/user/hacker_szoe51ih )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aWjj
 */

// forked from umhr's Flickrの画像を表示
/*
 * Flickr Services API Documentation
 * http://www.flickr.com/services/api/
 * */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.net.navigateToURL;
    import flash.net.URLRequest;
    import flash.filters.DropShadowFilter;
    import flash.system.LoaderContext;
    
    [SWF(backgroundColor="0xCCCCCC")]
    public class Main extends Sprite {
        public function Main() {
            var myLoader:Loader = new Loader();
            var myURLRequest:URLRequest = new URLRequest("http://farm4.static.flickr.com/3467/3828917519_d209a026fb_o.jpg");
            //LoaderContextを使うと、drawできるようになる。ただしcrossdomain.xmlで許可されている場合のみ
            //これ→http://farm4.static.flickr.com/crossdomain.xml
            //var myLoaderContext:LoaderContext = new LoaderContext(true);
            myLoader.load(myURLRequest );
            myLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete);
            //Loaderごとステージに置く例
            addChild(myLoader);
            
            //ステージ上のオブジェクト全てにフィルターをかける
            filters = [new DropShadowFilter()];
            
            //flickr上の画像のページへのリンク
            addEventListener(MouseEvent.CLICK, CLICK);
        }
        
        private function CLICK(e:MouseEvent):void {
            navigateToURL(new URLRequest("http://www.flickr.com/photos/38149748@N03/3828917519/in/set-72157621937806331/") );
        }
        
        private function onComplete(e:Event):void {
            //new LoaderContext(true)にしているのでbitmap化して変形できる
            var myBitmap:Bitmap = e.target.content;
            var myBitmapData:BitmapData = new BitmapData(myBitmap.width, myBitmap.height);
            myBitmapData.draw(myBitmap);
            var mySprite:Sprite = new Sprite();
            mySprite.graphics.beginBitmapFill(myBitmapData);
            mySprite.graphics.drawRoundRect(210, 210 , 240, 240, 100, 100);
            mySprite.graphics.drawCircle(330, 330, 90);
            mySprite.graphics.drawCircle(330, 330, 70);
            addChild(mySprite);
        }
    }
}