/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aVtA
 */

package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.geom.Point;
 
	public class Main extends Sprite
	{	
		private var bd:BitmapData;
		private var prev:Point = new Point();
		private var preview:Sprite;
 
		public function Main()
		{	
			bd = new BitmapData(stage.stageWidth, stage.stageHeight, false);
			addChild(new Bitmap(bd));
 
			preview = new Sprite();
			addChild(preview);
 
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
		}
 
		private function onMouseDown(event:MouseEvent):void
		{	
			prev.x = mouseX;
			prev.y = mouseY;
 
			stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
		}
 
		private function onMouseMove(event:MouseEvent):void
		{
			preview.graphics.clear();
			preview.graphics.lineStyle(8.0, 0x0);
			preview.graphics.moveTo(prev.x, prev.y);
			preview.graphics.lineTo(mouseX, mouseY);
		}
 
		private function onMouseUp(event:MouseEvent):void
		{
			bd.draw(preview);
			preview.graphics.clear();
 
			stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
		}
	}
}
