/**
 * Copyright alpicola ( http://wonderfl.net/user/alpicola )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aVbQ
 */

// forked from alpicola's flash on 2011-5-23
package {
    import flash.display.*;
    import flash.geom.*;
    import flash.events.*;
    import flash.media.*;

    [SWF(width="465", height="465", frameRate="60")]

    public class SlitScan extends Sprite {

            private var camera:Camera;
            private var video:Video;
            private var display:BitmapData;
            private var frames:Vector.<BitmapData>;
            private var rect:Rectangle = new Rectangle();
            private var point:Point = new Point();
            private var current:int = 0;

            public function SlitScan() {
                stage.align = 'TL';
                stage.scaleMode = 'noScale';

                camera = Camera.getCamera();
                if (camera == null) return;
                camera.setMode(465, 465, 60);
                video = new Video(camera.width, camera.height);
                video.attachCamera(camera);

                display = new BitmapData(camera.width, camera.height, false);
                addChild(new Bitmap(display));

                rect.height = camera.height;
                rect.width = 1;

                frames = new Vector.<BitmapData>(camera.width, true);
                for (var i:int = 0; i < frames.length; i++) {
                    frames[i] = new BitmapData(camera.width, camera.height, false);
                }

                addEventListener(Event.ENTER_FRAME, update);
            }

            private function update(e:Event):void {
                frames[current++ % frames.length].draw(video);

                if (current > frames.length) {
                    display.lock();
                    for (var x:int = 0; x < camera.width; x++) {
                        rect.x = point.x = x;
                        display.copyPixels(frames[(current - x) % frames.length], rect, point);
                    }
                    display.unlock();
                }
            }
    }
}
