/**
 * Copyright xarple ( http://wonderfl.net/user/xarple )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aVTC
 */

////////////////////////////////////////////////////////////////////////////////
// WaveParticle
//
// [AS3.0] WaveParticleに挑戦！ (3)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1564
// [AS3.0] FontLoaderクラスに挑戦！ (1)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1337
//
// http://clockmaker.jp/blog/2011/11/starling-framework-sample/
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import flash.events.Event;
    import flash.events.ProgressEvent;
    import flash.geom.Rectangle;
    import flash.display.BlendMode;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.events.TweenEvent;
    import org.libspark.betweenas3.easing.*;

    [SWF(backgroundColor="#0473B2", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {

        private var background:Background;
       private var container:Sprite;
        private var wave:Wave;

        public function Main() {
            //Wonderfl.capture_delay(1);
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            init();
        }

        private function init():void {
            background = new Background();
            addChild(background);
            //

            //
            wave = new Wave(new Rectangle(0, 0, 465, 300));
           addChild(wave);
            wave.y = 182;
            
           wave.start();
        }


        
    }

}


//////////////////////////////////////////////////
// Waveクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.events.Event;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.geom.ColorTransform;
import flash.filters.BlurFilter;
import flash.display.BlendMode;
import frocessing.math.PerlinNoise;
//import org.libspark.utils.GeomUtil;

class Wave extends Sprite {
    private var rect:Rectangle;
    private var container:Sprite;
    private var bitmapData:BitmapData;
    private var bitmap:Bitmap;
    private var points:Array;
    private static var segments:uint = 5;
    private static var ratio:Number = 1/segments;
    private static var color:uint = 0xFFFFFF;
    private var perlin:PerlinNoise;
    private var t:Number = 0;
    private var c:uint = 0;
    private static var tightness:uint = 40;
    private static var colorTrans:ColorTransform;
    private static var blur:BlurFilter;
    private static var point:Point = new Point();

    public function Wave(r:Rectangle) {
        rect = r;
        init();
    }

    private function init():void {
        bitmapData = new BitmapData(rect.width, rect.height, true, 0x00FFFFFF);
        bitmap = new Bitmap(bitmapData);
        addChild(bitmap);
        container = new Sprite();
        addChild(container);
        container.alpha = 0.4;
        container.filters = [new BlurFilter(2, 2, 3)];
        perlin = new PerlinNoise();
        colorTrans = new ColorTransform(1, 1, 1, 0.6, 0, 0, 0, 0);
        blur = new BlurFilter(8, 8, 3);
        blendMode = BlendMode.HARDLIGHT;
    }
    public function start():void {
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
    }
    private function update(evt:Event):void {
        container.graphics.clear();
        for (var n:uint = 0; n < 6; n++) {
            var offset:Number = (n < 3) ? n*0.25 : (n + 1)*0.25;
            setup(offset);
            draw();
        }
        bitmapData.lock();
        bitmapData.draw(container, null, colorTrans, BlendMode.LAYER, rect, true);
        bitmapData.applyFilter(bitmapData, rect, point, blur);
        bitmapData.unlock();
    }
    private function setup(offset:Number):void {
        points = new Array();
        points.push(new Point(- rect.width*ratio, rect.height*0.5));
        for (var n:uint = 1; n <= segments + 1; n++) {
            var px:Number = n*rect.width*ratio;
            var py:Number = (perlin.noise(n*0.25, t + offset)*0.8 + 0.1)*rect.height;
            points.push(new Point(px - rect.width*ratio, py));
        }
        t += 0.001;
        points.push(new Point(rect.width*(1 + ratio), rect.height*0.5));
        points.unshift(points[0]);
        points.push(points[points.length - 1]);
    }
    private function draw():void {
        container.graphics.lineStyle(0, color, 0.5);
        container.graphics.moveTo(points[0].x, points[0].y);
        for (var p:uint = 0; p < points.length - 3; p++) {
            var p0:Point = points[p];
            var p1:Point = points[p + 1];
            var p2:Point = points[p + 2];
            var p3:Point = points[p + 3];
            for (var s:uint = 1; s < tightness + 1; s++) {
                //var px:Number = GeomUtil.spline(p0.x, p1.x, p2.x, p3.x, s/tightness);
                //var py:Number = GeomUtil.spline(p0.y, p1.y, p2.y, p3.y, s/tightness);
                var px:Number = spline(p0.x, p1.x, p2.x, p3.x, s/tightness);
                var py:Number = spline(p0.y, p1.y, p2.y, p3.y, s/tightness);
                container.graphics.lineTo(px, py);
            }
        }
    }
    private function spline(p0:Number, p1:Number, p2:Number, p3:Number, t:Number):Number {
        var v0:Number = (p2 - p0) * 0.5;
        var v1:Number = (p3 - p1) * 0.5;
        var t2:Number = t * t;
        var t3:Number = t2 * t;
        return (2 * p1 - 2 * p2 + v0 + v1) * t3 + ( -3 * p1 + 3 * p2 - 2 * v0 - v1) * t2 + v0 * t + p1;
    }

}



//////////////////////////////////////////////////
// Backgroundクラス
//////////////////////////////////////////////////

import flash.display.Shape;
import flash.geom.Rectangle;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;

class Background extends Shape {
    private static var colors:Array = [0x000000, 0x7f7f7f, 0xffffff];
    private static var alphas:Array = [1, 1, 1];
    private static var ratios:Array = [0, 153, 255];

    public function Background() {
        draw();
    }

    private function draw():void {
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(1600, 1600, 0, - 560, - 800);
        graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        graphics.drawRect(0, 0, 800, 600);
        graphics.endFill();
    }

}
