/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aUkt
 */

package
{
    import flash.display.*;
    import flash.events.*;
    
    [SWF(frameRate = 60, width = 465, height = 465)]
    public class Main extends Sprite
    {
        public function Main()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        }
        
        private function addedToStage($e:*) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            Buffer.initContext(this);
            
            init();
        }
    
        private function init() :void
        {
            graphics.clear();
            graphics.lineStyle(1);
            graphics.drawRect(0, 0, stage.stageWidth-1, stage.stageHeight-1);
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;
import flash.text.*;

class Buffer
{
    public static var INSTANCE_CONTEXT :Object;
    
    public static function initContext($context:Object) :void
    {
        $context.addChild(new Splash());
    }
}

class Splash extends Sprite
{
    private var _splashText :Output;
    private var _loginDialog :Login;  

    public function Splash()
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage); 

        _splashText = new Output("Welcome", 1, 0, 0, 24);
        _loginDialog = new Login((465/2 - 150), (465/2 - 75));
        
    }
    
    public function addedToStage($e:*) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);    
        
        addChild(_splashText);
        addChild(_loginDialog);
        
        init();
    }

    public function init() :void
    {
        graphics.clear();
        graphics.beginFill(0xCCCCCC);
        graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
        
        _splashText.x = (stage.stageWidth/2) - (_splashText.width/2);
        _splashText.y = (stage.stageHeight/2) - (_splashText.height*4);
    }
}

class Login extends Sprite
{
    private var _dialogUserInput :Input;
    private var _dialogPassInput :Input;
    private var _dialogButton :Button;

    protected var _x :int;
    protected var _y :int;
    protected var _width :int;
    protected var _height :int;

    public function Login($x:int, $y:int)
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);

        _x = $x;
        _y = $y;
        _width = 300;
        _height = 200;
        
        _dialogUserInput = new Input("_dialogUserInput", _x + (int(_width * 0.05)), _y + (int(_height * 0.1)));
        _dialogPassInput = new Input("_dialogPassInput", _x + (int(_width * 0.05)), _y + (int(_height * 0.25)));
        _dialogButton = new Button(_x + (int(_width * 0.8) - 43), _y + (int(_height * 0.85) - 12));
    }
    
    public function addedToStage($e:*) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        addChild(_dialogUserInput);
        addChild(_dialogPassInput);
        addChild(_dialogButton);
        
        init();
    }
    
    public function init() :void
    {
        graphics.clear();
        graphics.lineStyle(1);
        graphics.beginFill(0x999999);
        graphics.drawRect(_x, _y, _width, _height);
        graphics.endFill();
    }
    
    public function validateInput() :void
    {
        
    }
}

class Container extends Sprite
{
    public function Container()
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
    }
    
    public function addedToStage($e:*) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        init();
    }
    
    public function init() :void
    {
        
    }
}

class Button extends Sprite
{
    private var _buttonText :Output;    
    
    protected var _x :int;
    protected var _y :int;
    protected var _width :int;
    protected var _height :int;
    protected var _color :int;
    protected var _alpha :int;
    
    public function Button($x:int, $y:int)
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _x = $x;
        _y = $y;
        _width = 86;
        _height = 20;
        _alpha = 1;
        _color = 0x666666;
        
        _buttonText = new Output("_buttonText", 0, 1, 0xDDDDDD);
    }
    
    public function addedToStage($e:*) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        addChild(_buttonText);
        
        init();

        addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
        addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
    }
    
    public function init() :void
    {
        graphics.clear();
        graphics.lineStyle(1);
        graphics.beginFill(_color, _alpha);
        graphics.drawRect(_x, _y, _width, _height);
        graphics.endFill();
        
        _buttonText.x = (_x + (_width/2) - (_buttonText.width/2));
        _buttonText.y = (_y + (_height/2) - (_buttonText.height/2));
    }
    
    public function onMouseDown($e:MouseEvent) :void
    {
        _color = 0xDDDDDD;
        _buttonText.color = 0;
        init();
    }
    
    public function onMouseUp($e:MouseEvent) :void
    {
        _color = 0x666666;
        _buttonText.color = 0xFFFFFF;
        init();
    }
    
    public function buttonAction() :void
    {
    }
    
    public function get color() :Number
    {return _color}
    public override function get alpha() :Number
    {return _alpha}
    public override function get x() :Number
    {return _x}
    public override function get y() :Number
    {return _y}
    
    public function set color($:Number) :void
    {_color = $; init()}
    public override function set alpha($:Number) :void
    {_alpha = $; init()}
    public override function set x($:Number) :void
    {_x = $; init()}
    public override function set y($:Number) :void
    {_y = $; init()}
}

class Output extends TextField
{
    private var _textFormat :TextFormat;
    
    protected var _x :Number;
    protected var _y :Number;
    protected var _font :String;
    protected var _size :Number;
    protected var _color :Number;
    protected var _content :String;
        
    public function Output($content:String, $x:Number = 1, $y:Number = 0, $color:Number = 0, $size:Number = 14, $font:String = "Helvetica")
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _x = $x;
        _y = $y;
        _font = $font;
        _size = $size;
        _color = $color;
        _content = $content;
        
        selectable = mouseEnabled = false;
        autoSize = TextFieldAutoSize.LEFT;
        antiAliasType = AntiAliasType.ADVANCED;
    }
    
    public function addedToStage($e:Event) :void
    {
       removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
       
       _init(); 
    }
    
    public function _init() :void
    {
        x = _x;
        y = _y;
        text = _content;
        _textFormat = new TextFormat(_font, _size, _color);
        setTextFormat(_textFormat);
    }
    
    public function get font() :String
    { return _font }
    public function get nWidth() :Number
    { return width }
    public function get color() :Number
    { return _color }
    
    public function set font($:String) :void
    { _font = $; _init() }
    public function set content($:String) :void
    { _content = $; _init() }
    public function set color($:Number) :void
    { _color = $; _init() }
}

class Input extends TextField
{
    private var _textFormat :TextFormat;
    
    protected var _x :int;
    protected var _y :int;
    protected var _width :int;
    protected var _height :int;
    protected var _font :String;
    protected var _size :Number;
    protected var _content :String;
        
    public function Input($content:String, $x:int = 1, $y:int = 0, $width:int = 124, $height:int = 20, $size:Number = 14, $font:String = "Helvetica")
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _x = $x;
        _y = $y;
        _width = $width;
        _height = $height;
        _font = $font;
        _size = $size;
        _content = $content;
        _textFormat = new TextFormat(_font, _size);
        
        border = true;
        background = true;
        backgroundColor = 0xDDDDDD;
        type = TextFieldType.INPUT;
        defaultTextFormat = _textFormat;
        antiAliasType = AntiAliasType.ADVANCED;
    }
    
    public function addedToStage($e:Event) :void
    {
       removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
       
       _init(); 
       
       addEventListener(FocusEvent.FOCUS_IN, onFocus);
    }
    
    public function _init() :void
    {
        x = _x;
        y = _y;
        width = _width;
        height = _height;
        text = _content;
    }
    
    public function onFocus($e:FocusEvent) :void
    {
        ((text == "_dialogUserInput") || (text == "_dialogPassInput")) ? text = "" : null;
    }
    
    public function get font() :String
    { return _font }
    public function get nWidth() :Number
    { return width }
    
    public function set font($:String) :void
    { _font = $; _init() }
    public function set content($:String) :void
    { _content = $; _init() }
}
