/**
 * Copyright gupon ( http://wonderfl.net/user/gupon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aUOS
 */

// forked from gupon's Bonsajo Droste
/*
 * http://www.youtube.com/watch?v=ssTihx05mGc
 * http://www.youtube.com/watch?v=zeyzn5qnDvg
 * http://www.youtube.com/watch?v=IBheo69eI4Y
 * http://www.youtube.com/watch?v=yJ0n9P_PkBg
 * http://www.youtube.com/watch?v=0ZKvJd7oWDY
 * mouseX : 位相
 * mouseY : 曲率
 * click : chaos
 */
package{
    import flash.filters.ColorMatrixFilter;
    import flash.display.Loader;
    import flash.display.Shader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.ShaderFilter;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    
    import mx.utils.Base64Decoder;
    import mx.utils.Base64Encoder;
    
    public class YouTubeDroste extends Sprite{

        private const VIDEO_ID:Array = ["ssTihx05mGc","zeyzn5qnDvg","IBheo69eI4Y","0ZKvJd7oWDY","yJ0n9P_PkBg"];
        private var shader:Shader;
        private var filter:ShaderFilter;
        private var cmFilter:ColorMatrixFilter;
        private var count:int = 0;
        private var container:Sprite;
        private var progress:Number = 0;
        private var players:Array = [];
        private var fullSound:Boolean = false;
        
        public function YouTubeDroste(){
            if ( stage ) init();
            else addEventListener( Event.ADDED_TO_STAGE, init);
        }
        
        private function init( event:Event=null ):void{
            container = new Sprite();
            container.graphics.beginFill(0xFFFFFF);
            container.graphics.drawRect(0, 0, 800, 800);
            container.x = (stage.stageWidth - 800) / 2;
            container.y = (stage.stageHeight - 800) / 2;
            
            cmFilter = new ColorMatrixFilter();
            
            addChild(container);
            
            for(var i:int=0;i<VIDEO_ID.length;i++){
                var loader:Loader = new Loader();
                loader.load(new URLRequest("http://www.youtube.com/apiplayer?version=3"));
                loader.contentLoaderInfo.addEventListener(Event.INIT, onLoaderInit);
                container.addChild(loader);
            }
            
            applyFilter();
            stage.addEventListener( MouseEvent.MOUSE_MOVE, changeFilter );
            addEventListener( Event.ENTER_FRAME, enterFrame );
        }
        
        private function enterFrame(event:Event):void{
            progress -= 10;
            shader.data.rotate.value = [-progress/ (fullSound ? 1 : -1) / 60];
            shader.data.offsetX.value = [progress * (fullSound ? 1 : -1) * 3];
            filters = [filter, cmFilter];
        }
        
        private function changeFilter(event:MouseEvent=null):void{
            shader.data.phaseShift.value = [mouseX/2-600];
            shader.data.test.value = [ 4500 + mouseY*20 ];
        }
        
        private function applyFilter():void{
            var s:String = "hVHBbtNAEH1eb2y3CmoO3KpKFl9AuSOspkVwoUiVELdiJRvVKLEjr1tQT/4QDmmAe+9cGpVj+QJ+"
                            + "AsStJ2bGmyYuBypZrzPz5s17m68egC8beGU+PM/GlSln3TydGDtNBwZ7RW7T98VxPrGYdc9MPizK"
                            + "ZROz6MyUNityeDQcGjsos2nF9SHBJDs3w3i/LGxl4oPRyAwqXHgK6B4fnlb9oiiH+AxtywEulPaw"
                            + "NbSO4FtaxVxN0o9v0vGpwf4LyEetLG9az2rIN1dDM0pPx1WbSToK3cE4mx7d0+rfQr7/a/VjYO8X"
                            + "a5EpdV4UE8y9O51kBi6XGk9vbn7MvdY+S8quNz1JrTk6yUbVuoK4WClc34ptH91pYfsmp1+i5ZtS"
                            + "9dtvcE3ltYT1fKhiNLKmert+Qd5sdYH/hOuVRZVWphXn5dbPf6kaUWVsy/XBt3pdswnRyn3wKcET"
                            + "jSQhDa2xq/EaPiFwiZ0OFppRIwV6UIQdQuoT7x08Qp9r6QuvB9TM6ylcMS/WjFInCAg7NKd+b9nX"
                            + "VAeC5CNAzdF2AiQ89wgD8sU8+heUsOfzHvFW+wn7FWz2avgOqY6dTsz7jY70RZd57IfuxnxXB83c"
                            + "D5p71G/exe37glduv8ZDp7++p9mv4zFfNfdk/oDqDu+HqLnurmrRI9wN+T0j1CHXEZKQ5uyPf2NF"
                            + "yDX146CZ94S3AR3xXdFNnJ7wFqIXYkFUPArxfYPzRHxnBj9y92R+KTmVy0kS2F7eoTpq8sXK3Q9J"
                            + "x7s353f2G1/SjyL2LbnqyPFYN3J37nI7vSZPgseb+M1+djz82cQ2/gI=";
            var d:Base64Decoder = new Base64Decoder();
            d.decode(s);
            
            var ba:ByteArray = d.drain();
            ba.inflate();
            
            shader = new Shader(ba);
            filter = new ShaderFilter(shader);
            filters = [filter];
        }
        
        private function onLoaderInit(event:Event):void{
            var player:Object = event.target;
            player = event.target.content;
            player.addEventListener("onReady", playerReady);
        }    
        
        private function playerReady(event:Event):void{
            var player:Object = event.target;
            player.setSize(160, 120);
            player.x = count * 160;
            player.loadVideoById(VIDEO_ID[count++]);
            if (count != 1) player.setVolume(0);
            players.push(player);
            if (players.length == VIDEO_ID.length) {
                container.addEventListener(MouseEvent.CLICK, function(event:Event):void {
                    container.buttonMode = true;
                    for each (var player in players) {
                        player.setVolume(fullSound ? 0 : 100);
                    }
                    if (fullSound) players[0].setVolume(100);
                    cmFilter = new ColorMatrixFilter(fullSound ? 
                        [1, 0, 0, 0, 0,
                         0, 1, 0, 0, 0,
                         0, 0, 1, 0, 0,
                         0, 0, 0, 1, 0] : 
                         [-1, 0, 0, 0, 0xFF,
                         0, -1, 0, 0, 0xFF,
                         0, 0, -1, 0, 0xFF,
                         0, 0, 0, 1, 0]
                    );
                    filters = [filter, cmFilter];
                    fullSound = !fullSound;
                });
            }

        }
    }
}