/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aSGP
 */

// forked from siouxcitizen's 前回ソースから背景サムネイルとの連携機能を追加してみました
// forked from siouxcitizen's JSON形式で読み込まれたYoutube動画ID使って動画連続再生
// forked from fumix's youtube api
/**
 * 前回ソースから検索機能を追加してみました
 * 
 * サーチボックスに検索ワードを入力してEnterボタン押下または「Search」ボタンクリックで動画検索します
 * 
 * コンボボックスにいくつか検索キーワードの候補を設定しています　　Forkしてご希望のものを追加下さい
 * コンボボックス内の日本語キーワードはうまく表示されず。。。
 * 
 * 動画検索後、1曲目が自動的に再生される機能がうまく動かず(検索後すぐに動画が十分取り込め切れてない場合？)。。。
 * ↑この場合は動画サムネイルから再生動画をクリックして選択して下さい。。。
 *
 * 検索ボックスやコンボボックスの作成に以下のソースを参考にさせて頂きました
 * Twitterの検索z軸つき
 * http://wonderfl.net/c/g2Gi
 * flash on 2010-4-14
 * http://wonderfl.net/c/lPez
 * コンボボックス作成の参考させてもらいました
 *
 */
package {
    import com.adobe.serialization.json.JSON;

    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.text.TextField;
    import flash.text.TextFieldType;
    import com.bit101.components.ComboBox;

    /**
     * @author fumix
     */
    [SWF(backgroundColor="#FFFFFF", frameRate="31", width="465", height="465")]
    public class TestYoutube extends Sprite {
        private const APIURL : String = 'http://gdata.youtube.com/feeds/api/videos?start-index=1&max-results=50&orderby=viewCount&alt=json&vq=';
        private const KEYWORD : String = 'AKB48';
        private var _urlLoader : URLLoader;
        private var _w : int;
        private var _h : int;
        private var _jsonObject : Object;
        private var _base : Sprite;
        public  var _bollon : Balloon;

        private const YOUTUBE_PLAYER_URL : String = "http://www.youtube.com/v/lkHlnWFnA0c?version=3"; //公式ヘビーローテーションがデフォルト再生の1曲目に設定されてます
        private var _loader : Loader;
        private var _isPlayerDisp : Boolean = true ;
        public  var _player : Object;
        public  var _movieIdList : Array;
        public  var _movieIdListIndex : int = 0;

        private var _searchBox : TextField;    // 検索キーワード
        private var _box : ComboBox;           // コンボボックス(検索キーワード)
        private var _searchBtn : CustomButton; //「Search」ボタン
        public function TestYoutube() {
            if (stage) initialize();
            else addEventListener(Event.ADDED_TO_STAGE, initialize);
        }

        private function initialize(event : Event = null) : void {
            removeEventListener(Event.ADDED_TO_STAGE, initialize);
            // ステージ設定
            // stage.quality = StageQuality.LOW;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            // 背景設定
            _w = stage.stageWidth;
            _h = stage.stageHeight;
            var bmd : BitmapData = new BitmapData(_w, _h, false, 0xFFFFFF);
            addChild(new Bitmap(bmd));
            //ベース
            _base = new Sprite();
            addChild(_base);
            //吹き出し
            _bollon = new Balloon(0, 0, _w, _h);
            addChild(_bollon);
            
            // youtubeから検索結果のjsonをロード
            _urlLoader = new URLLoader();
            _urlLoader.addEventListener(Event.COMPLETE, urlLoadCompleteHandler);
            _urlLoader.load(new URLRequest(APIURL + KEYWORD));

            //Youtube Playerを取得して動画を再生
            _loader = addChild(new Loader()) as Loader;
            _loader.contentLoaderInfo.addEventListener(Event.INIT, youtubePlayerLoadCompleteHandler, false, 0, true);
            _loader.x = 10;
            _loader.y = 10;
            _loader.load(new URLRequest(YOUTUBE_PLAYER_URL));

            //var searchBox:TextField = new TextField();
            _searchBox = new TextField();
            _searchBox.text = "AKB48";
            _searchBox.width = 150;
            _searchBox.height = 18;
            _searchBox.x = 300;
            _searchBox.y = 10;
            _searchBox.border = true;
            _searchBox.borderColor = 0xFFFFFF;
            _searchBox.background = true;
            _searchBox.backgroundColor = 0x99DDFF;
            _searchBox.type = TextFieldType.INPUT;
            _searchBox.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
            addChild(_searchBox);

            //候補の検索ワードなどの設定用
            //var box:ComboBox = new ComboBox(this, 300, 30, "AKB48");
            _box = new ComboBox(this, 300, 30, "AKB48");
            _box.width = 150;
            _box.addItem("AKB48");
            _box.addItem("Perfume PV");
            _box.addItem("Aerosmith");
            _box.addItem("Bon Jovi");
            _box.addItem("U2");
            _box.addItem("Oasis");
            //コンボボックスの日本語うまく表示されません
            //box.addItem(encodeURIComponent("サザンオールスターズ"));
            //_box.addItem("サザンオールスターズ");
            _box.addEventListener(Event.SELECT, onSelect);
            addChild(_box);

            _searchBtn = new CustomButton("Search");
            _searchBtn.x = 300;
            _searchBtn.y = 70;
            _searchBtn.addEventListener(MouseEvent.MOUSE_DOWN,onSearchBtnDown);
            addChild(_searchBtn);
        }
        private function onKeyUp(event:KeyboardEvent):void {
            //Enterキーのキーコード13だったら、serchメソッドを実行。引数には適すと入力欄の文字列
            if (event.keyCode == 13) {
                //encodeURIComponent()を使うことによって、#や日本語にも対応
                _urlLoader.load(new URLRequest(APIURL + encodeURIComponent(event.currentTarget.text)));
                if (_movieIdList.lenght > 0) { //動画リストが存在する場合はプレイ開始
                    _movieIdListIndex = 0;
                    _player.loadVideoById(_movieIdList[_movieIdListIndex], 0, "default"); //１曲目再生　うまく動いてない？？？
                }
            }
        }
        private function onSelect(event:Event):void {
            var box:ComboBox = event.currentTarget as ComboBox;
            _searchBox.text = box.selectedItem.toString();
        }
        private function onSearchBtnDown(event:MouseEvent):void {
            //encodeURIComponent()を使うことによって、#や日本語にも対応
            _urlLoader.load(new URLRequest(APIURL + encodeURIComponent(_searchBox.text)));
            if (_movieIdList.lenght > 0) { //動画リストが存在する場合はプレイ開始
                _movieIdListIndex = 0;
                _player.loadVideoById(_movieIdList[_movieIdListIndex], 0, "default"); //１曲目再生　うまく動いてない？？？
            }
        }

        private function urlLoadCompleteHandler(event : Event) : void {
            _movieIdList = new Array();
            // jsonデータをobjectに
            _jsonObject = JSON.decode(event.currentTarget.data);
            for (var i : String in _jsonObject['feed']['entry']) {
                var movieId : String = String(_jsonObject['feed']['entry'][i]['id']['$t']).replace('http://gdata.youtube.com/feeds/api/videos/', '');
                _movieIdList.push(movieId);
                var url : String = "http://www.youtube.com/watch?v=" + movieId;                
                
                var thumbURL : String = _jsonObject['feed']['entry'][i]['media$group']['media$thumbnail'][0]['url'];
                var title : String = _jsonObject['feed']['entry'][i]['title']['$t'];
                var thum : ThumbImage = new ThumbImage(thumbURL, url, title, int(i)); //iの値はmovieIdListIndexの値に対応
                var c : int = Math.ceil(_w / 134);
                var cy : int = int(i) / c;
                var cx : int = int(i) - cy * c;
                var dx : Number = 134 * cx;
                var dy : Number = 101 * cy + 200; //プレイヤーの高さ約200分増やす
                thum.x = dx;
                thum.y = dy;
                _base.addChild(thum);
            }
        }

        private function youtubePlayerLoadCompleteHandler(event : Event) : void {
            _loader.content.addEventListener("onReady", onPlayerReady);
            _loader.content.addEventListener("onError", onPlayerError);
            _loader.content.addEventListener("onStateChange", onPlayerStateChange);
            _loader.content.addEventListener("onPlaybackQualityChange", onVideoPlaybackQualityChange);
        }

        private function onPlayerReady(event:Event):void {
            _player = _loader.content;

            _player.setSize(270, 180);

            if (_movieIdList.lenght < 1) _player.loadVideoById("lkHlnWFnA0c", 0, "default"); //動画IDを何も取得できなかった場合は公式ヘビーローテーションを再生します
            _player.loadVideoById(_movieIdList[_movieIdListIndex], 0, "default"); //１曲目再生
        }
        
        private function onPlayerError(event:Event):void {
            // Event.data contains the event parameter, which is the error code
        }
        
        private function onPlayerStateChange(event:Event):void {
            // Event.data contains the event parameter, which is the new player state
            //プレイヤーの状態を判定
            //未開始（-1）、終了（0）、再生中（1）、一時停止中（2）、バッファリング中（3）、頭出し済み（5）
            if (Object(event).data == "0") { //動画が終了した場合
                _movieIdListIndex++;
                if(_movieIdListIndex > _movieIdList.length - 1) return; //動画IDリストを超えた場合は処理を行わない
                _player.loadVideoById(_movieIdList[_movieIdListIndex], 0, "default");
            }
        }
        
        private function onVideoPlaybackQualityChange(event:Event):void {
            // Event.data contains the event parameter, which is the new video quality
        }
    }
}
import flash.display.Bitmap;
import flash.display.Loader;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.net.URLRequest;
import flash.net.navigateToURL;
import flash.system.LoaderContext;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;

class ThumbImage extends Sprite {
    private var _img : String;
    private var _url : String;
    private var _title : String;
    private var _index : int;

    public function ThumbImage(imageURL : String, youtubeURL : String, title : String, movieIdListIndex : int) {
        _img = imageURL;
        _url = youtubeURL;
        _title = title;
        _index = movieIdListIndex;
        buttonMode = true;
        if (stage) initialize();
        else addEventListener(Event.ADDED_TO_STAGE, initialize);
    }

    private function initialize(event : Event = null) : void {
        removeEventListener(Event.ADDED_TO_STAGE, initialize);
        // 画像のロード
        var loader : Loader = new Loader();
        loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loadCompleteHandler);
        loader.load(new URLRequest(_img), new LoaderContext(true));
        // マウスハンドラ
        addEventListener(MouseEvent.CLICK, onMouseClick);
        addEventListener(MouseEvent.ROLL_OVER, onRollOver);
        addEventListener(MouseEvent.ROLL_OUT, onRollOut);
    }

    private function onRollOut(event : MouseEvent) : void {
        var t:TestYoutube = this.parent.parent as TestYoutube;
        t._bollon.hide();
    }

    private function onRollOver(event : MouseEvent) : void {
        var t:TestYoutube = this.parent.parent as TestYoutube;
        t._bollon.show("  " + (_index+1) + ".  " +_title); //表示用に_indexに+1の加算を行う(indexの最初が0なので)
    }

    private function onMouseClick(event : MouseEvent) : void {
        var t:TestYoutube = this.parent.parent as TestYoutube;
        t._player.loadVideoById(t._movieIdList[_index], 0, "default");
        t._movieIdListIndex = _index; //
    }

    private function loadCompleteHandler(event : Event) : void {
        var bm : Bitmap = event.target.loader.content as Bitmap;
        var scale : Number = 100 / bm.height;
        bm.height = 100;
        bm.scaleX = scale;
        bm.smoothing = true;
        addChild(bm);
    }
}
class Balloon extends Sprite {
    private var _tl : TextField;
    private var _top : int;
    private var _left : int;
    private var _right : int;
    private var _bottom : int;
    private var _sp : Sprite;

    public function Balloon(top : int, left : int, right : int, bottom : int) {
        _sp = new Sprite();
        _sp.graphics.lineStyle(0.1, 0xFFFFFF);
        _sp.graphics.beginFill(0x000000);
        _sp.graphics.drawRect(0, 0, 124, 20);
        _sp.graphics.endFill();
        addChild(_sp);
        _tl = new TextField();
        _tl.wordWrap = true;
        _tl.autoSize = TextFieldAutoSize.LEFT;
        _tl.width = 180;
        _tl.textColor = 0xFFFFFF;
        _tl.x = _tl.y = 2;
        addChild(_tl);

        _top = top;
        _left = left;
        _right = right;
        _bottom = bottom;
        visible = false;
        mouseEnabled = false;
        mouseChildren = false;
    }

    public function show(text : String) : void {
        _tl.text = text;
        _sp.width = _tl.width + 4;
        _sp.height = _tl.textHeight + 8;
        visible = true;
        addEventListener(Event.ENTER_FRAME, enterFrameHandler);
    }

    public function hide() : void {
        removeEventListener(Event.ENTER_FRAME, enterFrameHandler);
        visible = false;
    }

    private function enterFrameHandler(event : Event) : void {
        x = stage.mouseX + 5;
        y = stage.mouseY + 5;
        if (x > _right - width) x = x - width - 5;
        if (y > _bottom - height) y = y - height - 5;
    }
}
import flash.display.*;
import flash.system.*;
import flash.text.*;
//カスタムボタン
class CustomButton extends SimpleButton {
    private var btnName : String = "";//ボタン名
    private var btnNo : int = 0;//ボタン番号
    //コンストラクタ    
    public function CustomButton(label:String="",no:int=0) {
        btnName = label;
        btnNo = no;
        //状態
        upState = makeSprite(label,0x99DDFF);
        overState = upState;
        downState = makeSprite(label,0x0000FF);
        hitTestState = upState;
    }
    public function getBtnName():String {
        return btnName;
    }
    public function getBtnNo():int {
        return btnNo;
    }
    //ボタン用スプライト作成
    private function makeSprite(text:String,color:uint):Sprite{
        //ボタン用ラベル作成
        var label : TextField = new TextField();
        label.text = text;
        label.autoSize = TextFieldAutoSize.CENTER;
        label.selectable = false;
        //ボタン用スプライト作成
        var sp:Sprite = new Sprite();
        sp.graphics.beginFill(color);
        sp.graphics.drawRoundRect(0, 0, 100, 20, 15);
        sp.graphics.endFill();
        sp.alpha = 0.8;            
        sp.addChild(label);
        //ラベル用フォーマット設定
        var format:TextFormat=new TextFormat();
        format.font = "Courier New";
        format.bold = true;
        format.size = 13;
        label.setTextFormat(format);
        return sp;
    }
}