/**
 * Copyright Quasimondo ( http://wonderfl.net/user/Quasimondo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aS6I
 */

// forked from Quasimondo's Dynamic Interpolation
package {
    import flash.display.Sprite;
    public class DynamicInterpolation2 extends Sprite {
        public function DynamicInterpolation2() {
            
            var left:Number = 0.3;
            var right:Number = 0.7;
            var scaleFactor:Number = 2.2;
            
            
            graphics.lineStyle(0,0);
            graphics.drawRect(0,0,200,200);
            
           
            for ( var i:int = 0; i < 100; i++ )
            {
                var v:Number = interpolate(i / 100,left, right,scaleFactor);
                graphics.drawCircle( i * 2, v * 200,1 );
             }
        }
        
        // all arguments must be in the range 0...1
        private function interpolate( value:Number, left:Number = 0.25, right:Number = 0.75, factor:Number = 1 ):Number
        {
            var mid:Number;
            if ( value < left )
            {
               value = (1 - Math.pow( 1 - value * ( 1 / left), factor )) * left ;
            } else if ( value > right ) {
               value = Math.pow( (value - right) * ( 1 / ( 1 - right)), factor ) * ( 1 - right) + right;
            } if ( value < (mid = 0.5 * (left +right)))
            {
               value = (1 - Math.pow( 1 - value * ( 1 / mid), 1 / factor )) * mid ;
            } else {
               value = Math.pow( (value - mid) * ( 1 / ( 1 - mid)), 1 / factor ) * ( 1 - mid) + mid;
            }
            return value;
        }

    }
}