/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aRQy
 */

package
{
    import flash.display.*;
    import flash.system.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.text.*;
    
    [SWF(width = 465, height = 465, frameRate = 60)]
    public class Main extends Sprite
    {    
        public function Main()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;            
            
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);    
        }
        
        public function _init() :void
        {
            graphics.clear     ();
            graphics.lineStyle (1, 0, 0.9);
            graphics.drawRect  (0, 0, 464, 464);
        }
        
        public function addedToStage($e:Event) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            Buffer.canvasGlobal = this.parent;
            Buffer.canvasArray = [new Projectile];
            Buffer.initBuffer();
            
            _init();
        }
    }
}

import flash.display.*;
import flash.system.*;
import flash.events.*;
import flash.geom.*;
import flash.text.*;

class Buffer
{
    public static var canvasGlobal :Object;
    public static var canvasArray :Array;
    
    public static function initBuffer() :void
    {
        for (var i:Number = 0; i < canvasArray.length; i++)
            {canvasGlobal.addChild(canvasArray[i])}
    }
}

class Wall extends Sprite
{
    
}

class Projectile extends Sprite
{
    protected var _x :Number = 1;
    protected var _y :Number = 1;
    protected var _vX :Number = 0;
    protected var _vY :Number = 0;    
    
    public function Projectile()
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
    }
    
    public function _init() :void
    {
        graphics.clear     ();
        graphics.lineStyle (1, 0, 0.9);
        
        graphics.beginFill  (0, 0.33);
        graphics.drawCircle ((_x += _vX), (_y += _vY), 2);
        graphics.endFill    ();
    }
    
    public function addedToStage($e:Event) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _init();
        
        parent.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
        addEventListener(Event.ENTER_FRAME, update);
    }
    
    public function onMouseDown($e:MouseEvent) :void
    {
        vX = ($e.stageX - x) / $e.stageX;
        vY = ($e.stageY - y) / $e.stageY;
    }
    
    public function update($e:Event) :void
    {
        _init();
    }

    public function get vX() :Number
    { return _vX }
    public function get vY() :Number
    { return _vY }
    public override function get x() :Number
    { return _x }
    public override function get y() :Number
    { return _y }
    
    public function set vX($:Number) :void
    { _vX = $; _init(); }
    public function set vY($:Number) :void
    { _vY = $; _init(); }
    public override function set x($:Number) :void
    { _x = $; _init(); }
    public override function set y($:Number) :void
    { _y = $; _init(); }
}

class Body extends Sprite
{
    public function Body()
    {
        
    }
}

class Text_Output extends TextField
{
    private var textFormat :TextFormat;
    
    protected var _content :String;
    protected var _x :Number;
    protected var _y :Number;
    protected var _font :String;
    
    public function Text_Output($content:String, $x:Number, $y:Number, $font:String = "Helvetica")
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _content = $content;
        _x = $x;
        _y = $y;
        _font = $font;
        
        multiline = true;
        autoSize = "left";
        selectable = mouseEnabled = false;
        antiAliasType = AntiAliasType.ADVANCED;
    }
    
    public function _init() :void
    {
        text = _content;
        x = _x;
        y = _y;
        
        textFormat = new TextFormat(_font);
        setTextFormat(textFormat);
    }
    
    public function addedToStage($e:Event) :void
    {
       removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
       
       _init(); 
    }
    
    public function get font() :String
    { return _font }
    
    public function set font($:String) :void
    { _font = $; _init(); }
}