/**
 * Copyright Andras ( http://wonderfl.net/user/Andras )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aPwp
 */

package {
    
    import flash.display.Sprite;
    public class Futtato extends Sprite {
        public function Futtato():void
        {
            var h:Homokora = new Homokora
            h.x = stage.stageWidth / 2
            h.y = stage.stageHeight / 2
            addChild(h)
        }
    }   
}

import flash.display.Sprite;
import flash.events.Event;
class Homokora extends Sprite {

    public var M:uint  //Magasság egység
    public var N:uint  //Nagy egység
    public var K:uint  //Kis egység
    
    public var Et:Number  //Egység táv
    public var Anim:Object
    
    public function Homokora():void
    {
        M = 18
        N = 10
        K = 1
        
        Et = 10
        
        Anim = {}
        mozgatastIndit()
    }
    
    
    public function rajzol(sz:Number):void
    {
        sz = Math.cos(Math.PI + Math.PI/2 * sz) + 1
        
        var i:uint
        var Xs:Number = (N - K) / M
        var Ys:Number =  M / (N - K) * Xs
        var k:Object = {}  //részeredmények
        
        k.ub = sz * M - (M-1)//utolsó beosztás
        k.ub = k.ub > 0 ? k.ub : 0
        
        k.eb = sz * M - 1//utolsó beosztás
        k.eb = k.eb < 0 ? -k.eb : 0
        
        k.lefY = (M - 1) -  (M - 1) * sz
        
        graphics.clear()
        graphics.lineStyle(1, 0x666666)
        
        if(sz < 0){ sz = 0 }
        else if(sz > 1){ sz = 1 }
        
        //Első oldal
        mt(K+Xs*(1-k.ub), Ys*(1-k.ub))
        lt(N, M)
        lt(-N, M)
        lt(-N + Xs, M - Ys )
        
        //Alsó homok
        for(i = 0; i < (N-1)*2; i+= 2)
        {
            k.xTav = N - Xs * 3
            k.yTav = M - Ys
            
            k.x2 = -k.xTav + i
            k.y2 = k.yTav
            
            k.x3 = -k.xTav + i + 1
            k.y3 = k.yTav
            
            k.x0 = (-k.xTav + i - 1) - k.xTav * sz
            k.y0 = k.yTav * (1 - sz)
            
            k.x1 = (-k.xTav + i) - k.xTav * sz
            k.y1 = k.yTav * (1 - sz)
            
            if(k.y1 < k.yTav - (i+1) * Ys)
            {
                k.y1 = k.yTav - (i+1) * Ys
                k.x1 = -N + Xs * (i+2)
            }
            
            if(k.y0 < k.yTav - i * Ys)
            {
                k.y0 = k.yTav - i * Ys
                k.x0 = -N + Xs * (i+1)
                
                k.x05 = k.x0 + (2 * Xs) - (k.x1 - k.x0)
                k.y05 = k.y1
            } else {
                k.x05 = k.x0
                k.y05 = k.y0
            }
            
            if(k.x1 < 0 && k.x1 + 1 > 0)
            {
                k.lefY = (M - 1) -  (M - 1) * sz + (-1*k.x1) * 2*Ys
            }
            
            lt(k.x0, k.y0)
            lt(k.x05, k.y05)
            lt(k.x1, k.y1)
            lt(k.x2, k.y2)
            lt(k.x3, k.y3)
        }
        
        lt((-(N - Xs * 3) + i - 1) - (N - Xs * 3) * sz,
           (M - Ys) * (1 - sz))
        
        //Második oldal
            k.r1 = -N + 2*Xs + (N-K-Xs) * sz
            k.r2 = M - (2 + (M - 1) * sz)
            
        mt(k.r1 > -K ? -K : k.r1,
           k.r2 < 0 ? 0 : k.r2)
        if(k.ub)
        {
            mt(-K - k.ub * Xs, 0 - k.ub * Ys)
        } else {
            lt(-K, 0)
        }
            
        lt(-N, -M)
        lt(N, -M)
        lt(N-Xs, -M+1)
        
        if(k.eb)
        {
            lt(N - Xs * (1+k.eb), -M + Ys * (1+k.eb))
        } else {
            k.sz2 = (sz * M - 1) / (M - 1) * 3
            if(k.sz2 < 0){ k.sz2 = 0 }
            if(k.sz2 > 1){ k.sz2 = 1 }
            lt(N-Xs - (N-2*Xs) * 2 * k.sz2, -M+1)
        }
        
        
        
        //Felső homok
        mt(N - 2*Xs, -M + 2*Ys)
        
        for(i = 0; i < (N-1)*2; i+= 2)
        {
            k.x0 = N - ((2+i)*Xs)
            k.y0 = -M + ((2+i)*Ys)
            
            k.x1 = N - ((3*Xs + i) - (N-3*Xs) * sz)
            k.y1 = (-M+1) * (1-sz)
            
            k.x2 = N - ((3*Xs + i+1) - (N-3*Xs) * sz)
            k.y2 = (-M+1) * (1-sz)
            
            k.x3 = N - ((3+i)*Xs)
            k.y3 = -M + ((3+i)*Ys)
            
            if(k.x1 > k.x0)
            {
                if(k.x1 < k.x0 + Xs)
                {
                    k.x1  = k.x0 - (k.x1 - k.x0)
                    k.y1  = k.y2
                } else {
                    k.x1 = k.x3
                    k.y1 = k.y3
                }
            }
            
            k.x2 = k.x2 > k.x3 ? k.x3 : k.x2
            k.y2 = k.y2 > k.y3 ? k.y3 : k.y2
            
            if(k.y3 > 0)
            {
                k.x3 = 0
                k.y3 = 0
            }
            
            lt(k.x0, k.y0)
            
            if(i == (N-1)*2 - 2 && sz > .999)
            { break }
            
            lt(k.x1, k.y1)
            lt(k.x2, k.y2)
            lt(k.x3, k.y3)
        }
        
        //lefolyó homok
        mt(-1 / (Et*2),0)
        if(k.lefY > M-1){ k.lefY = M-1 }
        if(sz >= .99){ k.lefY = 0 }
        if(sz < .025){ k.lefY = (M - 1) -  (M - 1) * (.025 - sz) * 40}
        
        
        lt(-1 / (Et*2), k.lefY)
        
        //////////////////////////////////////
        
        function mt(xp:Number, yp:Number):void
        { graphics.moveTo(xp * Et, yp * Et) }
        
        function lt(xp:Number, yp:Number):void
        { graphics.lineTo(xp * Et, yp * Et) }
    }
    
    
    //////////////////////////////
    ////// Animáló funkciók //////
    //////////////////////////////
    
    public function mozgatastIndit():void
    {
        Anim.szazalek = 0
        addEventListener(Event.ENTER_FRAME, leperegEF)
    }
    
    public function leperegEF(e:Event):void
    {
        Anim.szazalek += .012
        if(Anim.szazalek >= 1)
        {
            Anim.szazalek = 1
            removeEventListener(Event.ENTER_FRAME, leperegEF)
            addEventListener(Event.ENTER_FRAME, forgatEF)
        }
        rajzol(Anim.szazalek)
    }
    
    public function forgatEF(e:Event):void
    {
        rotation += 8
        if(rotation <= 0)
        {
            rotation = 0
            removeEventListener(Event.ENTER_FRAME, forgatEF)
            addEventListener(Event.ENTER_FRAME, leperegEF)
            Anim.szazalek = 0
            rajzol(Anim.szazalek)
        }
    }
}
