/**
 * Copyright John_Blackburne ( http://wonderfl.net/user/John_Blackburne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aPqb
 */

package
{
	import flash.Boot;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flash.ui.Keyboard;
 
	import nape.geom.*;
	import nape.phys.*;
	import nape.space.*;
	import nape.util.*;
 
	[SWF(width="800", height="600", backgroundColor="#ffffff")]
 
	public class Main extends Sprite
	{
		private var kUp:Boolean = false;
		private var kDn:Boolean = false;
		private var kLt:Boolean = false;
		private var kRt:Boolean = false;
		static public var space:Space;
		static public var prop:Properties;
		private var mPlayer:Body;
		public function Main()
		{
			new Boot(); // <---- Necessary for Nape (or any other haXe library)
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
 
		private function init(e:Event = null):void
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
 
			space = new UniformSleepSpace(new AABB(0,0,800,600),15);
			var material:Material = new Material(1, 1, 100, 1);
			//create NAPE text representation
			var tf:TextFormat = new TextFormat();
			tf.bold = true;
			tf.font = "Verdana";
			tf.size = 35;
 
			var text:TextField = new TextField();
			text.text = "NAPE";
			text.setTextFormat(tf);
			text.autoSize = TextFieldAutoSize.LEFT;
			var bit:BitmapData = new BitmapData(int(text.width), int(text.height), false, 0xffffff);
			bit.draw(text);
 
			//MASSIVE air resistance
			prop = new Properties(0.005, 0.005);
 
			var b:Body;
			for (var x:uint = 0; x < bit.width; x++)
			{
				for (var y:uint = 0; y < bit.height; y++)
				{
					if ((bit.getPixel(x, y) & 0xff) < 0x80)
					{
						space.addObject(b = Tools.createBox(20 + x * 7, 120 + y * 7, 7, 7, 0, 0, 0, true, Material.Ice, 1, 0, prop));
						addChild(b.graphic);
					}
				}
			}
 
			
			
			//set graphical quality to medium
			stage.quality = StageQuality.MEDIUM;
			stage.frameRate = 60;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			space.addObject(mPlayer = Tools.createBox(0, 0, 14, 14, 0, 0, 0, false, Material.Ice, 1, 0, prop));
			addChild(mPlayer.graphic);
			
			mPlayer.stopRotation();
			//set up events
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			//stage.addEventListener(MouseEvent.MOUSE_DOWN, mdown);
			stage.addEventListener(KeyboardEvent.KEY_DOWN, keydown);
			stage.addEventListener(KeyboardEvent.KEY_UP, keyup);
		}
 
	

		
		
		
		private function onEnterFrame(e:Event):void {
			var velx:int = 0;
			var vely:int = 0;
			if (this.kLt) {
				velx -= 100;
			}
			if (this.kRt) {
				velx += 100;
			}
			if (this.kUp) {
				vely -= 100;
			}
			if (this.kDn) {
				vely += 100;
			}
			mPlayer.vx = velx;
			mPlayer.vy = vely;
		   //mPlayer.setVel( velx, vely);
			space.wakeObject(mPlayer); 

	
			space.step(1/60, 1,1);
		}
		
		



		
		private function keyup(keyEvent:KeyboardEvent) {
			switch(keyEvent.keyCode){
				case Keyboard.LEFT:
					kLt = false;
					break;
				case Keyboard.RIGHT:
					kRt = false;
					break;
				case Keyboard.UP:
					kUp = false;
					break;
				case Keyboard.DOWN:
					kDn = false;
					break;
			}
		}
		
		private function keydown(keyEvent:KeyboardEvent) {
			switch(keyEvent.keyCode){
				case Keyboard.LEFT:
					kLt = true;
					break;
				case Keyboard.RIGHT:
					kRt = true;
					break;
				case Keyboard.UP:
					kUp = true;
					break;
				case Keyboard.DOWN:
					kDn = true;
					break;
			}
		}
	}
}