/**
 * Copyright asuka616 ( http://wonderfl.net/user/asuka616 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aOug
 */

// forked from ProjectNya's IkekouTune
////////////////////////////////////////////////////////////////////////////////
// IkekouTune
//
// [AS3.0] LightTuneクラスだ！ (4)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1158
//
// 背景を暗くするのに ColorTransform を用いた
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.geom.Rectangle;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Loader;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.net.URLRequest;
    import flash.system.Security;
    import flash.system.LoaderContext;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var loader:Loader;
        private static var imagePath:String = "http://a2.twimg.com/profile_images/1258323989/twitter_icon_newyear5.png";
        private var ikekou:BitmapData;
        private var playBtn:Btn;
        private var light:LightTune;
        private var initialized:Boolean = false;
        private var loaded:Boolean = false;

        public function Main() {
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            Security.allowDomain("a0.twimg.com");
            Security.loadPolicyFile("http://a0.twimg.com/crossdomain.xml");
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, initialize, false, 0, true);
            loader.load(new URLRequest(imagePath), new LoaderContext(true));
            //
            var rect:Rectangle = new Rectangle(0, 0, 465, 465);
            light = new LightTune(rect);
            addChild(light);
            light.addEventListener(Event.COMPLETE, complete, false, 0, true);
            //light.start();
            playBtn = new Btn();
            playBtn.x = 232;
            playBtn.y = 232;
            addChild(playBtn);
            playBtn.buttonMode = true;
            playBtn.addEventListener(MouseEvent.CLICK, click, false, 0, true);
        }
        private function initialize(evt:Event):void {
            loader.removeEventListener(Event.COMPLETE, initialize);
            ikekou = Bitmap(loader.content).bitmapData;
            initialized = true;
            setup();
        }
        private function complete(evt:Event):void {
            loaded = true;
            setup();
        }
        private function setup():void {
            if (initialized && loaded) {
                playBtn.setup(ikekou);
                playBtn.start();
                light.setup(ikekou);
            }
        }
        private function click(evt:MouseEvent):void {
            playBtn.stop();
            playBtn.removeEventListener(MouseEvent.CLICK, click);
            removeChild(playBtn);
            light.start();
        }

    }

}


import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.geom.Matrix;
import flash.filters.BlurFilter;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.events.Event;
//ColorTransform
import flash.geom.ColorTransform;
import flash.media.Sound;
import flash.media.SoundChannel;
import flash.media.SoundLoaderContext;
import flash.media.SoundMixer;
import flash.utils.ByteArray;
import flash.net.URLRequest;
import flash.system.Security;

class LightTune extends Sprite {
    private var rect:Rectangle;
    private var canvas:BitmapData;
    private var bitmapData:BitmapData;
    private static var scale:Number = 1.25;
    private var matrix:Matrix;
    private var blur:BlurFilter;
    private static var point:Point = new Point();
    private var light:EmitLight;
    //ColorTransform
    private var colorTrans:ColorTransform;
    private static var policyPath:String = "http://www.project-nya.jp/crossdomain.xml";
    private var sound:Sound;
    private var channel:SoundChannel;
    private static var soundPath:String = "http://www.project-nya.jp/images/flash/robotwarrior.mp3";
    private var byteArray:ByteArray;
    private static var channels:uint = 256;
    private var factors:uint = 0;
    private var ikekou:BitmapData;

    public function LightTune(r:Rectangle) {
        rect = r;
        init();
    }

    private function init():void {
        Security.loadPolicyFile(policyPath);
        sound = new Sound();
        sound.addEventListener(Event.COMPLETE, complete, false, 0, true);
        sound.load(new URLRequest(soundPath), new SoundLoaderContext(10, true));
        byteArray = new ByteArray();
    }
    public function setup(bd:BitmapData):void {
        ikekou = bd;
        //
        canvas = new BitmapData(rect.width, rect.height, true, 0xFF000000);
        addChild(new Bitmap(canvas));
        bitmapData = new BitmapData(rect.width, rect.height, false, 0xFF000000);
        matrix = new Matrix();
        matrix.scale(scale, scale);
        var w:int = (rect.width - rect.width*scale)*0.5;
        var h:int = (rect.height - rect.height*scale)*0.5;
        matrix.translate(w, h);
        blur = new BlurFilter(1, 1, 3);
        light = new EmitLight(ikekou);
        addChild(light);
        light.initialize(40);
        light.x = rect.width*0.5;
        light.y = rect.height*0.5;
        //ColorTransform
        colorTrans = new ColorTransform(0.96, 0.96, 0.96, 1, 0, 0, 0, 0);
    }
    private function complete(evt:Event):void {
        evt.target.removeEventListener(Event.COMPLETE, complete);
        //start();
        dispatchEvent(evt);
    }
    public function start():void {
        channel = sound.play(0, 1000);
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
    }
    private function update(evt:Event):void {
        SoundMixer.computeSpectrum(byteArray, true, factors);
        var data:Array = new Array();
        for (var n:uint = 0; n < channels; n++) {
            var p:Number = byteArray.readFloat();
                data.push(p);
        }
        draw(data);
    }
    private function draw(data:Array):void {
        light.create(data);
        bitmapData.lock();
        bitmapData.draw(this);
        bitmapData.applyFilter(bitmapData, rect, point, blur);
        bitmapData.unlock();
        canvas.lock();
        //ColorTransform
        canvas.draw(bitmapData, matrix, colorTrans, null, rect, true);
        canvas.unlock();
        light.emit();
    }

}


import flash.display.Sprite;
import flash.geom.Rectangle;
import flash.display.BlendMode;
import flash.display.BitmapData;

class EmitLight extends Sprite {
    private var radius:uint;
    private var circles:Array;
    private static var deceleration:Number = 0.9;
    private var id:uint;
    private var bitmapData:BitmapData;

    public function EmitLight(bd:BitmapData) {
        bitmapData = bd;
        init();
    }

    private function init():void {
        circles = new Array();
    }
    public function initialize(r:uint):void {
        radius = r;
    }
    public function create(data:Array):void {
        id ++;
        var angle:uint = id*3%360;
        var circle:Ikekou = new Ikekou(bitmapData);
        addChild(circle);
        circle.x = Math.cos(-angle*Math.PI/180)*radius;
        circle.y = Math.sin(-angle*Math.PI/180)*radius;
        circle.vx = (Math.random()*2 - 1)*20;
        circle.vy = (Math.random()*2 - 1)*20;
        circle.scale = data[1];
        circle.blendMode = BlendMode.HARDLIGHT;
        circles.push(circle);
    }
    public function emit():void {
        for (var n:uint = 0; n < circles.length; n++) {
            var circle:Ikekou = circles[n];
            circle.vx *= deceleration;
            circle.vy *= deceleration;
            circle.x += circle.vx;
            circle.y += circle.vy;
            circle.scale *= deceleration;
            if (circle.scale < 0.1) {
                circles.splice(n, 1);
                removeChild(circle);
                circle = null;
            }
        }
    }

}


import flash.display.Sprite;
import flash.display.Loader;
import flash.events.Event;
import flash.display.Bitmap;

class Ikekou extends Sprite {
    private var icon:Bitmap;
    private var bitmapData:BitmapData;
    private var _scale:Number = 1;
    public var vx:Number = 0;
    public var vy:Number = 0;

    public function Ikekou(bd:BitmapData) {
        bitmapData = bd;
        draw();
    }

    private function draw():void {
        icon = new Bitmap(bitmapData.clone());
        addChild(icon);
        icon.smoothing = true;
        addChild(icon);
        icon.x = - (icon.width)/2;
        icon.y = - (icon.height)/2;
        icon.scaleX = icon.scaleY = 0.5;
    }
    public function get scale():Number {
        return _scale;
    }
    public function set scale(param:Number):void {
        _scale = param;
        scaleX = scaleY = _scale;
    }

}


import flash.display.Sprite;
import flash.events.Event;
import flash.display.BitmapData;
import flash.display.Bitmap;

class Btn extends Sprite {
    private var icon:Bitmap;
    private var bitmapData:BitmapData;
    private static var baseScale:Number = 0.4;
    private static var targetScale:Number = 0.7;
    private var scale:Number = baseScale;
    private var amplitude:Number = 0;
    private static var deceleration:Number = 0.85;
    private static var friction:Number = 0.8;
    private static var acceleration:Number = 0.4;

    public function Btn() {
    }

    public function setup(bd:BitmapData):void {
        bitmapData = bd;
        draw();
    }
    private function draw():void {
        icon = new Bitmap(bitmapData.clone());
        addChild(icon);
        icon.smoothing = true;
        addChild(icon);
        icon.x = - (icon.width)/2;
        icon.y = - (icon.height)/2;
    }
    public function start():void {
        addEventListener(Event.ENTER_FRAME, elastic, false, 0, true);
    }
    public function stop():void {
        removeEventListener(Event.ENTER_FRAME, elastic);
        removeEventListener(Event.ENTER_FRAME, slide);
    }
    private function elastic(evt:Event):void {
        amplitude += targetScale - scale;
        scale += amplitude*friction;
        amplitude *= deceleration;
        scaleX = scaleY = scale;
        if (Math.abs(targetScale - scale) < 0.005 && Math.abs(amplitude) < 0.001) {
            removeEventListener(Event.ENTER_FRAME, elastic);
            amplitude = 0;
            scale = targetScale;
            scaleX = scaleY = targetScale;
            addEventListener(Event.ENTER_FRAME, slide, false, 0, true);
        }
    }
    private function slide(evt:Event):void {
        scale += (baseScale - scale)*acceleration;
        scaleX = scaleY = scale;
        if (Math.abs(baseScale - scale) < 0.005) {
            removeEventListener(Event.ENTER_FRAME, slide);
            scale = baseScale;
            scaleX = scaleY = baseScale;
            addEventListener(Event.ENTER_FRAME, elastic, false, 0, true);
        }
    }

}