/**
 * Copyright aizikdahan ( http://wonderfl.net/user/aizikdahan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aOUw
 */

// forked from namaakubi's IRONMAN　Core
/*
 * 映画「IRONMAN」を見て
 * 主人公の胸にあるコアを作ってみた
 * 
 * 扇形を描画するのに使用させて頂きました
 * Pure AS3 RSS Icon
 * http://wonderfl.net/code/388343fb8d8e695a631a268efc72d3021b843d84
 * 
 * マウスをステージ中央に移動すると回転が止まる
 */
package  
{
    import flash.events.Event;
    import flash.display.Sprite;
    import flash.display.Graphics;
    import flash.filters.GlowFilter;
    import flash.filters.DropShadowFilter;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import net.hires.debug.Stats;
    
    [ SWF( width = "500" , height = "500" , backgroundColor = "0x000000" , frameRate = "60" ) ]
    public class Ironman extends Sprite
    {
        private var pieList:Array = new Array();
        private var glow:GlowFilter;
        private var dropShadow:DropShadowFilter;
        private var scx:Number;
        
        public function Ironman()
        {
            glow = new GlowFilter( 0x00ffff, 0.5, 8, 8, 2, 3, false, false );
            dropShadow = new DropShadowFilter( 0, 45, 0x0033cc, 0.8, 10, 10, 1, 3, false, false, false );
            
            scx = stage.stageWidth / 2;
            
            //stats
            addChild(new Stats());
            
            //枠円の描画
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox( 200, 200, Math.PI / 4 );
            var frameCircle:Sprite = new Sprite();
            frameCircle.graphics.beginGradientFill( "linear", [0x636363, 0x525252], [1, 1], [0, 255], matrix );
            frameCircle.graphics.drawCircle( 0, 0, 100 );
            frameCircle.graphics.endFill();
            frameCircle.x = stage.stageWidth / 2;
            frameCircle.y = stage.stageHeight / 2;
            addChild(frameCircle);
            
            //中心円の描画
            var centerCircle:Sprite = new Sprite();
            centerCircle.graphics.beginFill( 0xeeeeff );
            centerCircle.graphics.drawCircle( 0, 0, 20 );
            centerCircle.filters = [glow, dropShadow];
            centerCircle.graphics.endFill();
            centerCircle.x = stage.stageWidth / 2;
            centerCircle.y = stage.stageHeight / 2;
            addChild(centerCircle);
            
            //外円の描画
            var rectNum:Number = 10;
            for ( var i:int = 0; i < rectNum; i++ )
            {
                var pie:Sprite = new Sprite();
                drawPattern3( pie.graphics );
                pie.rotation = ( 360 / rectNum ) * i;
                pie.filters = [glow, dropShadow];
                addChild( pie );
                pie.x = pie.y = 250;
                pieList.push( pie );
            }
            
            addEventListener( Event.ENTER_FRAME, onEnterFrame );
        }
        
        //Pure AS3 RSS Iconより
        private function drawPattern3(g:Graphics):void
        {
            g.beginFill( 0xffffff );
            drawPie( g, 0, 0, 50, 0, Math.PI / 6 );
            drawPie( g, 0, 0, 85, 0, Math.PI / 6 );
            g.endFill();
        }
        
        //Pure AS3 RSS Iconより
        // 扇形を描くメソッド
        private function drawPie( g:Graphics, x:Number, y:Number, radius:Number, startAngle:Number, endAngle:Number ):void
        {
            g.moveTo( x, y );
            arcTo( g, x, y, radius, startAngle, endAngle );
        }
        
        //Pure AS3 RSS Iconより
        // 弧を描くメソッド
        private function arcTo( g:Graphics, x:Number, y:Number, radius:Number, startAngle:Number, endAngle:Number ):void
        {
            var clockwise:Boolean = startAngle < endAngle;
            
            g.lineTo( x + radius * Math.cos( startAngle ), y + radius * Math.sin( startAngle ) );
            
            while(clockwise && startAngle < endAngle || !clockwise && startAngle > endAngle)
            {
                var nextAngle:Number = clockwise ? Math.min( endAngle, startAngle + Math.PI / 4 )
                                                 : Math.max( endAngle, startAngle - Math.PI / 4 );
                
                var nextPos:Point = new Point(
                                    Math.cos( nextAngle ) * radius, 
                                    Math.sin( nextAngle ) * radius);
                
                var controlPos:Point = new Point(
                                        radius * Math.tan( ( nextAngle - startAngle ) / 2 ) * Math.cos( nextAngle - Math.PI / 2 ),
                                        radius * Math.tan( ( nextAngle - startAngle ) / 2 ) * Math.sin( nextAngle - Math.PI / 2 )
                                    );
                
                g.curveTo( x + nextPos.x + controlPos.x, y + nextPos.y + controlPos.y, x + nextPos.x, y + nextPos.y );
                
                startAngle = nextAngle;
            }
        }
        
        private function onEnterFrame( event:Event ):void
        {
            for ( var j:int = 0; j < pieList.length; j++ )
            {
                var mPosi:Number = mouseX - scx;
                //rotation="20"が回転速度最大に、rotationは0～20
                pieList[j].rotation += mPosi * 20 / scx;
            }
        }
    }
}