/**
 * Copyright hoooooonda ( http://wonderfl.net/user/hoooooonda )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aO44
 */

package {
    import flash.events.*;
    import flash.net.*;
    import flash.display.*;
    import flash.geom.*;
    import flash.system.*;
    public class FlashTest extends Sprite {
        
        public var load1:Loader = new Loader();
        public var load2:Loader = new Loader();
        
        public var spr1:Sprite = new Sprite();
        public var spr2:Sprite = new Sprite();
        
        public var line:Sprite = new Sprite();
        public var boundsLine:Sprite = new Sprite();
        
        public var hitBmd:BitmapData;
        
        public function FlashTest() {
           Security.loadPolicyFile("http://hr-portfolio.main.jp/crossdomain.xml");
           
           load1 = new Loader();
           load1.contentLoaderInfo.addEventListener(Event.COMPLETE, loaded);
           load1.load(new URLRequest("http://hr-portfolio.main.jp/test.png"));
           addChild(load1);
           
           
           
           var gr1:Graphics = spr1.graphics;
           gr1.beginFill(0xffee22,1);
           gr1.drawCircle(15,15,30);
           gr1.endFill();           
           
           /*var gr2:Graphics = spr2.graphics;
           gr2.beginFill(0x00ee22,1);
           gr2.drawCircle(stage.stageWidth/2,stage.stageHeight/2,100);
           gr2.endFill();
           
           addChild(spr2);*/
           addChild(spr1);
           
           addEventListener(MouseEvent.MOUSE_DOWN, onMDown);
           addEventListener(MouseEvent.MOUSE_UP, onMUp);
           
           line = new Sprite();
           addChild(line);            
           boundsLine = new Sprite();
           addChild(boundsLine);
           
           addEventListener(Event.ENTER_FRAME, track);
        }
        
        public function loaded(e:Event):void
        {
            e.target.loader.x = stage.stageWidth/2 - e.target.loader.width/2;
            e.target.loader.y = stage.stageHeight/2 - e.target.loader.height/2;
        }
        
        public function onMDown(e:MouseEvent):void
        {
            e.target.startDrag();
        }
        public function onMUp(e:MouseEvent):void
        {
            e.target.stopDrag();
        }
        
        public function track(e:Event):void
        {
            var mcRect:Rectangle = spr1.getBounds(this);
            var bgRect:Rectangle = load1.getBounds(this);
            
            // 交差する領域の境界ボックスを算出
            var bounds:Rectangle = new Rectangle();;
            bounds.left = Math.max(mcRect.left,bgRect.left);
            bounds.right= Math.min(mcRect.right,bgRect.right);
            bounds.top = Math.max(mcRect.top,bgRect.top);
            bounds.bottom = Math.min(mcRect.bottom,bgRect.bottom);
            
            /*境界線の描画*/
            boundsLine.graphics.clear();
            boundsLine.graphics.lineStyle(1, 0x0000FF, 1);
            boundsLine.graphics.drawRect( bounds.left, bounds.top, bounds.width, bounds.height);
            boundsLine.graphics.endFill();    
            
            //
            hitBmd = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x0fffffff);
            var mt:Matrix = new Matrix();
            mt.tx = spr1.x;
            mt.ty = spr1.y;
            //描画範囲を上記の境界内(bounds)だけにする(第五引数のRectangleが描画範囲になる)
            hitBmd.draw(spr1, mt, new ColorTransform(1,0,0,1,0,0,0,0),null ,bounds);
            
            var mt2:Matrix = new Matrix();
            mt2.tx = load1.x;
            mt2.ty = load1.y;
            //描画範囲を上記の境界内(bounds)だけにする(第五引数のRectangleが描画範囲になる)
            hitBmd.draw(load1, mt2, new ColorTransform(0,1,0,1,0,0,0,0),BlendMode.MULTIPLY, bounds);    
            
            //checkBmp.bitmapData = hitBmd;    
            
            var rect:Rectangle = hitBmd.getColorBoundsRect(0xFFFFFFFF, 0xFF000000, true);
            line.graphics.clear();
            line.graphics.lineStyle(1, 0xFF0000, 1);
            line.graphics.drawRect( rect.x, rect.y, rect.width, rect.height );
            line.graphics.endFill();
            
            hitBmd.dispose();
        }


    }
}