/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aNV9
 */

// forked from Yusuke.Asari's forked from: dot photo mosaic
// forked from Yusuke.Asari's dot photo mosaic
package {

    import flash.display.Bitmap;

    import flash.display.BitmapData;

    import flash.display.Loader;

    import flash.display.MovieClip;

    import flash.display.Sprite;

    import flash.events.Event;

    import flash.geom.Point;

    import flash.geom.Rectangle;

    import flash.net.URLRequest;

    import flash.system.LoaderContext;

    import flash.text.TextField;

    import flash.text.TextFormat;        

    

    

    [SWF(width="675", height="900", backgroundColor="0xffffff")]

    

    public class dotMosaic extends Sprite {

        private var dotSize:Number = 15;

        private var numberOfWidthDot:Number = 45;

        private var numberOfHeightDot:Number = 60;

        

        private var stageMc:MovieClip;

        private var mosaicMc:MovieClip;

        private var maskMc:MovieClip;

        

        private var loader:Loader;

        

        private var tf:TextField;



        public function dotMosaic() {

            this.setup();

        }

        

        private function setup():void {

            var f:TextFormat = new TextFormat();

            f.size = 25;

            f.bold = true;

            

            tf = new TextField;

            tf.defaultTextFormat = f;

            tf.text = "LOADING...";

            tf.width = 400;

            tf.height = 100;

            tf.x = stage.stageWidth/2;

            tf.y = stage.stageHeight/2;

            

            

            loader = new Loader();

            //

            stageMc = new MovieClip();

            addChild(stageMc);

            stageMc.name = "stageMc";

            

            mosaicMc = new MovieClip();

            stageMc.addChild(mosaicMc);

            mosaicMc.name = "mosaicMc";

            

            maskMc = new MovieClip();

            stageMc.addChild(maskMc);

            maskMc.name = "maskMc";

            stageMc.addChild(tf);



            this.loadMosaicMc();

        }

        

        private function loadMosaicMc():void {

            

            var url:String = "";
            var urlReq:URLRequest = new URLRequest(url);

            

            loader.contentLoaderInfo.addEventListener(Event.COMPLETE,this.loadedMosaicMc);

            loader.load(urlReq, new LoaderContext(true));

        }

        

        private function loadedMosaicMc(e:Event):void {

            //var loaderDomain:String = loader.contentLoaderInfo.url;

            //tf.text = loaderDomain;

            mosaicMc.addChild(loader);

            //mosaicMc.visible = false;

            

            var bmpData:BitmapData = new BitmapData(loader.width,loader.height,true);

            bmpData = Bitmap(loader.content).bitmapData;



            //

            for(var i:Number=0;i<numberOfWidthDot*numberOfHeightDot;i++){

                //

                var s:Number = this.checkBrightness(bmpData.clone(),i);

                var c:Sprite = new Sprite();

                c.graphics.beginFill(0xFF0000);

                c.graphics.drawCircle(dotSize/2+(i%numberOfWidthDot)*dotSize, dotSize/2+Math.floor(i/numberOfWidthDot)*dotSize, (dotSize/2)*(1-s));

                c.graphics.endFill();

                

                maskMc.addChild(c);

            }

            mosaicMc.mask = maskMc;

            tf.visible=false;

        }

        

        private function checkBrightness(bmpd:BitmapData,c:Number):Number {

            var count:Number = c;

            var bmpData:BitmapData = new BitmapData(dotSize,dotSize,true);

            var rect:Rectangle = new Rectangle((count%numberOfWidthDot)*dotSize,Math.floor(count/numberOfWidthDot)*dotSize,dotSize,dotSize);

            var pos:Point = new Point(0,0);

            

            //mosaicMc.visible = false;

            

            bmpData.copyPixels(bmpd,rect,pos);

            var mc:MovieClip = new MovieClip();

            mc.addChild(new Bitmap(bmpData));

            return this.getAverageColor(mc);

            //tf.text = String(b);

            //tf.text += "AAAA";

        }

        

        private function getAverageColor(image:MovieClip):Number {

            var bmp:BitmapData = new BitmapData(image.width,image.height, true, 0x00000000);

            //bmp.draw(image);

            bmp.draw(image.getChildAt(0));

            var v:Vector.<Vector.<Number >  >  = bmp.histogram();

            var r:Number = 0;

            var g:Number = 0;

            var b:Number = 0;

            var a:Number = 0;

            

            for (var i:int=0; i<256; i++) {

                r +=  i * v[0][i] / 255;

                g +=  i * v[1][i] / 255;

                b +=  i * v[2][i] / 255;

                a += i*v[3][i]/255;

            }

            

            var brightness:Number = (r+g+b)/(3*a);

            bmp.dispose();

            return brightness;

        }

    }

}



