/**
 * Copyright clockmaker ( http://wonderfl.net/user/clockmaker )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aMeZ
 */

// forked from cjcat2266's [Stardust] Papervision3D Floor
package {
    import flash.display.*;
    import flash.events.*;
    import flash.utils.*;
    import idv.cjcat.stardust.common.clocks.*;
    import idv.cjcat.stardust.threeD.papervision3d.renderers.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.*;
    
    [SWF(frameRate=60)]
    public class Main extends BasicView {
        
        private var emitter:CubeEmitter;
        
        public function Main():void {
            
            // 初期設定
            stage.quality = StageQuality.LOW;
            opaqueBackground = 0x0;
            
            //PV3D setup
            camera.y = 280;
            var container:DisplayObject3D = new DisplayObject3D();
            scene.addChild(container);
            
            // 床
            var w:WireframeMaterial = new WireframeMaterial(0x999999);
            
            var earth:Plane = new Plane(w, 1500, 1500, 5, 5);
            earth.rotationX = 90;
            scene.addChild(earth);
            
            //エミッターとレンダラー
            emitter = new CubeEmitter(new SteadyClock(0.25));
            var renderer:PV3DDisplayObject3DRenderer = new PV3DDisplayObject3DRenderer(container);
            renderer.addEmitter(emitter);
            
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        private function enterFrameHandler(e:Event):void {
            // 角度に応じてカメラの位置を設定
            var msec:Number = getTimer();
            camera.x = 1000 * Math.sin(msec / 2000);
            camera.z = 1000 * Math.cos(msec / 2000);
            camera.y = 500 * Math.sin(msec / 2500) + 900;
            
            emitter.step();
            singleRender();
        }
    }
}

import idv.cjcat.stardust.common.actions.*;
import idv.cjcat.stardust.common.clocks.*;
import idv.cjcat.stardust.common.initializers.*;
import idv.cjcat.stardust.common.math.*;
import idv.cjcat.stardust.threeD.actions.*;
import idv.cjcat.stardust.threeD.deflectors.*;
import idv.cjcat.stardust.threeD.emitters.*;
import idv.cjcat.stardust.threeD.fields.*;
import idv.cjcat.stardust.threeD.initializers.*;
import idv.cjcat.stardust.threeD.zones.*;
import org.papervision3d.materials.*;
import org.papervision3d.materials.special.*;
import org.papervision3d.objects.primitives.*;

class CubeEmitter extends Emitter3D {
    public function CubeEmitter(clock:Clock) {
        super(clock);
        
        //　球体のテクスチャ
        var wireFrameMat:WireframeMaterial = new WireframeMaterial(0xFF0000);
        var colorMat:ColorMaterial = new ColorMaterial(0x0, 0.76);
        var compMat:CompositeMaterial = new CompositeMaterial();
        compMat.addMaterial(colorMat);
        compMat.addMaterial(wireFrameMat);

        //initializers
        // パーティクルで何を出すか
        var doc3D:DisplayObjectClass3D = new DisplayObjectClass3D();
        doc3D.displayObjectClass = Sphere;
        doc3D.constructorParams = [compMat, 60, 5, 4];
        
        // 噴出の方向
        var cap:SphereCap = new SphereCap(0, 0, 0, 25, 40, 15);
        cap.rotationX = 180;
        
        var rotationRand:UniformRandom = new UniformRandom(0, 180);
        var omegaRand:UniformRandom = new UniformRandom(0, 4);
        
        addInitializer(doc3D);
        addInitializer(new Life(new UniformRandom(150, 40)));
        addInitializer(new Position3D(new SinglePoint3D(0, 0, 0)));
        addInitializer(new Velocity3D(cap));
        addInitializer(new Rotation3D(rotationRand, rotationRand, rotationRand));
        addInitializer(new Omega3D(omegaRand, omegaRand, omegaRand));
        
        //actions
        // 重力
        var field:UniformField3D = new UniformField3D(0, -1, 0);
        var gravity:Gravity3D = new Gravity3D();
        gravity.addField(field);
        
        // 反射
        var deflect:Deflect3D = new Deflect3D();
        deflect.addDeflector(new PlaneDeflector(0, 0, 0, 0, 1, 0));
        
        // いろいろ
        addAction(gravity);
        addAction(deflect);
        addAction(new Age());
        addAction(new DeathLife());
        addAction(new Move3D());
        addAction(new Spin3D());
        addAction(new ScaleCurve(20, 50));
    }
}