/**
 * Copyright 178ep3 ( http://wonderfl.net/user/178ep3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aMVu
 */

//昨日に続いてカードゲーム
//色々怪しいので後で見直す。

package
{
	import caurina.transitions.Tweener;
	
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;

	[SWF(backgroundColor=0x009900, frameRate=30)]
	public class BlackJack extends Sprite
	{
		private var _kindList:Array = ["Spade","Clover","Dia","Heart"];
		private var _cardList:Array = [];
		private var _myCard:Array = [];
		private var _dealerCard:Array = [];
		private var _myNum:uint=0;
		private var _dealerNum:uint=0;
		
		private var _cardStg:Sprite;
		private var _hitBtn:SampleBtn;
		private var _standBtn:SampleBtn;
		
		private var _jTf:TextField;
		
		private var _coin:int=100;
		private var _floatCoin:uint=0;
		private var _coinTf:TextField;
		
		public function BlackJack()
		{
			if(stage)init();
			else addEventListener(Event.ADDED_TO_STAGE,init);
		}
		
		private function init():void
		{
			removeEventListener(Event.ADDED_TO_STAGE,init);
			
			_coinTf = addChild(new TextField())as TextField;
			_coinTf.text = "POINT : " + _coin.toString();
			_coinTf.selectable = false;
			_coinTf.autoSize = TextFieldAutoSize.LEFT;
			_coinTf.x = 20;
			_coinTf.y = 190;
			
			_hitBtn = addChild(new SampleBtn("HIT"))as SampleBtn;
			_standBtn = addChild(new SampleBtn("STAND"))as SampleBtn;
			_hitBtn.y = _standBtn.y = stage.stageHeight*0.5-20;
			_hitBtn.x = 20;
			_standBtn.x = 60;
			_hitBtn.addEventListener(MouseEvent.CLICK,function():void{addCard(_myCard);});
			_standBtn.addEventListener(MouseEvent.CLICK,dealerAdd);
			
			gameStart();
		}
		
		private function gameStart():void
		{
			_cardStg = addChild(new Sprite())as Sprite;
			_hitBtn.visible = _standBtn.visible = true;
			var i:uint,q:uint;
			for(q=0; q<4; q++)
			{
				for(i=1; i<14; i++)
				{
					var card:Card = new Card(_kindList[q],i);
					card.x = (320-card.width)*0.5;
					card.y = (465-card.height)*0.5;
					_cardList.push(card);
				}
			}
			
			for(i=0; i<100; i++)
			{
				var sc:Card = _cardList.shift();
				_cardList.splice(Math.random()*52,0,sc);
			}
			
			
			for(i=0; i<2; i++)
			{
				Tweener.addTween(this,{time:i*0.2,onComplete:addCard,onCompleteParams:[_myCard]});
				Tweener.addTween(this,{time:i*0.2,onComplete:addCard,onCompleteParams:[_dealerCard,1-i]});
			}
			autoJudge(true);
		}
		
		private function dealerAdd(e:MouseEvent=null):void
		{
			_dealerCard[1].onCard();
			_hitBtn.visible = _standBtn.visible = false;
			addCard(_dealerCard);
			if(_dealerNum<16)Tweener.addTween(this,{time:0.1,onComplete:function():void{dealerAdd();}});
			else if(_dealerNum<22)judge();
		}
		
		private function addCard(list:Array,flg:uint=1):void
		{
			var card:Card = _cardList.shift();
			list.push(card);
			_cardStg.addChild(card);
			if(flg==0)card.offCard();
			var toX:uint = list.length * 60 -50;
			var toY:uint;
			if(list===_myCard)toY = 355;
			else toY = 10;
			
			Tweener.addTween(card,{time:0.2,x:toX,y:toY,transition:"linear"});
			
			cardCount(list);
		}
		
		private function cardCount(list:Array):void
		{
			var i:uint=0;
			var count:uint=0;
			var A:Boolean = false;
			for(i=0; i<list.length; i++)
			{
				count += list[i].num;
				if(list[i].num==11)A=true;
			}
			if(count>21 && A)count-=10;
			
			if(list===_myCard)_myNum = count;
			else _dealerNum = count;
			
			autoJudge();
		}
		
		private function autoJudge(first:Boolean=false):void
		{
			if(_myNum>21)win(1);
			else if(_dealerNum>21)win(0);
			else if(_myNum==21 && first)win(3);
		}
		
		private function judge():void
		{
			if(_myNum>_dealerNum)win(0);
			else if(_myNum==_dealerNum)win(2);
			else win(1);
		}
		
		private function win(out:uint):void
		{
			_hitBtn.visible = _standBtn.visible = false;
			_dealerCard[1].onCard();
			Tweener.addTween(this,{time:0.2,onComplete:fin});
			function fin():void
			{
				var str:String;
				if(out==0)
				{
					str = "You Win !";
					_coin+=(10+_floatCoin);
					_floatCoin = 0;
				}
				else if(out==1)
				{
					str = "You lose...";
					_coin-=10;
					_floatCoin = 0;
				}
				else if(out==3)
				{
					str = "You Win !";
					_coin+=(20+_floatCoin);
					_floatCoin = 0;
				}
				else
				{
					str = "Draw";
					_floatCoin += 20;
				}
				
				_coinTf.text = "POINT : " + _coin.toString();
				_jTf = addChild(new TextField())as TextField;
				_jTf.defaultTextFormat = new TextFormat("_ゴシック",20);
				_jTf.text = str;
				_jTf.autoSize = TextFieldAutoSize.LEFT;
				_jTf.selectable = false;
				_jTf.x = 160 - _jTf.width*0.5;
				_jTf.y = stage.stageHeight*0.5 - _jTf.height*0.5-50;
				
				if(_coin>10)
				{
					var re:SampleBtn = addChild(new SampleBtn("Next Game"))as SampleBtn;
					re.x = 160 - re.width*0.5;
					re.y = 200;
					re.addEventListener(MouseEvent.CLICK,restart);
					function restart(e:MouseEvent):void
					{
						re.removeEventListener(MouseEvent.CLICK,restart);
						_cardList = [];
						_myCard = [];
						_dealerCard = [];
						_floatCoin = 0;
						_myNum = _dealerNum = 0;
						removeChild(_cardStg);
						_cardStg = null;
						removeChild(_jTf);
						removeChild(re);
						gameStart();
					}
				}
				else
				{
					_jTf.text = "GAME OVER";
				}
			}
		}
	}
}

	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;

class Card extends Sprite
{
	private var _tf:TextField;
	private var _kind:String;
	private var _num:uint;
	
	public function Card(kind:String,num:uint)
	{
		_kind = kind;
		_num = num;
		
		this.graphics.beginFill(0xffffff);
		this.graphics.lineStyle(1);
		this.graphics.drawRect(0,0,50,80);
		this.graphics.endFill();
		
		var color:uint = 0;
		if(_kind=="Dia" || _kind=="Heart")color=0xff0000;
		
		_tf = addChild(new TextField())as TextField;
		_tf.defaultTextFormat = new TextFormat("_ゴシック",12,color);
		_tf.autoSize = TextFieldAutoSize.CENTER;
		_tf.selectable = false;
		
		_tf.defaultTextFormat =  new TextFormat("_ゴシック",30,color);
		
		if(_kind=="Spade") _tf.text = "♠ \n";
		else if(_kind=="Clover") _tf.text = "♣ \n";
		else if(_kind=="Dia") _tf.text = "♦ \n";
		else if(_kind=="Heart")_tf.text = "♥ \n";
		
		_tf.defaultTextFormat =  new TextFormat("_ゴシック",12,color);
		
		if(_num==1) _tf.appendText("A");
		else if(_num==11) _tf.appendText("XI");
		else if(_num==12) _tf.appendText("XⅡ");
		else if(_num==13) _tf.appendText("XⅢ");
		else _tf.appendText(_num.toString());
		
		if(_num>10)_num=10;
		else if(_num==1)_num=11;
		
		_tf.x = 25 - _tf.width*0.5;
		_tf.y = 40 - _tf.height*0.5;
	}
	
	public function onCard():void
	{
		_tf.visible = true;
	}
	
	public function offCard():void
	{
		_tf.visible = false;
	}
	
	public function get kind():String
	{
		return _kind;
	}
	
	public function get num():uint
	{
		return _num;
	}
}

class SampleBtn extends Sprite
{
	private var _tf:TextField;
	
	public function SampleBtn(value:String="")
	{
		_tf = addChild(new TextField())as TextField;
		_tf.autoSize = TextFieldAutoSize.LEFT;
		_tf.selectable = false;
		_tf.text = value;
		_tf.x = _tf.y = 5;
		
		this.graphics.lineStyle(1);
		this.graphics.beginFill(0xffffff);
		this.graphics.drawRect(0,0,_tf.width+10 , _tf.height+10);
		this.graphics.endFill();
		this.mouseChildren = false;
		this.buttonMode = true;
	}
}
