/**
 * Copyright heru.z0r ( http://wonderfl.net/user/heru.z0r )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aLsN
 */

// forked from hebee's  from: forked from: Particle
// Changed allot, and if you can edit this with about 15k particles to make it look nice. I cant because this mac crashes with the blur filters past 10k.
// forked from keleia.blackman's forked from: forked from: Particle
// forked from hebee's forked from: Particle
package
{
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.ColorTransform;
    import flash.display.Shape;
    import flash.geom.Point;
    import flash.filters.BlurFilter;
    import flash.display.Sprite;
    
    public class Main extends Sprite
    {
        
        private var NUM_PARTICLES : int = 450;
        private const MAX_SPEED : Number = 3;
        private const MIN_SPEED : Number = 0.25;
        private const MAX_PARTICLES : Number = 5000;
        
        private var _canvas : BitmapData;  
        private var _pixels : Array
        
        private var _alphaTransform : ColorTransform;
        private var _blurFilter : BlurFilter;
        
        private var _zeroPoint : Point;
        private var _even : Boolean;  

        public function Main()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            _even = true;
            _blurFilter = new BlurFilter(3,3,1);
            _zeroPoint = new Point;
            
            _canvas = new BitmapData( stage.stageWidth, stage.stageHeight, false, 0 );
            addChild( new Bitmap( _canvas ) );
            
            _pixels = new Array();
            
            init();
        }
        
        public function init():void
        {
            
            for( var i : int = _pixels.length-1; i < NUM_PARTICLES; ++i )
            {
                var pixel : Object = {};
                pixel.x = Math.random() * stage.stageWidth;
                pixel.y = Math.random() * stage.stageHeight;
                pixel.dx = 0;
                pixel.dy = 0;
                pixel.lastX = pixel.x;
                pixel.lastY = pixel.y;
                pixel.color = 0xFFFFFF;
                
                if((Math.random()*10 + 1) > 8){
                    pixel.color = 0x99EE00
                }
                
                pixel.speed = ((Math.random()*(100*(MAX_SPEED - MIN_SPEED))) + (100*MIN_SPEED))/100;
                _pixels[i] = pixel;
            }
                        
            addEventListener( Event.ENTER_FRAME, onEnterFrame );
            stage.addEventListener( MouseEvent.CLICK, onMouseDown);
        }
        
        private function onEnterFrame( e : Event ) : void
        {
            _canvas.lock();        
            
            var fade : Number = 5;
            while(fade --){   
                _canvas.applyFilter(_canvas,_canvas.rect,_zeroPoint,_blurFilter);             
            }
             
            if(_even){
                _even = false;              
            } else {
                _even = true;
            }         

            var pixel : Object;
            var angle : Number;
            for( var i : int = 0; i < NUM_PARTICLES; ++i )
            {
                pixel = _pixels[i];
                
                pixel.lastX = pixel.x;
                pixel.lastY = pixel.y;
                
                if(i != 0 && Math.random()*51 >= 2){
                      angle = Math.atan2( pixel.y - _pixels[i-1].y, pixel.x - _pixels[i-1].x );
                } else {
                    angle = Math.atan2( pixel.y - mouseY, pixel.x - mouseX );
                }
                pixel.dx -= pixel.speed * Math.cos( angle );
                pixel.dy -= pixel.speed * Math.sin( angle );
                
                
                if(_even){
                    pixel.dy *= (Math.random()*50)/100 + .5;
                } else {
                    pixel.dx *= (Math.random()*50)/100 + .5;
                }
                
                pixel.x += pixel.dx;
                pixel.y += pixel.dy;
                             
                _canvas.setPixel(pixel.x,pixel.y,pixel.color);
            }
            
             _canvas.applyFilter(_canvas,_canvas.rect,_zeroPoint,_blurFilter);             
            

            _canvas.unlock();
        }
        
        private function onMouseDown( e : MouseEvent ) : void
        {
            NUM_PARTICLES += 150;
            if(NUM_PARTICLES > MAX_PARTICLES){
                NUM_PARTICLES = MAX_PARTICLES;
            }

            init();
        }
    }
}