/**
 * Copyright nabe ( http://wonderfl.net/user/nabe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aLTy
 */

package {
	import flash.display.DisplayObject;
	import flash.display.Graphics;
	import flash.display.SimpleButton;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	public class Main extends Sprite {
		public function Main ():void {
			addEventListener(Event.ADDED_TO_STAGE, init_);
		}
		private function init_(e:Event):void {
			removeEventListener(Event.ADDED_TO_STAGE, init_);
			var w_:int = stage.stageWidth * 0.5;
			var h_:int = stage.stageHeight * 0.5;
			x = w_;
			y = h_;
			append_(w_ * (Math.random() - 0.5), h_ * (Math.random() - 0.5));
			addEventListener(Event.ENTER_FRAME, update_);
			stage.addEventListener(MouseEvent.CLICK, click_);
		}
		private function click_(e:MouseEvent):void {
		//クリックした位置に子を追加する。
			append_(mouseX, mouseY);
		}
		private function append_(x_:Number, y_:Number):void {
		//子を追加する。
			addChild(new Cube(x_, y_));
		}
		private function update_(e:Event):void {
		//アニメーション。
			var g_:Graphics
			g_ = graphics;
			g_.clear();
			var n_:int = this.numChildren;
			for (var i_:int = 0; i_ < n_; ++i_) {
				var cube_:Cube = this.getChildAt(i_) as Cube;
				//g_ = cube_.graphics;
				//g_.clear();
				cube_.update_(g_);
			}
		}
	}
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.GradientType;
import flash.display.Graphics;
import flash.display.Shape;
import flash.display.TriangleCulling;
import flash.events.MouseEvent;
import flash.geom.Matrix;
import flash.geom.Matrix3D;
import flash.geom.PerspectiveProjection;
import flash.geom.Point;
import flash.geom.Utils3D;
import flash.geom.Vector3D;
import flash.display.Sprite;
import flash.events.Event;
class Cube extends Sprite {
	private var vertices3D:Vector.<Number> = new Vector.<Number>;
	private var vertices2D:Vector.<Number> = new Vector.<Number>(14 * 2, true);
	private var indices:Vector.<int> = new Vector.<int>;
	private var uvtData:Vector.<Number> = new Vector.<Number>;
	private var texture_:BitmapData;
	private var sum_rot:Matrix3D;
	private var add_rot:Matrix3D;
	private var trans_:Vector3D;
	private var pers_:Matrix3D;
	public function Cube(x_:Number, y_:Number):void {
		trans_ = new Vector3D(x_, y_, 1000);
		addEventListener(Event.ADDED_TO_STAGE, init_);
	}
	private function init_(e:Event):void {
		removeEventListener(Event.ADDED_TO_STAGE, init_);
		data_();
		addEventListener(MouseEvent.CLICK, remove_);
	}
	public function update_(g_:Graphics):void {
		move_();
		draw_(g_, true);
	}
	private function data_():void {
	//テクスチャの用意。
		texture_ = newTexture_(400, 300, 10);
	//展開図を考える。
		const u0:Number = 0;
		const u1:Number = 0.25;
		const u2:Number = 0.5;
		const u3:Number = 0.75;
		const u4:Number = 1;
		const v0:Number = 0;
		const v1:Number = 1 / 3;
		const v2:Number = 2 / 3;
		const v3:Number = 1;
		uvtData.push(
			u0, v0, 0, u1, v0, 0, u2, v0, 0,
			u0, v1, 0, u1, v1, 0, u2, v1, 0, u3, v1, 0,
			           u1, v2, 0, u2, v2, 0, u3, v2, 0, u4, v2, 0,
					              u2, v3, 0, u3, v3, 0, u4, v3, 0
		);
	//三角形を定義する。
		/* 0  1  2
		 * 3  4  5  6
		 *    7  8  9 10
		 *      11 12 13
		 */
		indices.push(
			 0,  1,  3,  3,  1,  4,
			 1,  2,  4,  4,  2,  5,
			 4,  5,  7,  7,  5,  8,
			 5,  6,  8,  8,  6,  9,
			 8,  9, 11, 11,  9, 12,
			 9, 10, 12, 12, 10, 13
		);
	//立体で考える。
		const s:int = 100;
		var p0:Vector3D = new Vector3D( -s, -s, -s);
		var p1:Vector3D = new Vector3D(  s, -s, -s);
		var p2:Vector3D = new Vector3D( -s,  s, -s);
		var p3:Vector3D = new Vector3D(  s,  s, -s);
		var p4:Vector3D = new Vector3D( -s, -s,  s);
		var p5:Vector3D = new Vector3D(  s, -s,  s);
		var p6:Vector3D = new Vector3D( -s,  s,  s);
		var p7:Vector3D = new Vector3D(  s,  s,  s);
		/*   6 -- 7
		 *  /    /|
		 * 2 -- 3 |
		 * | 4  | 5
		 * |    |/
		 * 0 -- 1
		 */
		var c:Vector.<Vector3D> = new Vector.<Vector3D>;
		c.push(
			p0, p1, p3,
			p4, p5, p7, p3,
			    p4, p6, p2, p3,
			        p4, p0, p1
		);
		for (var i:int = 0; i < 14; ++i) {
			var t:Vector3D = c[i];
			vertices3D.push(t.x, t.y, t.z);
		}
	//回転の用意。
		sum_rot = new Matrix3D;
		add_rot = new Matrix3D;
		var axis_:Vector3D = new Vector3D(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5);
		axis_.normalize();
		add_rot.appendRotation((Math.random() - 0.5) * 10, axis_);
	//投影の用意。
		pers_ = root.transform.perspectiveProjection.toMatrix3D();
	}
	private function move_():void {
	//座標を更新する。
		sum_rot.append(add_rot);
		var mat:Matrix3D = sum_rot.clone();
		mat.appendTranslation(trans_.x, trans_.y, trans_.z);
		mat.append(pers_);
		Utils3D.projectVectors(mat, vertices3D, vertices2D, uvtData);
	}
	private function draw_(g_:Graphics, show_:Boolean):void {
	//渡された画面に描画する。
		if (show_) {
		//表示用。
			g_.beginBitmapFill(texture_, null, false, true);
			g_.drawTriangles(vertices2D, indices, uvtData, TriangleCulling.POSITIVE);
		} else {
		//マスク用。
			g_.beginFill(0xFFCCCC);
			g_.drawTriangles(vertices2D, indices, null, TriangleCulling.POSITIVE);
		}
		g_.endFill();
	}
	private function remove_(e:Event):void {
	//クリックすると消える。
		parent.removeChild(this);
		e.stopPropagation();
	}
	private function newTexture_ (width_:int, height_:int, size_:int):BitmapData {
	//ピンク色の方眼紙。
		var s_:Shape = new Shape;
		var g_:Graphics = s_.graphics;
		g_.clear();
		g_.lineStyle(1, 0xFF0000);
	//縦線。
		for (var x_:int = 0; x_ < width_; x_ += size_) {
			g_.moveTo(x_, 0);
			g_.lineTo(x_, height_);
		}
	//横線。
		for (var y_:int = 0; y_ < height_; y_ += size_) {
			g_.moveTo(0, y_);
			g_.lineTo(width_, y_);
		}
	//ビットマップに転記する。
		var r_:BitmapData = new BitmapData(width_, height_, false, 0xFFCCCC);
		r_.draw(s_);
		return r_;
	}
}
