/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aLDQ
 */

package
{
	import com.bit101.components.PushButton;
	import flash.display.Sprite;
	import flash.display.StageDisplayState;
	import flash.display.StageScaleMode;
	
	public class FlashTest extends Sprite
	{	
		private var b:PushButton;
		
		public function FlashTest()
		{
			b = new PushButton(this, 0, 0, "FULL SCREEN", function(e:*):void
			{
				if (stage.displayState == StageDisplayState.NORMAL)
				{
					stage.displayState = StageDisplayState.FULL_SCREEN;
					draw( 100 );
				}
				else
				{
					stage.displayState = StageDisplayState.NORMAL;
					draw( 40 );
				}
			
			});
			b.width = 100;
			
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = "topLeft";
			
			cont = new Sprite();
			addChild( cont);
			addChild(b);
			
			draw( 40 );
		}
		
		public function draw( size:int ):void
		{
			while ( cont.numChildren > 0 ) cont.removeChildAt(0);
			graphics.clear();
			
			var sx:Number = stage.stageWidth / 2;
			var sy:Number = stage.stageHeight / 2;
			
			var dist:int = 25;
			
			var pos:Vec = new Vec(sx, sy);
			
			cont.addChild(new D(1, pos.x, pos.y));
			
			var n:int = 2;
			var v:Vec = new Vec(1,0);
			var steps:int = 1;
			var incSteps:int = 2;
			
			// Change direction - loop
			for (var j:int = 0; j < size; j++)
			{
				// Progress - loop
				for (var i:int = 0; i < steps; i++)
				{
					pos.x += dist * v.x;
					pos.y += dist * v.y;
					
					add(n, pos.x, pos.y);
					
					n++;
				}
				
				v.degrees -= 90;
				
				if ( --incSteps == 0 ) 
				{
					steps++;
					incSteps = 2;
				}
			}
		}
		
		//Mehtod taken from: http://www.actionscript.org/forums/showthread.php3?t=230387
		private function primeNumber(tall:int):Boolean
		{
			var count:uint = 2;
			var i:uint = 0; //var used to define whether a number is prime or not
			while (count <= Math.sqrt(tall))
			{
				if (tall % count == 0)
				{
					i++; //if it's a prime number, i will never be more than 0. If it's not, i will be at least 1.
				}
				else
				{
					i = i
				}
				count++;
			}
			
			return i == 0;
		}
		
		private var cont:Sprite;
		
		public function add(digit:int, x:Number, y:Number):void
		{
			var d:D = new D(digit, x, y, primeNumber(digit));
			cont.addChild(d);
		}
	
	}
}
import flash.text.TextFormat;
import flash.display.Sprite;
import flash.text.TextField;
import frocessing.color.ColorHSV;

class D extends Sprite
{
	private var n:N;
	
	public function D(digit:int, x:Number, y:Number, special:Boolean = false)
	{
		n = new N(digit);
		addChild(n);
		
		this.x = x;
		this.y = y;
		
		_size = digit.toString().length;
		
		var c:ColorHSV = new ColorHSV(special ? 0 : 120, 0.5);
		
		graphics.beginFill(c.value);
		
		// 4 * _size + 6
		graphics.drawCircle(0, 0, 3 * _size + 4);
		graphics.endFill();
	
	}
	
	private var _size:int = 1;
	
	public function get size():int
	{
		return _size;
	}
}

class N extends TextField
{
	public function N(digit:int)
	{
		var tf:TextFormat = new TextFormat("_sans", 12, 0x000000);
		this.setTextFormat(tf);
		this.defaultTextFormat = tf;
		this.autoSize = 'left';
		this.text = digit.toString();
		this.selectable = this.wordWrap = this.multiline = this.mouseEnabled = false;
		
		this.x = -this.width / 2;
		this.y = -this.height / 2;
	}

}

class Vec
{
	public var x:Number, y:Number;
	
	public function Vec(x:Number = 0, y:Number = 0)
	{
		this.x = x;
		this.y = y;
	}
	
	public function get lenght():Number
	{
		return Math.sqrt(x * x + y * y);
	}
	
	public function set lenght(value:Number):void
	{
		if (lenght == 0)
			scale(0);
		else
			scale(value / lenght);
	}
	
	public function set degrees(value:Number):void
	{
		radians = value * Math.PI / 180;
	}
	
	public function get degrees():Number
	{
		return radians * 180 / Math.PI;
	}
	
	public function set radians(value:Number):void
	{
		var f:Number = lenght;
		x = Math.cos(value) * f;
		y = Math.sin(value) * f;
	}
	
	public function scale(n:Number):void
	{
		x *= n;
		y *= n;
	}
	
	public function get radians():Number
	{
		return Math.atan2(y, x);
	}

}
