/**
 * Copyright KinkumaDesign ( http://wonderfl.net/user/KinkumaDesign )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aKsE
 */

/*
 * クリックするたびに模様が変わるよ
 * When mouse click, pattern will change.
 */
package  
{
	import flash.display.BlendMode;
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;

	[SWF(width="315", height="445", frameRate="30", backgroundColor="#000000")]
	public class Main extends Sprite
	{
		public var canvass:Array;
		public var numOfCanvas:int = 7;
		public var canvasContainer:Sprite;
		public var sw:Number;
		public var sh:Number;
		public var col:int;
		public var raw:int;
		public var switchSP:Sprite;
		
		public function Main() 
		{
			sw = this.stage.stageWidth * 1.5;
			sh = this.stage.stageHeight * 1.5;
			this.stage.scaleMode = StageScaleMode.NO_SCALE;
			init();
		}
		
		private function init():void
		{
			var i:int;
			var sp:Sprite;

			
			canvass = new Array();
			canvasContainer = new Sprite();
			this.addChild(canvasContainer);
			canvasContainer.x = this.stage.stageWidth / 2;
			canvasContainer.y = this.stage.stageHeight / 2;
			
			for (i = 0; i < numOfCanvas; i++) {
				sp = new Sprite();
				canvass.push(sp);
				canvasContainer.addChild(sp);
				sp.x = -sw / 2;
				sp.y = -sh / 2;
				sp.z = 10 * i;
				sp.blendMode = BlendMode.SCREEN;
				
			}
			
			drawSquares();
			
			
			switchSP = new Sprite();
			this.addChild(switchSP);
			var g:Graphics = switchSP.graphics;
			g.beginFill(0, 0);
			g.drawRect(0, 0, this.stage.stageWidth, this.stage.stageHeight);
			g.endFill();
			switchSP.addEventListener(MouseEvent.CLICK, clickHD);
			this.addEventListener(Event.ENTER_FRAME, render);
		}
		
		private function clickHD(e:MouseEvent):void 
		{
			drawSquares();
		}
		
		private function render(e:Event):void 
		{
			var stageW:Number = this.stage.stageWidth;
			var stageH:Number = this.stage.stageHeight;
			var radX:Number = (stageW - this.stage.mouseX) / stageW * Math.PI;
			var radY:Number = (stageH - this.stage.mouseY) / stageH * Math.PI;
			canvasContainer.rotationY += (-45 * Math.cos(radX) - canvasContainer.rotationY) * 0.1;
			canvasContainer.rotationX += (30 * Math.cos(radY) - canvasContainer.rotationX) * 0.1;
		}
		
		private function drawSquares():void
		{
			col = 70 * Math.random();
			raw = 80 * Math.random();
			var sp:Sprite;
			var _z:int = Math.random() * 100;
			for (var i:int = 0; i < numOfCanvas; i++) {
				sp = canvass[i];
				sp.z = _z * i;
				drawSquare(sp);
			}
		}
		
		private function drawSquare(sp:Sprite):void
		{
			var i:int, j:int;
			var dw:Number = sw / col;
			var dh:Number = sh / raw;
			var g:Graphics = sp.graphics;
			var drawFlag:Boolean = false;
			var color:int = 0xffffff * Math.random();
			g.clear();
			g.beginFill(color, Math.random());
			for (i = 0; i < raw; i++) {
				for (j = 0; j < col; j++) {
					if (drawFlag) {
						g.drawRect(dw * j, dh * i, dw, dh);
					}
					drawFlag = !drawFlag;
				}
			}
			g.endFill();
		}
	}
	
}