/**
 * Copyright yangliu9812 ( http://wonderfl.net/user/yangliu9812 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aKj6
 */

// forked from ProjectNya's LightTune + SoundMixer [fullscreen]
////////////////////////////////////////////////////////////////////////////////
// LightTune + SoundMixer [fullscreen]
//
// [AS3.0] LightTuneクラスだ！ (4)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1158
//
// 背景を暗くするのに ColorTransform を用いた
//
// 音はTsabeat より拝借
// http://www.ektoplazm.com/free-music/tsabeat-warp-speed-ep/
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageDisplayState;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var base:Shape;
        private var light:LightTune;
        private var controller:Sprite;
        private var fullscreenBtn:Btn;
        private var normalBtn:Btn;

        public function Main() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.MEDIUM;
            stage.addEventListener(Event.RESIZE, update, false, 0, true);
            init();
        }

        private function init():void {
            base = new Shape();
            addChild(base);
            base.graphics.beginFill(0x000000);
            base.graphics.drawRect(0, 0, 465, 465);
            base.graphics.endFill();
            //
            var rect:Rectangle = new Rectangle(0, 0, 1000, 750);
            light = new LightTune(rect);
            addChild(light);
            //light.start();
            //
            controller = new Sprite();
            addChild(controller);
            controller.x = 232;
            controller.y = 445;
            fullscreenBtn = new Btn();
            controller.addChild(fullscreenBtn);
            fullscreenBtn.x = 0;
            fullscreenBtn.init({label: "full screen", type: 2, width: 100});
            fullscreenBtn.addEventListener(MouseEvent.CLICK, click, false, 0, true);
            normalBtn = new Btn();
            controller.addChild(normalBtn);
            normalBtn.x = 0;
            normalBtn.init({label: "normal", type: 2, width: 100});
            normalBtn.addEventListener(MouseEvent.CLICK, click, false, 0, true);
            normalBtn.visible = false;
            update();
        }
        private function update(evt:Event = null):void {
            var sw:uint = stage.stageWidth;
            var sh:uint = stage.stageHeight;
            base.width = sw;
            base.height = sh;
            var xscale:Number = sw/1000;
            var yscale:Number = sh/750;
            var scale:Number = Math.max(1, Math.max(xscale, yscale));
            light.x = - int((1000*scale - sw)/2);
            light.y = - int((750*scale - sh)/2);
            light.scaleX = light.scaleY = scale;
            controller.x = uint(sw/2);
            controller.y = sh - 20;
            if (stage.displayState == StageDisplayState.FULL_SCREEN) {
                fullscreenBtn.visible = false;
                normalBtn.visible = true;
            } else {
                fullscreenBtn.visible = true;
                normalBtn.visible = false;
            }
        }
        private function click(evt:Event):void {
            if (stage.displayState == StageDisplayState.NORMAL) {
                stage.displayState = StageDisplayState.FULL_SCREEN;
            } else {
                stage.displayState = StageDisplayState.NORMAL;
            }
        }

    }

}


import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.geom.Matrix;
import flash.filters.BlurFilter;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.events.Event;
//ColorTransform
import flash.geom.ColorTransform;
import flash.media.Sound;
import flash.media.SoundChannel;
import flash.media.SoundLoaderContext;
import flash.media.SoundMixer;
import flash.utils.ByteArray;
import flash.net.URLRequest;
import flash.system.Security;

class LightTune extends Sprite {
    private var rect:Rectangle;
    private var canvas:BitmapData;
    private var bitmapData:BitmapData;
    private static var scale:Number = 1.25;
    private var matrix:Matrix;
    private var blur:BlurFilter;
    private static var point:Point = new Point();
    private var light:EmitLight;
    //ColorTransform
    private var colorTrans:ColorTransform;
    private static var policyPath:String = "http://mutast.heteml.jp/crossdomain.xml";
    private var sound:Sound;
    private var channel:SoundChannel;
    private static var soundPath:String = "// forked from ProjectNya's LightFolium + SoundMixer
////////////////////////////////////////////////////////////////////////////////
// LightFolium + SoundMixer
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.events.Event;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.utils.ByteArray;
    import flash.net.URLRequest;
    import flash.geom.Rectangle;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var flare:FlareMap;
        private var detection:DetectPixels;
        private static var max:uint = 256;
        private static var cx:int = 232;
        private static var cy:int = 250;
        private static var fw:uint = 340;
        private static var fh:uint = 360;
        private static var tw:uint = 320;
        private static var th:uint = 320;
        private var area:Rectangle;
        private var folium:Sprite;
        private var lights:Array;
        //
        private var sound:Sound;
        private var channel:SoundChannel;
        private static var soundPath:String = "// forked from ProjectNya's LightFolium + SoundMixer
////////////////////////////////////////////////////////////////////////////////
// LightFolium + SoundMixer
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.events.Event;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.utils.ByteArray;
    import flash.net.URLRequest;
    import flash.geom.Rectangle;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var flare:FlareMap;
        private var detection:DetectPixels;
        private static var max:uint = 256;
        private static var cx:int = 232;
        private static var cy:int = 250;
        private static var fw:uint = 340;
        private static var fh:uint = 360;
        private static var tw:uint = 320;
        private static var th:uint = 320;
        private var area:Rectangle;
        private var folium:Sprite;
        private var lights:Array;
        //
        private var sound:Sound;
        private var channel:SoundChannel;
        private static var soundPath:String = "http://hwzhiyin.com/uploadfile/1367968019.mp3";
        private var byteArray:ByteArray;
        private static var channels:uint = 256;

        public function Main() {
            Wonderfl.capture_delay(11);
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            folium = new Sprite();
            addChild(folium);
            folium.x = cx - fw*0.5;
            folium.y = fh - th;
            lights = new Array();
            for (var n:uint = 0; n < max; n++) {
                var light:LightFolium = new LightFolium();
                var angle:Number = 360/max*n;
                light.init(fw*0.5, cy - fh + th, angle);
                folium.addChild(light);
                light.fly(200, 1, 2, 2);
                lights.push(light);
            }
            var rect:Rectangle = new Rectangle(0, 0, fw, fh);
            flare = new FlareMap(rect);
            addChild(flare);
            flare.x = cx;
            flare.y = fh;
            area = new Rectangle(0, 0, tw, th);
            detection = new DetectPixels(4);
            detection.search(folium, area, 0x66FFFFFF);
            flare.map = detection.pixels();
            flare.offset = {x: 0, y: fh - th};
            //flare.setup(6, 2, 60);
            flare.setup(8, 2, 64);
            flare.start();
            //
            sound = new Sound();
            sound.addEventListener(Event.COMPLETE, complete, false, 0, true);
            sound.load(new URLRequest(soundPath), new SoundLoaderContext(10, true));
            byteArray = new ByteArray();
        }
        private function complete(evt:Event):void {
            evt.target.removeEventListener(Event.COMPLETE, complete);
            start();
        }
        private function start():void {
            channel = sound.play(0, 1000);
            addEventListener(Event.ENTER_FRAME, update, false, 0, true);
        }
        private function update(evt:Event):void {
            detection.search(folium, area, 0x66FFFFFF);
            flare.map = detection.pixels();
            //
            SoundMixer.computeSpectrum(byteArray, true, 32);
            for (var n:uint = 0; n < channels*2; n++) {
                var light:LightFolium = lights[n%channels];
                var p:Number = byteArray.readFloat();
                light.fly(200, 1, p*100 + 2, p*100 + 2);
            }
        }

    }

}


import flash.display.Sprite;
import flash.geom.ColorTransform;
import flash.events.Event;

class LightFolium extends Sprite {
    private var light:Light;
    private var blink:Number;
    private var b:Number;
    private var trans:ColorTransform;
    private var tx:Number;
    private var ty:Number;
    private var cx:Number;
    private var cy:Number;
    private var r:Number;
    private var angle:Number;
    private var a:Number;
    private var nx:Number;
    private var ny:Number;
    private static var radian:Number = Math.PI/180;
    private static var deceleration:Number = 0.2;

    public function LightFolium() {
        light = new Light();
        addChild(light);
    }

    public function init(x:int, y:int, a:Number):void {
        this.x = cx = x;
        this.y = cy = y;
        angle = a;
    }
    public function fly(r:Number, a:Number, nx:Number, ny:Number, dec:Number = 0.2):void {
        this.r = r;
        this.a = a;
        this.nx = nx;
        this.ny = ny;
        deceleration = dec;
        addEventListener(Event.ENTER_FRAME, flying, false, 0, true);
    }
    private function flying(evt:Event):void {
        angle += a;
        tx = cx + r*Math.sin(angle*nx*radian)*Math.cos(angle*radian);
        ty = cy + r*Math.sin(angle*ny*radian)*Math.sin(angle*radian);
        x += (tx - x)*deceleration;
        y += (ty - y)*deceleration;
    }

}


import flash.display.Shape;
import flash.geom.Matrix;
import flash.display.GradientType;

class Light extends Shape {
    private static var center:Number = 2.5;
    private static var light:uint = 10;
    private static var color:uint = 0xFFFFFF;

    public function Light() {
        draw();
    }

    private function draw():void {
        graphics.beginFill(color);
        graphics.drawCircle(0, 0, center);
        graphics.endFill();
        var colors:Array = [color, color];
        var alphas:Array = [0.6, 0];
        var ratios:Array = [0, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(light*2, light*2, 0, -light, -light);
        graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, matrix);
        graphics.drawCircle(0, 0, light);
        graphics.endFill();
    }

}


import flash.display.Sprite;
import flash.display.Shape;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.events.Event;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.filters.BlurFilter;
import flash.display.BlendMode;
//import sketchbook.colors.ColorUtil;

class FlareMap extends Sprite {
    private var rect:Rectangle;
    private var fire:Rectangle;
    private var flare:BitmapData;
    private var bitmapData:BitmapData;
    private var bitmap:Bitmap;
    private var rPalette:Array;
    private var gPalette:Array;
    private var bPalette:Array;
    private static var point:Point = new Point(0, 0);
    private var speed:Point = new Point(0, -6);
    private var unit:uint = 8;
    private var segments:uint = 8;
    private var blur:BlurFilter;
    private var mapList:Array;
    public var offset:Object = {x: 0, y: 0};
    private var faded:uint = 0;
    public static const COMPLETE:String = Event.COMPLETE;

    public function FlareMap(r:Rectangle) {
        rect = r;
        initialize();
        draw();
    }

    public function setup(s:uint = 6, u:uint = 8, seg:uint = 8):void {
        speed.y = - s;
        unit = u;
        segments = seg;
    }
    public function set map(list:Array):void {
        mapList = list;
    }
    private function initialize():void {
        rPalette = new Array();
        gPalette = new Array();
        bPalette = new Array();
        for (var n:uint = 0; n < 256; n++) {
            var luminance:uint = (n < 128) ? n*2 : 0;
            //var rgb:Object = ColorUtil.HLS2RGB(n*360/256, luminance, 100);
            var rgb:Object = HLS2RGB(n*360/256, luminance, 100);
            var color:uint = rgb.r << 16 | rgb.g << 8 | rgb.b;
            rPalette[n] = color;
            gPalette[n] = 0;
            bPalette[n] = 0;
        }
        blur = new BlurFilter(2, 8, 3);
        blendMode = BlendMode.ADD;
    }
    private function draw():void {
        fire = new Rectangle(0, 0, rect.width, rect.height + 10);
        flare = new BitmapData(fire.width, fire.height, false, 0xFF000000);
        bitmapData = new BitmapData(rect.width, rect.height, false, 0xFF000000);
        bitmap = new Bitmap(bitmapData);
        addChild(bitmap);
        bitmap.x = - rect.width*0.5;
        bitmap.y = - rect.height;
    }
    public function start():void {
        addEventListener(Event.ENTER_FRAME, apply, false, 0, true);
    }
    private function apply(evt:Event):void {
        if (!mapList) return;
        flare.lock();
        bitmapData.lock();
        for (var n:uint = 0; n < segments; n++) {
            var id:uint = Math.random()*mapList.length;
            var px:int = mapList[id].x + offset.x;
            var py:int = mapList[id].y + offset.y;
            var range:Rectangle = new Rectangle(px, py, unit, 2)
            flare.fillRect(range, 0xFFFFFF);
        }
        flare.applyFilter(flare, fire, speed, blur);
        bitmapData.paletteMap(flare, rect, point, rPalette, gPalette, bPalette);
        flare.unlock();
        bitmapData.unlock();
    }
    private function clear(evt:Event):void {
        faded ++;
        flare.lock();
        bitmapData.lock();
        flare.applyFilter(flare, fire, speed, blur);
        bitmapData.paletteMap(flare, rect, point, rPalette, gPalette, bPalette);
        if (faded > 20) {
            bitmapData.fillRect(rect, 0x000000);
            removeEventListener(Event.ENTER_FRAME, clear);
            dispatchEvent(new Event(FlareMap.COMPLETE));
        }
        flare.unlock();
        bitmapData.unlock();
    }
    private function createEggMask(target:Shape):void {
        var w:Number = rect.width;
        var h:Number = rect.height*1.5;
        target.graphics.beginFill(0xFFFFFF);
        target.graphics.moveTo(-w*0.5, -h*0.2);
        target.graphics.curveTo(-w*0.4, -h, 0, -h);
        target.graphics.curveTo(w*0.4, -h, w*0.5, -h*0.2);
        target.graphics.curveTo(w*0.5, 0, 0, 0);
        target.graphics.curveTo(-w*0.5, 0, -w*0.5, -h*0.2);
        target.graphics.endFill();
    }
    private function HLS2RGB(h:Number, l:Number, s:Number):Object{
        var max:Number;
        var min:Number;
        h = (h < 0)? h % 360+360 : (h>=360)? h%360: h;
        l = (l < 0)? 0 : (l > 100)? 100 : l;
        s = (s < 0)? 0 : (s > 100)? 100 : s;
        l *= 0.01;
        s *= 0.01;
        if (s == 0) {
            var val:Number = l*255;
            return {r:val, g:val, b:val};
        }
        if (l < 0.5) {
            max = l*(1 + s)*255;
        } else {
            max = (l*(1 - s) + s)*255;
        }
        min = (2*l)*255 - max;
        return _hMinMax2RGB(h, min, max);
    }
    private function _hMinMax2RGB(h:Number, min:Number, max:Number):Object{
        var r:Number;
        var g:Number;
        var b:Number;
        var area:Number = Math.floor(h/60);
        switch(area){
            case 0:
                r = max;
                g = min + h * (max - min)/60;
                b = min;
                break;
            case 1:
                r = max - (h - 60)*(max - min)/60;
                g = max;
                b = min;
                break;
            case 2:
                r = min ;
                g = max;
                b = min + (h - 120)*(max - min)/60;
                break;
            case 3:
                r = min;
                g = max - (h - 180)*(max - min)/60;
                b =max;
                break;
            case 4:
                r = min + (h - 240)*(max - min)/60;
                g = min;
                b = max;
                break;
            case 5:
                r = max;
                g = min;
                b = max - (h - 300)*(max - min)/60;
                break;
            case 6:
                r = max;
                g = min + h*(max - min)/60;
                b = min;
                break;
        }
        r = Math.min(255, Math.max(0, Math.round(r)));
        g = Math.min(255, Math.max(0, Math.round(g)));
        b = Math.min(255, Math.max(0, Math.round(b)));
        return {r:r, g:g, b:b};
    }

}


import flash.display.BitmapData;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.geom.Matrix;
import flash.display.IBitmapDrawable;

class DetectPixels {
    private var bd:IBitmapDrawable;
    private var rect:Rectangle;
    private var map:BitmapData;
    private var mapList:Array;
    private var accuracy:uint;
    private var threshold:uint = 0x80FFFFFF;

    public function DetectPixels(a:uint = 1) {
        accuracy = a;
    }

    public function search(t:IBitmapDrawable, r:Rectangle, th:uint = 0x80FFFFFF):void {
        bd = t;
        rect = r;
        threshold = th;
        var w:uint = rect.width/accuracy;
        var h:uint = rect.height/accuracy;
        detect(w, h);
    }
    private function detect(w:uint, h:uint):void {
        map = new BitmapData(w, h, true, 0x00000000);
        var matrix:Matrix = new Matrix();
        matrix.translate(-rect.x, -rect.y);
        matrix.scale(1/accuracy, 1/accuracy);
        map.lock();
        map.draw(bd, matrix);
        map.unlock();
        mapList = new Array();
        for (var x:uint = 0; x < w; x++) {
            for (var y:uint = 0; y < h; y++) {
                var color:uint = map.getPixel32(x, y);
                if (color >= threshold) {
                    var px:int = x*accuracy + rect.x;
                    var py:int = y*accuracy + rect.y;
                    var point:Point = new Point(px, py);
                    mapList.push(point);
                }
            }
        }
    }
    public function pixels():Array {
        return mapList;
    }

}

        private var byteArray:ByteArray;
        private static var channels:uint = 256;

        public function Main() {
            Wonderfl.capture_delay(11);
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            folium = new Sprite();
            addChild(folium);
            folium.x = cx - fw*0.5;
            folium.y = fh - th;
            lights = new Array();
            for (var n:uint = 0; n < max; n++) {
                var light:LightFolium = new LightFolium();
                var angle:Number = 360/max*n;
                light.init(fw*0.5, cy - fh + th, angle);
                folium.addChild(light);
                light.fly(200, 1, 2, 2);
                lights.push(light);
            }
            var rect:Rectangle = new Rectangle(0, 0, fw, fh);
            flare = new FlareMap(rect);
            addChild(flare);
            flare.x = cx;
            flare.y = fh;
            area = new Rectangle(0, 0, tw, th);
            detection = new DetectPixels(4);
            detection.search(folium, area, 0x66FFFFFF);
            flare.map = detection.pixels();
            flare.offset = {x: 0, y: fh - th};
            //flare.setup(6, 2, 60);
            flare.setup(8, 2, 64);
            flare.start();
            //
            sound = new Sound();
            sound.addEventListener(Event.COMPLETE, complete, false, 0, true);
            sound.load(new URLRequest(soundPath), new SoundLoaderContext(10, true));
            byteArray = new ByteArray();
        }
        private function complete(evt:Event):void {
            evt.target.removeEventListener(Event.COMPLETE, complete);
            start();
        }
        private function start():void {
            channel = sound.play(0, 1000);
            addEventListener(Event.ENTER_FRAME, update, false, 0, true);
        }
        private function update(evt:Event):void {
            detection.search(folium, area, 0x66FFFFFF);
            flare.map = detection.pixels();
            //
            SoundMixer.computeSpectrum(byteArray, true, 32);
            for (var n:uint = 0; n < channels*2; n++) {
                var light:LightFolium = lights[n%channels];
                var p:Number = byteArray.readFloat();
                light.fly(200, 1, p*100 + 2, p*100 + 2);
            }
        }

    }

}


import flash.display.Sprite;
import flash.geom.ColorTransform;
import flash.events.Event;

class LightFolium extends Sprite {
    private var light:Light;
    private var blink:Number;
    private var b:Number;
    private var trans:ColorTransform;
    private var tx:Number;
    private var ty:Number;
    private var cx:Number;
    private var cy:Number;
    private var r:Number;
    private var angle:Number;
    private var a:Number;
    private var nx:Number;
    private var ny:Number;
    private static var radian:Number = Math.PI/180;
    private static var deceleration:Number = 0.2;

    public function LightFolium() {
        light = new Light();
        addChild(light);
    }

    public function init(x:int, y:int, a:Number):void {
        this.x = cx = x;
        this.y = cy = y;
        angle = a;
    }
    public function fly(r:Number, a:Number, nx:Number, ny:Number, dec:Number = 0.2):void {
        this.r = r;
        this.a = a;
        this.nx = nx;
        this.ny = ny;
        deceleration = dec;
        addEventListener(Event.ENTER_FRAME, flying, false, 0, true);
    }
    private function flying(evt:Event):void {
        angle += a;
        tx = cx + r*Math.sin(angle*nx*radian)*Math.cos(angle*radian);
        ty = cy + r*Math.sin(angle*ny*radian)*Math.sin(angle*radian);
        x += (tx - x)*deceleration;
        y += (ty - y)*deceleration;
    }

}


import flash.display.Shape;
import flash.geom.Matrix;
import flash.display.GradientType;

class Light extends Shape {
    private static var center:Number = 2.5;
    private static var light:uint = 10;
    private static var color:uint = 0xFFFFFF;

    public function Light() {
        draw();
    }

    private function draw():void {
        graphics.beginFill(color);
        graphics.drawCircle(0, 0, center);
        graphics.endFill();
        var colors:Array = [color, color];
        var alphas:Array = [0.6, 0];
        var ratios:Array = [0, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(light*2, light*2, 0, -light, -light);
        graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, matrix);
        graphics.drawCircle(0, 0, light);
        graphics.endFill();
    }

}


import flash.display.Sprite;
import flash.display.Shape;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.events.Event;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.filters.BlurFilter;
import flash.display.BlendMode;
//import sketchbook.colors.ColorUtil;

class FlareMap extends Sprite {
    private var rect:Rectangle;
    private var fire:Rectangle;
    private var flare:BitmapData;
    private var bitmapData:BitmapData;
    private var bitmap:Bitmap;
    private var rPalette:Array;
    private var gPalette:Array;
    private var bPalette:Array;
    private static var point:Point = new Point(0, 0);
    private var speed:Point = new Point(0, -6);
    private var unit:uint = 8;
    private var segments:uint = 8;
    private var blur:BlurFilter;
    private var mapList:Array;
    public var offset:Object = {x: 0, y: 0};
    private var faded:uint = 0;
    public static const COMPLETE:String = Event.COMPLETE;

    public function FlareMap(r:Rectangle) {
        rect = r;
        initialize();
        draw();
    }

    public function setup(s:uint = 6, u:uint = 8, seg:uint = 8):void {
        speed.y = - s;
        unit = u;
        segments = seg;
    }
    public function set map(list:Array):void {
        mapList = list;
    }
    private function initialize():void {
        rPalette = new Array();
        gPalette = new Array();
        bPalette = new Array();
        for (var n:uint = 0; n < 256; n++) {
            var luminance:uint = (n < 128) ? n*2 : 0;
            //var rgb:Object = ColorUtil.HLS2RGB(n*360/256, luminance, 100);
            var rgb:Object = HLS2RGB(n*360/256, luminance, 100);
            var color:uint = rgb.r << 16 | rgb.g << 8 | rgb.b;
            rPalette[n] = color;
            gPalette[n] = 0;
            bPalette[n] = 0;
        }
        blur = new BlurFilter(2, 8, 3);
        blendMode = BlendMode.ADD;
    }
    private function draw():void {
        fire = new Rectangle(0, 0, rect.width, rect.height + 10);
        flare = new BitmapData(fire.width, fire.height, false, 0xFF000000);
        bitmapData = new BitmapData(rect.width, rect.height, false, 0xFF000000);
        bitmap = new Bitmap(bitmapData);
        addChild(bitmap);
        bitmap.x = - rect.width*0.5;
        bitmap.y = - rect.height;
    }
    public function start():void {
        addEventListener(Event.ENTER_FRAME, apply, false, 0, true);
    }
    private function apply(evt:Event):void {
        if (!mapList) return;
        flare.lock();
        bitmapData.lock();
        for (var n:uint = 0; n < segments; n++) {
            var id:uint = Math.random()*mapList.length;
            var px:int = mapList[id].x + offset.x;
            var py:int = mapList[id].y + offset.y;
            var range:Rectangle = new Rectangle(px, py, unit, 2)
            flare.fillRect(range, 0xFFFFFF);
        }
        flare.applyFilter(flare, fire, speed, blur);
        bitmapData.paletteMap(flare, rect, point, rPalette, gPalette, bPalette);
        flare.unlock();
        bitmapData.unlock();
    }
    private function clear(evt:Event):void {
        faded ++;
        flare.lock();
        bitmapData.lock();
        flare.applyFilter(flare, fire, speed, blur);
        bitmapData.paletteMap(flare, rect, point, rPalette, gPalette, bPalette);
        if (faded > 20) {
            bitmapData.fillRect(rect, 0x000000);
            removeEventListener(Event.ENTER_FRAME, clear);
            dispatchEvent(new Event(FlareMap.COMPLETE));
        }
        flare.unlock();
        bitmapData.unlock();
    }
    private function createEggMask(target:Shape):void {
        var w:Number = rect.width;
        var h:Number = rect.height*1.5;
        target.graphics.beginFill(0xFFFFFF);
        target.graphics.moveTo(-w*0.5, -h*0.2);
        target.graphics.curveTo(-w*0.4, -h, 0, -h);
        target.graphics.curveTo(w*0.4, -h, w*0.5, -h*0.2);
        target.graphics.curveTo(w*0.5, 0, 0, 0);
        target.graphics.curveTo(-w*0.5, 0, -w*0.5, -h*0.2);
        target.graphics.endFill();
    }
    private function HLS2RGB(h:Number, l:Number, s:Number):Object{
        var max:Number;
        var min:Number;
        h = (h < 0)? h % 360+360 : (h>=360)? h%360: h;
        l = (l < 0)? 0 : (l > 100)? 100 : l;
        s = (s < 0)? 0 : (s > 100)? 100 : s;
        l *= 0.01;
        s *= 0.01;
        if (s == 0) {
            var val:Number = l*255;
            return {r:val, g:val, b:val};
        }
        if (l < 0.5) {
            max = l*(1 + s)*255;
        } else {
            max = (l*(1 - s) + s)*255;
        }
        min = (2*l)*255 - max;
        return _hMinMax2RGB(h, min, max);
    }
    private function _hMinMax2RGB(h:Number, min:Number, max:Number):Object{
        var r:Number;
        var g:Number;
        var b:Number;
        var area:Number = Math.floor(h/60);
        switch(area){
            case 0:
                r = max;
                g = min + h * (max - min)/60;
                b = min;
                break;
            case 1:
                r = max - (h - 60)*(max - min)/60;
                g = max;
                b = min;
                break;
            case 2:
                r = min ;
                g = max;
                b = min + (h - 120)*(max - min)/60;
                break;
            case 3:
                r = min;
                g = max - (h - 180)*(max - min)/60;
                b =max;
                break;
            case 4:
                r = min + (h - 240)*(max - min)/60;
                g = min;
                b = max;
                break;
            case 5:
                r = max;
                g = min;
                b = max - (h - 300)*(max - min)/60;
                break;
            case 6:
                r = max;
                g = min + h*(max - min)/60;
                b = min;
                break;
        }
        r = Math.min(255, Math.max(0, Math.round(r)));
        g = Math.min(255, Math.max(0, Math.round(g)));
        b = Math.min(255, Math.max(0, Math.round(b)));
        return {r:r, g:g, b:b};
    }

}


import flash.display.BitmapData;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.geom.Matrix;
import flash.display.IBitmapDrawable;

class DetectPixels {
    private var bd:IBitmapDrawable;
    private var rect:Rectangle;
    private var map:BitmapData;
    private var mapList:Array;
    private var accuracy:uint;
    private var threshold:uint = 0x80FFFFFF;

    public function DetectPixels(a:uint = 1) {
        accuracy = a;
    }

    public function search(t:IBitmapDrawable, r:Rectangle, th:uint = 0x80FFFFFF):void {
        bd = t;
        rect = r;
        threshold = th;
        var w:uint = rect.width/accuracy;
        var h:uint = rect.height/accuracy;
        detect(w, h);
    }
    private function detect(w:uint, h:uint):void {
        map = new BitmapData(w, h, true, 0x00000000);
        var matrix:Matrix = new Matrix();
        matrix.translate(-rect.x, -rect.y);
        matrix.scale(1/accuracy, 1/accuracy);
        map.lock();
        map.draw(bd, matrix);
        map.unlock();
        mapList = new Array();
        for (var x:uint = 0; x < w; x++) {
            for (var y:uint = 0; y < h; y++) {
                var color:uint = map.getPixel32(x, y);
                if (color >= threshold) {
                    var px:int = x*accuracy + rect.x;
                    var py:int = y*accuracy + rect.y;
                    var point:Point = new Point(px, py);
                    mapList.push(point);
                }
            }
        }
    }
    public function pixels():Array {
        return mapList;
    }

}

    private var byteArray:ByteArray;
    private static var channels:uint = 256;
    private var factors:uint = 0;

    public function LightTune(r:Rectangle) {
        rect = r;
        init();
    }

    private function init():void {
        canvas = new BitmapData(rect.width, rect.height, true, 0xFF000000);
        var bitmap:Bitmap = new Bitmap(canvas);
        bitmap.smoothing = true;
        addChild(bitmap);
        bitmapData = new BitmapData(rect.width, rect.height, false, 0xFF000000);
        matrix = new Matrix();
        matrix.scale(scale, scale);
        var w:int = (rect.width - rect.width*scale)*0.5;
        var h:int = (rect.height - rect.height*scale)*0.5;
        matrix.translate(w, h);
        blur = new BlurFilter(1, 1, 3);
        light = new EmitLight();
        addChild(light);
        light.initialize(40);
        light.x = rect.width*0.5;
        light.y = rect.height*0.5;
        //ColorTransform
        colorTrans = new ColorTransform(0.96, 0.96, 0.96, 1, 0, 0, 0, 0);
        //
        Security.loadPolicyFile(policyPath);
        sound = new Sound();
        sound.addEventListener(Event.COMPLETE, complete, false, 0, true);
        sound.load(new URLRequest(soundPath), new SoundLoaderContext(10, true));
        byteArray = new ByteArray();
    }
    private function complete(evt:Event):void {
        evt.target.removeEventListener(Event.COMPLETE, complete);
        start();
    }
    private function start():void {
        channel = sound.play(0, 1000);
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
    }
    private function update(evt:Event):void {
        SoundMixer.computeSpectrum(byteArray, true, factors);
        var data:Array = new Array();
        for (var n:uint = 0; n < channels; n++) {
            var p:Number = byteArray.readFloat();
                data.push(p);
        }
        draw(data);
    }
    private function draw(data:Array):void {
        light.create(data);
        bitmapData.lock();
        bitmapData.draw(this);
        bitmapData.applyFilter(bitmapData, rect, point, blur);
        bitmapData.unlock();
        canvas.lock();
        //ColorTransform
        canvas.draw(bitmapData, matrix, colorTrans, null, rect, true);
        canvas.unlock();
        light.emit();
    }

}


import flash.display.Sprite;
import flash.geom.Rectangle;
import flash.display.BlendMode;
import frocessing.color.ColorHSV;

class EmitLight extends Sprite {
    private var radius:uint;
    private var circles:Array;
    private static var deceleration:Number = 0.9;
    private var id:uint;
    private var color:ColorHSV;

    public function EmitLight() {
        init();
    }

    private function init():void {
        circles = new Array();
        color = new ColorHSV(0, 0.6, 1);
    }
    public function initialize(r:uint):void {
        radius = r;
    }
    public function create(data:Array):void {
        id ++;
        var angle:uint = id*3%360;
        color.h = angle;
        var circle:Circle = new Circle(color.value);
        addChild(circle);
        circle.x = Math.cos(-angle*Math.PI/180)*radius;
        circle.y = Math.sin(-angle*Math.PI/180)*radius;
        circle.vx = (Math.random()*2 - 1)*20;
        circle.vy = (Math.random()*2 - 1)*20;
        //circle.scale = Math.random()*0.75 + 0.25;
        circle.scale = data[1];
        circle.blendMode = BlendMode.HARDLIGHT;
        circles.push(circle);
    }
    public function emit():void {
        for (var n:uint = 0; n < circles.length; n++) {
            var circle:Circle = circles[n];
            circle.vx *= deceleration;
            circle.vy *= deceleration;
            circle.x += circle.vx;
            circle.y += circle.vy;
            circle.scale *= deceleration;
            if (circle.scale < 0.1) {
                circles.splice(n, 1);
                removeChild(circle);
                circle = null;
            }
        }
    }

}


import flash.display.Shape;

class Circle extends Shape {
    private static var radius:uint = 10;
    private var rgb:uint = 0xFFFFFF;
    private var _scale:Number = 1;
    public var vx:Number = 0;
    public var vy:Number = 0;

    public function Circle(c:uint = 0xFFFFFF) {
        rgb = c;
        draw();
    }

    private function draw():void {
        graphics.clear();
        graphics.beginFill(rgb);
        graphics.drawCircle(0, 0, radius);
        graphics.drawCircle(0, 0, radius*0.6);
        graphics.endFill();
    }
    public function get scale():Number {
        return _scale;
    }
    public function set scale(param:Number):void {
        _scale = param;
        scaleX = scaleY = _scale;
    }

}


//////////////////////////////////////////////////
// Btnクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;

class Btn extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var bottom:Shape;
    private var light:Shape;
    private var base:Shape;
    private var txt:TextField;
    private var label:String = "";
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 60;
    private static var _height:uint = 20;
    private static var corner:uint = 5;
    private var type:uint = 1;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var upColor:uint = 0x666666;
    private static var overColor:uint = 0x333333;
    private static var offColor:uint = 0x999999;
    private static var gColor:uint = 0x0099FF;
    private var blueGlow:GlowFilter;
    private var shadeGlow:GlowFilter;
    private var _clicked:Boolean = false;
    private var _enabled:Boolean = true;

    public function Btn() {
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.label != undefined) label = option.label;
        if (option.width != undefined) _width = option.width;
        if (option.type != undefined) type = option.type;
        draw();
    }
    private function draw():void {
        switch (type) {
        case 1 :
            bColor = 0xFFFFFF;
            sColor = 0x000000;
            upColor = 0x666666;
            overColor = 0x333333;
            offColor = 0x999999;
            break;
        case 2 :
            bColor = 0x000000;
            sColor = 0xFFFFFF;
            upColor = 0x666666;
            overColor = 0x999999;
            offColor = 0x333333;
            break;
        }
        blueGlow = new GlowFilter(gColor, 0.6, 5, 5, 2, 3, false, true);
        shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);
        shade = new Shape();
        bottom = new Shape();
        light = new Shape();
        base = new Shape();
        txt = new TextField();
        addChild(shade);
        addChild(bottom);
        addChild(light);
        addChild(base);
        addChild(txt);
        createBase(shade, _width, _height, corner, sColor);
        shade.filters = [shadeGlow];
        createBase(bottom, _width, _height, corner, sColor, 0.3);
        createBase(light, _width, _height, corner, gColor);
        light.filters = [blueGlow];
        createBase(base, _width, _height, corner, bColor);
        txt.x = -_width*0.5;
        txt.y = -_height*0.5;
        txt.width = _width;
        txt.height = _height - 1;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 12;
        tf.align = TextFormatAlign.CENTER;
        txt.defaultTextFormat = tf;
        txt.text = label;
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
    }
    private function release(evt:MouseEvent):void {
        _up();
    }
    private function click(evt:MouseEvent):void {
    }
    private function _up():void {
        txt.y = -_height*0.5;
        txt.textColor = upColor;
        base.y = -1;
        light.visible = false;
        light.y = -1;
    }
    private function _over():void {
        txt.y = -_height*0.5;
        txt.textColor = overColor;
        base.y = -1;
        light.visible = true;
        light.y = -1;
    }
    private function _down():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = overColor;
        base.y = 0;
        light.visible = true;
        light.y = 0;
    }
    private function _off():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = offColor;
        base.y = 0;
        light.visible = false;
        light.y = 0;
    }
    public function get clicked():Boolean {
        return _clicked;
    }
    public function set clicked(param:Boolean):void {
        _clicked = param;
        enabled = !_clicked;
        if (_clicked) {
            _down();
        } else {
            _up();
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
            _off();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
            removeEventListener(MouseEvent.CLICK, click);
        }
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w*0.5, -h*0.5, w, h, c*2);
        target.graphics.endFill();
    }

}
