/**
 * Copyright namagome ( http://wonderfl.net/user/namagome )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aKS4
 */

// forked from clockmaker's [PV3D] Field of Blur
/**
* Papervision3Dで被写界深度
* 参照： http://clockmaker.jp/blog/2008/07/pv3d_gw_blur/
*/
package
{
	import flash.display.*;
	import flash.events.*;
	import flash.filters.*;
	
	import org.papervision3d.view.*;
	import org.papervision3d.materials.*;
	import org.papervision3d.objects.*;
	import org.papervision3d.objects.primitives.*
	
        [SWF(width = "960", height = "540", frameRate = "60", backgroundColor = "#000000")]
	
	public class Main extends BasicView 
	{	
		// const vars
		static private const OBJ_LENGTH   :int = 2;
		static private const CIRCLE_RANGE :int = 500;
		
		// 3d vars
		private var list :Array = []
		private var wrap :DisplayObject3D;

		/**
		 * Constructor
		 */
		public function Main()
		{
			//camera
			var H:int = 50;
			
			//camera.x         = H/2;
			camera.x         = -H/2;
			camera.y         = 200;
			camera.z         = 1000;
			//camera.rotationX = 5;
			
			// wrap
			wrap = new DisplayObject3D();
			scene.addChild(wrap);
			
			for (var i:int = 0; i < OBJ_LENGTH; i++)
			{
				var rot:Number = 360 * i / OBJ_LENGTH ;
				
				var m:WireframeMaterial = new WireframeMaterial(0xffffff);
				m.doubleSided = true;
				
				var o:Sphere = new Sphere(m, 100, 10, 10);
				o.x = CIRCLE_RANGE * Math.sin(rot * Math.PI / 180);
				o.y = 0;
				o.z = CIRCLE_RANGE * Math.cos(rot * Math.PI / 180);
				o.rotationY = rot;
				o.useOwnContainer = true; //ココ重要
				
                                // 配列に追加　＆　wrapの子供にする
				list.push(wrap.addChild(o));
				
				var p:ColorMaterial = new ColorMaterial(0xff0000);
				var P:Cylinder = new Cylinder(p,5,1000,10,1,5);
				scene.addChild(P);
			}
			
			addEventListener(Event.ENTER_FRAME, loop);
			startRendering(); 
		}
		
                // loop
		private function loop(event:Event):void
		{
			wrap.yaw(-1);
                        
                        // 被写界深度
			/*for (var i:int = 0; i < list.length; i++)
			{
				var o:DisplayObject3D = list[i] as DisplayObject3D;
				var blur:Number = Math.ceil((CIRCLE_RANGE - o.sceneZ) / 50); 
				o.filters = [new BlurFilter(blur, blur, 1)];
			}*/
		}
	}
}