/**
 * Copyright bkzen ( http://wonderfl.net/user/bkzen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aJ82
 */

// forked from ProjectNya's Alternativa3D [sphere]
////////////////////////////////////////////////////////////////////////////////
// Alternativa3D [sphere]
//
// [Alt3D] 球体 (1)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1748
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import flash.display.Stage3D;
    import flash.events.Event;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import alternativa.Alternativa3D;
    import alternativa.engine3d.core.Object3D;
    import alternativa.engine3d.core.Camera3D;
    import alternativa.engine3d.core.View;
    import alternativa.engine3d.core.Resource;
    import alternativa.engine3d.primitives.GeoSphere;
    import alternativa.engine3d.objects.WireFrame;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="60")]

    public class Main extends Sprite {
        private var stage3D:Stage3D;
        private var scene:Object3D;
        private var camera:Camera3D;
        private var sphere:WireFrame;
        private static var radius:uint = 500;
        private var angle:Number = 90;
        private var degree:Number = 0;
        private static var depression:uint = 30;
        private static var radian:Number = Math.PI/180;
        private static var center:Object3D = new Object3D();
        //private var source:BitmapData = new BitmapData(465, 465, false, 0x000000);

        public function Main() {
            Wonderfl.disable_capture();
            //addChild(new Bitmap(source));
            //
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            init();
        }

        private function init():void {
            scene = new Object3D();
            camera = new Camera3D(1, 1000);
            scene.addChild(camera);
            //camera.view = new View(465, 465, false, 0x000000, 1, 4);
            camera.view = new View(465, 465, true, 0x000000, 1, 4);
            addChild(camera.view);
            setup();
            addChild(camera.diagram);
            //
            stage3D = stage.stage3Ds[0];
            stage3D.addEventListener(Event.CONTEXT3D_CREATE, context, false, 0, true);
            stage3D.requestContext3D();
        }
        private function setup():void {
            camera.x = - radius;
            camera.y = 0;
            camera.z = 0;
            TransformUtils.lookAt(center, camera);
        }
        private function initialize():void {
            var mesh:GeoSphere = new GeoSphere(200, 5, false, null);
            sphere = WireFrame.createEdges(mesh, 0xFFFFFF, 1, 1);
            scene.addChild(sphere);
        }
        private function context(evt:Event):void {
            stage3D.removeEventListener(Event.CONTEXT3D_CREATE, context);
            initialize();
            for each (var resource:Resource in scene.getResources(true)) {
                resource.upload(stage3D.context3D);
            }
            addEventListener(Event.ENTER_FRAME, render, false, 0, true)
        }
        private function render(evt:Event):void {
            camera.view.width = stage.stageWidth;
            camera.view.height = stage.stageHeight;
            //
            angle += 0.5;
            degree += 1;
            var dip:Number = depression*Math.sin(degree*radian);
            camera.x = radius*Math.cos(angle*radian)*Math.cos(dip*radian);
            camera.y = radius*Math.sin(angle*radian)*Math.cos(dip*radian);
            camera.z = radius*Math.sin(dip*radian);
            TransformUtils.lookAt(center, camera);
            //
            camera.render(stage3D);
        }
        
    }

}


//////////////////////////////////////////////////
// TransformUtilsクラス
//////////////////////////////////////////////////

import alternativa.engine3d.core.Object3D;
import alternativa.engine3d.core.Camera3D;

class TransformUtils {
    private static var radian:Number = Math.PI/180;

    public function TransformUtils() {
    }

    public static function lookAt(target:Object3D, camera:Camera3D):void {
        var dx:Number = target.x - camera.x;
        var dy:Number = target.y - camera.y;
        var dz:Number = target.z - camera.z;
        camera.rotationX = Math.atan2(dz, Math.sqrt(dx*dx + dy*dy)) - 90*radian;
        camera.rotationY = 0;
        camera.rotationZ = - Math.atan2(dx, dy);
    }

}
