/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aIoi
 */

/*
 * メタデータタグについて
 * 
 * FlashCS4以降やwonderfl(Flex)で背景色などを指定するにはメタデータタグを用いる。
 * [SWF(backgroundColor = 0xFFCCCC, width = 465, height = 465, frameRate = 1)]
 * 
 * ただし、これは公式の説明には無い。
 * http://livedocs.adobe.com/flex/3_jp/html/help.html?content=metadata_3.html
 * 
 * 参考
 * http://maglog.jp/lightbox/Article459511.html
 * */
package {
	import flash.display.Sprite;
	import flash.events.Event;
	
	//
	//backgroundColor = 0xFFCCCCで背景色
	//widthとheight = 465はステージサイズ
	//frameRate = 1はフレームレート。普通は30
	[SWF(backgroundColor = 0xFFCCCC, width = 465, height = 465, frameRate = 1)]
	
	public class Main extends Sprite {
		private var _shikaku:Sprite;
		public function Main() {
			trace("Hello world");
			
			_shikaku = new Sprite();
			_shikaku.graphics.beginFill(0x0000FF);
			_shikaku.graphics.drawRect(0, 0, 100, 100);
			_shikaku.graphics.endFill();
			_shikaku.x = stage.stageWidth / 2;
			_shikaku.y = stage.stageHeight / 2;
			this.addChild(_shikaku);
			
			this.addEventListener(Event.ENTER_FRAME, onEnter);
		}
		
		private function onEnter(event:Event):void {
			_shikaku.rotation += 6;
		}
	}
}

