/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aIH7
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;
    // @see http://projecteuler.net/index.php?section=problems&id=119
    public class Euler extends Sprite {
        private var _tf : TextField;
  
        public function Euler() {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
            addChild(_tf);
            
            var s : int = getTimer();
            _tf.appendText(solve().toString() + "\n");
            var g : int = getTimer();
            _tf.appendText((g - s).toString() + " ms\n");
        }
        
        private function solve() : int
        {
            var qs : Array = [0, 0];
            for(var ind : int = 1;ind <= 30;){
                // 各底の未確認の指数でlogを計算して最小のp^qとなるp,qを求める。
                var min : Number = Number.MAX_VALUE;
                var minp : int = -1;
                for(var p : int = 2;p < qs.length;p++){
                    // Numberの範囲で終わるのでlogにする意味実はあんまりない
                    // キャッシュ化も可
                    var v : Number = qs[p] * Math.log(p);
                    if(v < min){
                        min = v;
                        minp = p;
                    }
                }
                // 制限つけないとqsのサイズが肥大化して終わらなくなるので
                if(qs.length < 100){
                    v = 2 * Math.log(p);
                    if(v < min){
                        min = v;
                        minp = p;
                        qs.push(2);
                    }
                }
//                _tf.appendText(min.toString() + "\n");
            
                // p^qを計算して各桁の和を出して判定
                var vv : Number = Math.pow(minp, qs[minp]);
                var dig : int = 0;
                for(var i : Number = vv;i > 0;i /= 10){
                    dig += i % 10;
                }
                if(minp == dig){
//                _tf.appendText(qs.length.toString() + "\n");
                    _tf.appendText(minp.toString() + "^" + qs[minp].toString() + " = " + vv.toString() + "\n")
                    ind++;
                }
                qs[minp]++;
            }
            return -1;
        }
    }
}