/**
 * Copyright kanatara ( http://wonderfl.net/user/kanatara )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aI8Y
 */

// forked from uwi's Project Euler 268
package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.events.Event;
    import flash.utils.getTimer;
    // @see http://projecteuler.net/index.php?section=problems&id=268
    public class Euler268 extends Sprite {
        private var _tf : TextField;
  
        public function Euler268() {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
            addChild(_tf); 
            
            var s : int = getTimer();
            tr(solve(1E3));
            var g : int = getTimer();
            tr((g - s) + " ms");
        }

        private function solve(M : Number) : Number
        {
            var primes : Array = sieveEratosthenes(100);
            var m : Vector.<Number> = new Vector.<Number>(1<<25);
            m[0] = M;
            var n : uint = primes.length;
            var q : Vector.<uint> = Vector.<uint>([0]);
            var i : uint, j : uint;
            var sum : Number = 0;
            var t : uint = 0;
            var cor : Array = new Array(15);
            for(i = 0;i < 15;i++)cor[i] = 0;
            
            addEventListener(Event.ENTER_FRAME, function(e:Event) : void
            {
                var nq : Vector.<uint> = new Vector.<uint>();
                var lsum : Number = 0;
                for each(var c : uint in q){
                    if(t >= 4)lsum += m[c];
                    for(i = 0;i < n;i++){
                        if(c >> i == 0){
                            var nct : Number = Math.floor(m[c] / primes[i]);
                            if(nct == 0)break;
                            m[c|(1<<i)] = nct;
                            nq.push(c|(1<<i));
                        }
                    }
                } 
                
                if(t >= 4){
                    var sub : int = 1 - cor[t];
                    cor[t] = sub;
                    for(i = t+1;i < 15;i++){
                        cor[i] += sub * C(i, t);
                    }
                    sum += cor[t] * lsum;
                }
                
                tr(t, nq.length, sum);
                if(!nq.length){
                    removeEventListener(Event.ENTER_FRAME, arguments.callee);
                    tr(sum);
                    return;
                }

                q = nq;
                t++;
            });
            return 0;
        }
        
        private function C(n : uint, k : uint) : Number
        {
            var ret : Number = 1;
            for(var i : uint = 1;i <= k;i++){
                ret *= (n - i + 1);
                ret /= i;
            }
            return ret;
        }
        
        private function sieveEratosthenes(n : int) : Array
        {
            var nn : uint = ((n / 2 - 1) >>> 5) + 1;
            var ar : Vector.<uint> = new Vector.<uint>(nn);
            var i : uint, j : uint;
            for(i = 0;i < nn - 1;i++)ar[i] = 0xffffffff;
            ar[nn - 1] = (1 << ((n / 2 - 1) & 31)) - 1;
            
            var sq : uint = (Math.sqrt(n) - 3) >>> 1;
            for(var p : uint = 0;p <= sq;p++){
                if(ar[p >>> 5] & (1 << (p & 31))){
                    var m : uint = (p << 1) + 3;
                    var m2 : uint = m << 1;
                    for(var mm : uint = m * m;mm <= n;mm += m2){
                        var ind : uint = (mm - 3) >>> 1;
                        ar[ind >>> 5] &= ~(1 << (ind & 31));
                    }
                }
            }
            
            var ret : Array = [2];
            for(i = 0;i < nn;i++){
                for(j = 0;j <= 31;j++){
                    if(ar[i] & (1 << j))ret.push((((i << 5) | j) << 1) + 3);
                }
            }
            return ret;
        }

        private function tr(...o : Array) : void
        {
            _tf.appendText(o + "\n");
            _tf.scrollV = _tf.maxScrollV;
        }
    }
}