/**
 * Copyright mex_takagi ( http://wonderfl.net/user/mex_takagi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aHr6
 */

// forked from mex's 【AS100本ノック】2回目：たま
/* 
 * AS100本ノック
 * 2回目のお題は「たま」
 * あなたなりの「たま」を表現してください。
 * 
 * メタボール。
 * フィルタの調整がかなり大変。
 */
package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapDataChannel;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.display.BitmapData;
	import flash.display.GradientType;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.filters.BevelFilter;
	import flash.filters.BlurFilter;
	import flash.filters.DropShadowFilter;
	import flash.filters.GlowFilter;
	import flash.geom.*;
	import flash.utils.Timer;
	
	/**
	 * @author Mao Takagi
	 */
	public class FlashTest extends Sprite
	{
		public var stageW:uint;
		public var stageH:uint;
		private var _canvasSprite:Sprite;
		private var _canvasBmd:BitmapData;
		private var _canvas:Bitmap;
		private var _maskSprite:Sprite;
		private var _maskBmd:BitmapData;
		private var _alphaArray:Array;
		private var _move:Ball;
		private var _ballSize:uint;
		private var _blur:BlurFilter;
		private var _bevel1:BevelFilter;
		private var _bevel2:BevelFilter;
		private var _bevel3:BevelFilter;
		private var _bevel4:BevelFilter;
		private var _drop:DropShadowFilter;
		private var _timer:Timer;
		/**
		 * constructor
		 */
		public function FlashTest()
		{
			stageW = 465;
			stageH = 465;
			_canvasSprite = new Sprite();
			_canvasBmd = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00000000);
			_canvas = new Bitmap(_canvasBmd);
			_maskSprite = new Sprite();
			_maskBmd = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00000000);
			_alphaArray = new Array();
			_blur = new BlurFilter(4, 4, 2);
			_bevel1 = new BevelFilter(7,  54, 0x000000, 0, 0xFFFFFF, 1, 5, 5);
			_bevel2 = new BevelFilter(4, 90, 0x000000, 0, 0x000000, 1, 4, 4);
			_bevel3 = new BevelFilter(6, -70, 0x000000, 0.4, 0x000000, 0.6, 5, 5);
			_bevel4 = new BevelFilter(4, 20, 0x000000, 0, 0x000000, 1, 4, 4);
			
			_drop = new DropShadowFilter(2, 10, 0x000000, 0.9, 2, 2); 
			_timer = new Timer(700);
			_timer.addEventListener(TimerEvent.TIMER, timerHandler);
			
			var i:uint = 0;
			for (i = 0; i < 150; i++) {_alphaArray.push(0x00000000);}
			for (i = 150; i <= 255; i++) { _alphaArray.push(0xFF000000); }
			
			//_move = new Ball(this, 100);
			//_canvasSprite.addChild(_move);
			_canvas.filters = [_bevel3, _bevel4, _bevel2, _bevel1, _drop];
			
			_maskSprite.addChild(new Bitmap(_maskBmd));
			_maskSprite.addChild(createBlack());
			_maskSprite.addChild(createBlack());
			_maskSprite.addChild(createBlack());
			
			var bg:Shape = createGradient();
			//bg.rotation = 90;
			//bg.x = stageW;
			addChild(bg);
			addChild(_canvas);
			//_canvas.blendMode = "overlay";
			//addChild(_maskSprite);
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
			_timer.start();
			//addChild(_canvasSprite);
			Wonderfl.capture_delay( 5 );
		}
		/**
		 * enterFrameHandler
		 * @param event Event
		 */
		public function enterFrameHandler(event:Event):void
		{
			_maskBmd.fillRect(_maskBmd.rect, 0xFFFFFF);
			_maskBmd.lock();
			_maskBmd.draw(_canvasSprite);
			_maskBmd.paletteMap(_maskBmd, _maskBmd.rect, _maskBmd.rect.topLeft, null, null, null, _alphaArray);
			_maskBmd.applyFilter(_maskBmd, _maskBmd.rect, new Point(0, 0), _blur);
			_maskBmd.unlock();
			
			var mainMask:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00000000);
			mainMask.draw(_maskSprite);
			
			_canvasBmd.lock();
			_canvasBmd.draw(createBallGradient());
			_canvasBmd.copyChannel(mainMask, mainMask.rect, new Point(0, 0), BitmapDataChannel.RED, BitmapDataChannel.ALPHA);
			_canvasBmd.unlock();
			
			//_move.x = stage.mouseX;
			//_move.y = stage.mouseY;
		}
		/**
		 * ボール作成
		 * @param event TimerEvent
		 */
		private function timerHandler(event:TimerEvent):void 
		{
			var size:uint = Math.floor(Math.random() * (150 - 80 + 1)) + 80;
			var ball:Ball = new Ball(this, size);
			_canvasSprite.addChild(ball);
			ball.move();
		}
		/**
		 * ボール削除
		 * @param ball
		 */
		public function removeBall(ball:Ball):void 
		{
			_canvasSprite.removeChild(ball);
			ball = null;
		}
		/**
		 * グラデーション作成
		 * @param 
		 */
		private function createGradient():Shape 
		{
			var shape:Shape = new Shape();
			var colors:Array = [0xAAAAAA, 0xDDDDDD, 0xEEEEEE, 0xDDDDDD, 0xAAAAAA];
			var alphas:Array = [1, 1, 1, 1, 1];
			var ratios:Array = [0, 160, 180, 200, 255];
			var matrix:Matrix = new Matrix();
			matrix.createGradientBox(stage.stageWidth, stage.stageHeight);
			shape.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix);
			shape.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
			return shape;
		}
		/**
		 * ball用グラデーション作成
		 * @param 
		 */
		private function createBallGradient():Shape 
		{
			var shape:Shape = new Shape();
			var colors:Array = [0xEEEEEE, 0xAAAAAA];
			var alphas:Array = [1, 1];
			var ratios:Array = [0, 255];
			var matrix:Matrix = new Matrix();
			matrix.createGradientBox(stage.stageWidth, stage.stageHeight);
			shape.graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, matrix);
			shape.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
			return shape;
		}
		/**
		 * オーバーレイ用の黒ベタ作成
		 * @param 
		 */
		private function createBlack():Shape 
		{
			var shape:Shape = createSquare(0x000000);
			shape.blendMode = "overlay";
			return shape;
		}
		/**
		 * createSquare
		 * @param color
		 */
		private function createSquare(color:uint):Shape 
		{
			var shape:Shape = new Shape();
			shape.graphics.beginFill(color);
			shape.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
			shape.graphics.endFill();
			return shape;
		}
	}
}
import flash.display.Sprite;
import flash.display.GradientType;
import flash.events.Event;
import flash.geom.Matrix;
import org.libspark.betweenas3.events.TweenEvent;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.easing.*;
class Ball extends Sprite
{
	private var _container:FlashTest;
	private var _size:uint;
	/**
	 * constructor
	 */
	public function Ball(container:FlashTest, size:uint)
	{
		_container = container;
		_size = size;
		var roundUp:Number = _size / 2;
		var roundBottom:Number = roundUp / 10 * 9;
		var colors:Array = [0xFFFFFF, 0xFFFFFF, 0xFFFFFF];
		var alphas:Array = [1, 1, 0];
		var ratios:Array = [0, 180, 255];
		var matrix:Matrix = new Matrix();
		//matrix.createGradientBox(_size, _size, 0, -_size / 2, -_size / 2);
		graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, matrix);
		//graphics.drawCircle(0, 0, _size / 2);
		graphics.drawRoundRectComplex(-roundUp, -roundUp, roundUp * 2, roundUp + roundBottom, roundUp, roundUp, roundBottom, roundBottom);
		x = Math.random() * _container.stageW;
		y = -_size;
		scaleX = Math.random() * 0.2 + 0.6;
		scaleY = Math.random() * 0.2 + 0.7;
		//rotation = Math.random() * 180;
	}
	/**
	 * addListener
	 */
	public function move():void 
	{
		var ball:Ball = this;
		var targetX:Number = Math.random() * _container.stageW;
		var targetY:Number = _container.stageH + _size;
		var time:uint = Math.floor(Math.random() * (6 - 4 + 1) + 4);
		var t:ITween = BetweenAS3.tween(this, { x:targetX, y:targetY }, null, time, Linear.easeIn);
		t.addEventListener(TweenEvent.COMPLETE, function(event:TweenEvent):void
		{
			t.removeEventListener(TweenEvent.COMPLETE, arguments.callee);
			_container.removeBall(ball);
		});
		t.play();
	}
}