/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aHU1
 */

package {import flash.display.Sprite;import flash.events.Event;[SWF(backgroundColor=0x000000, width=465, height=456, frameRate=30)]public class FakeStage extends Sprite {
    public var bgColor:uint = 0x000000;            
public function FakeStage() {stage ? init() : addEventListener(Event.ADDED_TO_STAGE,init);} private function init(e:Event = null):void {removeEventListener(Event.ADDED_TO_STAGE,init);fillBg();addChild(new Main());stage.addEventListener(Event.RESIZE,fillBg);}private function fillBg(e:Event=null):void{graphics.clear();graphics.beginFill(bgColor);graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);graphics.endFill();}}}
import flash.display.BlendMode;
import flash.events.MouseEvent;
import flash.filters.GlowFilter;
import flash.events.Event;
import flash.display.Graphics;
import flash.geom.ColorTransform;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.display.Sprite;
import frocessing.color.ColorRGB;
import frocessing.color.ColorHSV;
import com.bit101.components.*;

class Vars
{
    public static var multi              :Number = 0.87;    
    
    public static var redOffset       :Number = 0.00;    
    public static var greenOffset   :Number = 0.00;    
    public static var blueOffset     :Number = 0.00;    
    public static var alphaOffset   :Number = 1.00;
    
    public static var redMulti        :Number = multi;    
    public static var greenMulti    :Number = multi;    
    public static var blueMulti      :Number = multi;    
    public static var alphaMulti    :Number = 1.00;
}



function max(value1:Number,value2:Number):Number
{
    return value1 > value2 ? value1 : value2;
}
function min(value1:Number,value2:Number):Number
{
    return value1 < value2 ? value1 : value2;
}
function range(value:Number,min:Number = 0,max:Number = 1):Number
{
    return (value < min ? min : (value > max ? max : value));
}
function sign(value:Number):int
{
    return value < 0 ? -1 : 1;
}
function rnd(value:Number = 0 ,noZero:Boolean = false):Number
{
    if(value == 0) return Math.random();
    return Math.random() * value + (noZero ? 1 : 0);
}
function rndRange(min:Number,max:Number):Number
{
    return rnd() * (max - min) + min;
}
function rndSign():int
{
     return sign(rnd() - .5);   
}





class Main extends Sprite
{
    private var s:ShadowSprite;
    
    private var c:ColorShape;
    
    private var r1:RotateColorShape;
    private var r2:RotateColorShape;
    private var r3:RotateColorShape;
    
    private var l:ColorLine;
    
    public function Main()
    {
        s = new ShadowSprite(465,465);
        c = new ColorShape();
        l = new ColorLine();
        
        addChild(s);
        s.s.addChild(c);
        s.s.addChild(l);
        
        var lbl:Label = new Label(this,5,5,"Click on stage");
        lbl.scaleX = lbl.scaleY = 3;
        
        change();
        
        addEventListener(Event.ENTER_FRAME,draw);
        addEventListener(MouseEvent.CLICK,change);
    }
    
    private function draw(e:Event):void
    {
        r1.rotate();
        r2.rotate();
        r3.rotate();
        
        c.draw(mouseX,mouseY);
        l.move();
        
        s.fade();
    }
    
    private function change(e:MouseEvent = null):void
    {
        if(r1) 
        {
            s.s.removeChild(r1);
            s.s.removeChild(r2);
            s.s.removeChild(r3);
            
        }
        
        r1 = new RotateColorShape(465 / 2,465 / 2, 200);
        r2 = new RotateColorShape(465 / 2,465 / 2, 200);
        r3 = new RotateColorShape(465 / 2,465 / 2, 200);
        
        r1.rotationSpeed = rndSign() * Math.PI / rndRange(60,130);
        r2.rotationSpeed = rndSign() * Math.PI / rndRange(60,130);
        r3.rotationSpeed = rndSign() * Math.PI / rndRange(60,130);
        
        r1.draw(0,0);
        r2.draw(0,0);
        r3.draw(0,0);
        
        r1.angle = 0;
        r2.angle = (Math.PI * 2) / 3;
        r3.angle = 4 * Math.PI / 3;
        
        
        s.s.addChild(r1);
        s.s.addChild(r2);
        s.s.addChild(r3);
        
        l.draw(0,0);
    }

}


class ColorShape extends Sprite
{
    public static var nextColor:int = 0;
    
    public function draw(nx:Number,ny:Number):void
    {
        blendMode = BlendMode.ADD;
        
        nextColor+= 8;
        
        range(nextColor,0,360);
        
        var color:int = new ColorHSV(nextColor, 1, 1).toRGB().value
        
        //0xFFFFFF * rnd();
        
        var g:Graphics = graphics;
        var rt:Number = rndRange(1.3,3);
        var rr:Number = rndRange(5,25);
        var rx:Number = rndRange(0,5) * rndSign();
        var ry:Number = rndRange(0,5) * rndSign();
        g.clear();
        g.lineStyle(rt,0xFFFFFF);
        
        var drawShape:Number = rnd();
        
        if(drawShape > .66)
            g.drawCircle(0,0,rr);
        else if(drawShape > .33)
        {
            g.drawRect(-rr,-rr,rr * 2, rr * 2);
        } else {
            g.moveTo(-rr,rr);
            g.lineTo(rr,rr);
            g.lineTo(0,-rr);
            g.lineTo(-rr,rr);
        }

        rotation = rnd() * 360;
        
        
        filters = [new GlowFilter(
            
            color
            ,1              // Alpha
            ,6 * rt        // BlurX
            ,6 * rt        // BlurY
            ,4             // Strength
            ,3
        )];
        
        x = nx + rx;
        y = ny + ry;
    }
}

class ColorLine extends ColorShape
{
    private var dir:int = 1;
    private var pos:Number = 0;
    
    override public function draw(nx:Number,ny:Number):void
    {
        super.draw(0,0);
        
    }
    
    public function move():void
    {
        pos += 2 * dir;
        if(pos >= 465)
        {
            pos = 465;
            dir = -1;
        } else if(pos <= 0) {
            pos = 0;
            dir = 1; 
        }
        
        x = y = 0;
        rotation = 0;
        
        var g:Graphics = graphics;
        g.clear();
        g.lineStyle(5,0xFFFFFF);
        g.moveTo(0,pos);
        g.lineTo(465,pos);
    }


}

class RotateColorShape extends ColorShape
{
    public var radius:Number = 90;
    public var px:Number = 200;
    public var py:Number = 200;
    public var angle:Number = 0;
    public var rotationSpeed:Number = Math.PI / 100;
    
    public function RotateColorShape(x:Number,y:Number,radius:Number)
    {
        px = x;
        py = y;
        this.radius = radius;
    }
    //rotate me in radians.
    public function rotate(value:Number = 0):void
    {
        angle += value == 0 ? rotationSpeed : value;
        range(angle, 0, Math.PI * 2);
        this.x = Math.cos(angle) * radius + px;
        this.y = Math.sin(angle) * radius + py;
    }
}






class ShadowSprite extends Sprite
{
    public var bmp:Bitmap;
    public var bmpdata:BitmapData;
    public var drawMe:Sprite;
    
    public function ShadowSprite(w:Number,h:Number)
    {
        bmpdata = new BitmapData(w, h,false,0);
        bmp = new Bitmap(bmpdata);
        addChild(bmp);
        drawMe = new Sprite();
    }
    public function get g():Graphics
    {
        return drawMe.graphics;
    }
    public function get s():Sprite
    {
        return drawMe;
    }

    
    public function fade():void
    {
        var result:Sprite = new Sprite();
        result.addChild(bmp);
        bmp.transform.colorTransform = new ColorTransform(
            Vars.redMulti,
            Vars.greenMulti, 
            Vars.blueMulti, 
            Vars.alphaMulti, 
            Vars.redOffset, 
            Vars.greenOffset, 
            Vars.blueOffset,
            Vars.alphaOffset
        );
        result.addChild(drawMe);
        bmpdata.draw(result);
        addChild(bmp);
        bmp.transform.colorTransform = new ColorTransform();        
    }
}