/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aHME
 */

// forked from Daisuke.Kobayashi's forked from: cameraをcolorTransformしてみる
// forked from umhr's cameraをcolorTransformしてみる
// forked from umhr's forked from: スナップショット
// forked from umhr's スナップショット
// forked from umhr's Camera 640*480
/*
 * Cameraクラス
 * http://help.adobe.com/ja_JP/AS3LCR/Flex_4.0/flash/media/Camera.html
 *
 * Videoクラス
 * http://help.adobe.com/ja_JP/AS3LCR/Flex_4.0/flash/media/Video.html
 * */
package {
    import flash.geom.ColorTransform;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import com.bit101.components.PushButton;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.SimpleButton;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.media.Camera;
    import flash.media.Video;
    public class Main extends Sprite {
        private var _video:Video;
        private var _bitmap:Bitmap;
        private var _lines:Sprite = new Sprite();
        private var _count:int = 0;
        public function Main() {
            var camera:Camera = Camera.getCamera();
            //カメラの存在を確認
            if (camera) {
                _bitmap = new Bitmap(new BitmapData(465,465));
                this.addChild(_bitmap);
                //this.addChild(_lines);
                camera.setMode(640, 480, 15);
                _video = new Video(640,480);
                _video.attachCamera(camera);
                _video.width = 160;
                _video.height = 120;
                this.addChild(_video);
                new PushButton(this, 0, 120, "Snap", atSnap);
            } else {
                trace("カメラが見つかりませんでした。");
            }
            
            var timer:Timer = new Timer(100);
            timer.addEventListener(TimerEvent.TIMER,onTimer);
            timer.start();
        }
        private function onTimer(event:TimerEvent):void{
            
            _bitmap.bitmapData.colorTransform(_bitmap.bitmapData.rect,
                new ColorTransform(1
                ,1,1,1,20,20,20)
            );
            
            _lines.graphics.clear();
            _lines.graphics.beginFill(0x000000,0.3);
            for (var i:int = 0; i < 120; i++) {
                _lines.graphics.drawRect(0,4*i + _count%6,465,2);
            }
            _bitmap.bitmapData.draw(_lines);
            _bitmap.bitmapData.draw(_video,null,null,BlendMode.HARDLIGHT);
            
            _count ++;
        }

        private function atSnap(event:MouseEvent):void {
            _bitmap.bitmapData.draw(_video);
        }
    }
}
