/**
 * Copyright meemeer ( http://wonderfl.net/user/meemeer )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aH8a
 */

// forked from meemeer's progression4 AMFCommand
/*

def get_wonderfl_code_rank_page

end

*/
/*
wonderfl code ranking
thumbnailをclickで各コードへ

http://wonderfl.net/code/7e242b3283f68af7e4b4f7e9b9819fad9733aecf
ページ移動の矢印お借りしました。
すみません。

http://5ivestar.org/blog/2008/12/wonderfl-webproxy/
proxy利用させて頂きました。
*/

package  
{
    import flash.events.*;
    import flash.net.*;
    import flash.system.Security;
    import flash.utils.*;
    import jp.progression.casts.*;
    import jp.progression.commands.lists.*;
    import jp.progression.commands.net.*;
	import jp.progression.config.BasicAppConfig;
	import jp.progression.debug.Debugger;
	
	[SWF(width="464", height="464",backgroundColor="#ffabcd",frameRate="30")]
	
	public class FlashTest extends CastDocument
	{
		
		public function FlashTest() 
		{
			super('index', IndexScene, new BasicAppConfig());
		}
		
		override protected function atReady():void
		{
			Debugger.addTarget(manager);
			
			manager.goto(manager.root.sceneId);
		}
		
	}

}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.net.*;
import flash.system.*;
import flash.system.Security;
import jp.progression.casts.*;
import jp.progression.casts.buttons.*;
import jp.progression.commands.display.*;
import jp.progression.commands.lists.*;
import jp.progression.commands.net.*;
import jp.progression.commands.tweens.*;
import jp.progression.commands.managers.Goto;
import jp.progression.commands.*;
import jp.progression.data.*;
import jp.progression.events.*;
import jp.progression.scenes.*;
import flash.events.MouseEvent;

class IndexScene extends SceneObject 
{
	private var page:Number;
	
	public function IndexScene()
	{
	}
	
	protected override function atSceneLoad():void
	{
		addCommand(
			//ページ数を取る
			function():void {
				//仮に１０
				page = 10;
			},
			function():void {
				//ページ数分sceneを作る
				for (var i:int = 1; i <= page; i++ ) {
					var scene:PageScene = new PageScene('Page' + i, { page_num:i } );
					addScene(scene);
				}
				
				var prevButton:ExPreviousButton = new ExPreviousButton( { x:50, y:50 } );
				var nextButton:ExNextButton = new ExNextButton( { x:420, y:50 } );
				prevButton.managerId = "index";
				nextButton.managerId = "index";
				prevButton.useTurnBack = true;
				nextButton.useTurnBack = true;
				
				new SerialList(null,
					new AddChildAt(container, prevButton, 99),
					new AddChildAt(container, nextButton, 100)
				).execute();
			}
		);
	}
	
	protected override function atSceneInit():void
	{
		manager.goto(getSceneAt(0).sceneId);
	}
}

class PageScene extends SceneObject
{
	private var page_num:int;
	private var model:Vector.<Model>;
	private var cast:PageCast;
	
	public function PageScene(name:String = null, initObject:Object = null):void
	{
		super(name, initObject);
		
		page_num = initObject.page_num;
		
		//Security.allowDomain("*");
		//Security.allowDomain("wonderfl.net");
		//Security.allowDomain("swf.wonderfl.net");
		Security.loadPolicyFile("http://5ivestar.org/proxy/crossdomain.xml");
	}
	
	protected override function atSceneLoad():void
	{
		var indicator:Indicator = new Indicator( { text:'amf connect...' } );
		
		addCommand(
			//ページのデータを取る
			new Amf('SampleController.get_wonderfl_code_rank_page',
				//都合の良い様にデータ加工
				function(res:Object):Vector.<Model> {
					var modelV:Vector.<Model> = new Vector.<Model>(res.length);
					res.forEach(function(o:Object, i:int, a:Array):void {
						var model:Model = new Model(o);
						
						modelV[i] = model;
					} );
					return modelV;
				}, {
					//待ち処理等
					onStart:function():void {
						trace('amf start');
						new SerialList(null,
							new AddChild(manager.root.container, indicator),
							new Prop(indicator, {
								x:(manager.root.container.stage.stageWidth - indicator.width) / 2,
								y:(manager.root.container.stage.stageHeight - indicator.height) / 2
							} )
						).execute();
					},
					onComplete:function():void {
						trace('amf end');
						new SerialList(null,
							new DoTweener(indicator, {
								alpha:0,
								time:.5
							} ),
							new RemoveChild(manager.root.container, indicator),
							function():void {
								indicator = null;
							}
						).execute();
					}
				},
				//ページ番号を渡す
				page_num
			),
			function():void {
				//何かをする
				var indicator:Indicator = new Indicator( { text:'image loading...' } );
				model = this.latestData;
				var lList:LoaderList = new LoaderList();
				model.forEach(function(m:Model, i:int, v:Vector.<Model>):void {
					var req:URLRequest = new URLRequest('http://5ivestar.org/proxy/' + m.src);
					var loader:LoadBitmapData = new LoadBitmapData(req);
					lList.addCommand(loader);
				} );
				lList.onStart = function():void {
					trace('load start');
					new SerialList(null,
						new AddChild(manager.root.container, indicator),
						new Prop(indicator, {
							x:(manager.root.container.stage.stageWidth - indicator.width) / 2,
							y:(manager.root.container.stage.stageHeight - indicator.height) / 2
						} )
					).execute();
				}
				lList.onComplete = function():void {
					trace('load end');
					new SerialList(null,
						new DoTweener(indicator, {
							alpha:0,
							time:.5
						} ),
						new RemoveChild(manager.root.container, indicator),
						function():void {
							indicator = null;
						}
					).execute();
				}
				insertCommand(lList);
			}
		);
	}
	
	protected override function atSceneInit():void
	{
		cast = new PageCast( { model:model } );
		addCommand(
			new AddChild(container, cast)
		);
	}
	
	protected override function atSceneGoto():void
	{
		addCommand(
			new RemoveChild(container, cast)
		);
	}
	
	protected override function atSceneUnload():void
	{
		addCommand(
			function():void {
				model.forEach(function(m:Model, i:int, v:Vector.<Model>):void {
					m.destroy();
				} );
				model.length = 0;
				model = null;
			}
		);
	}
}

class PageCast extends CastSprite
{
	private var model:Vector.<Model>;
	private var imageContainer:Sprite;
	private var imgWidth:int = 93;
	private var imgHeight:int = 93;
	private var imgOffset:int = 1;
	
	public function PageCast(initObject:Object = null):void
	{
		super(initObject);
		
		model = initObject.model;
	}
	
	protected override function atCastAdded():void
	{
		imageContainer = new Sprite();
		addCommand(	
			new AddChildAt(manager.root.container, imageContainer, 1),
			new Prop(imageContainer, {y:100} ),
			function():void {
				var count:int = 0;
				model.forEach(function(m:Model, i:int, v:Vector.<Model>):void {
					var bm:Bitmap = new Bitmap(getResourceById('http://5ivestar.org/proxy/' + m.src).toBitmapData());
					var button:CastButton = new CastButton();
					button.href = m.href;
					button.windowTarget = '_brank';
					new SerialList(null,
						new AddChild(button, bm),
						new AddChild(imageContainer, button),
						new Prop(button, {
							width:imgWidth-imgOffset,
							height:imgHeight-imgOffset,
							x:imgWidth * (count % 5) + imgOffset,
							y:imgHeight * Math.round(count / 5 - 0.5) + imgOffset
						} )
					).execute();
					count++;
				} );
			}
		);
	}
	
	protected override function atCastRemoved():void
	{
		addCommand(
			new RemoveChild(manager.root.container, imageContainer),
			function():void {
				imageContainer = null;
			}
		);
	}
}

class Model
{
	private var _href:String;
	public function get href():String { return _href; }
	
	private var _src:String;
	public function get src():String { return _src; }
	
	public function Model(data:Object)
	{
		this._href = data.href;
		this._src = data.src;
	}
	
	public function destroy():void
	{
		this._href = null;
		this._src = null;
	}
}

import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;
import flash.display.Sprite;
import flash.events.Event;
import jp.progression.casts.*;
import jp.progression.commands.display.*;
import jp.progression.commands.lists.*;
import jp.progression.commands.net.*;
import jp.progression.commands.tweens.*;
import jp.progression.commands.*;
import jp.progression.data.*;
import jp.progression.events.*;
import jp.progression.scenes.*;

class Indicator extends CastSprite 
{
	private var indicator:Sprite;
	private var numNeedles:uint = 12;
	private var innerR:Number = 15;
	private var outerR:Number = 5;
	private var cAngle:Number = -Math.PI / 2;
	private var nAngle:Number;
	private var text:String;
	
	private var tf:TextField;
	
	public function Indicator( initObject:Object = null ) 
	{
		indicator = new Sprite();
		tf = new TextField();
		text = initObject.text;
		
		super( initObject );
		
	}
	
	override protected function atCastAdded():void 
	{
		addCommand(
			new Func(makeIndicator),
			new Func(makeText),
			new AddChild(this, indicator),
			new AddChild(this, tf),
			new Func(function():void {
				indicator.addEventListener(Event.ENTER_FRAME, enterframeHandler, false, 0, true);
			} )
		);
	}
	
	override protected function atCastRemoved():void 
	{
		addCommand(
			new Func(function():void {
				indicator.removeEventListener(Event.ENTER_FRAME, enterframeHandler);
			} ),
			new RemoveChild(this, indicator),
			new RemoveChild(this, tf),
			new Func(removeText),
			new Func(removeIndicator)
		);
	}
	
	private function makeIndicator():void
	{
		nAngle = Math.PI * 2 / numNeedles;
		
		var cx:Number, cy:Number;
		for (var i:uint = 0; i < numNeedles; i++ ) {
			cAngle += nAngle;
			cx = Math.cos(cAngle) * innerR;
			cy = Math.sin(cAngle) * innerR;
			indicator.graphics.moveTo(cx, cy);
			
			cx = Math.cos(cAngle) * outerR;
			cy = Math.sin(cAngle) * outerR;
			indicator.graphics.lineStyle(2, 0x000000, i / numNeedles);
			indicator.graphics.lineTo(cx, cy);
		}

	}
	
	private function removeIndicator():void
	{
		indicator = null;
	}
	
	private function makeText():void
	{
		var fmt:TextFormat = new TextFormat();
		fmt.color = '0x555555';
		fmt.size = '16';
		tf.defaultTextFormat = fmt;
		tf.autoSize = TextFieldAutoSize.LEFT;
		tf.text = text;
		tf.x = -(tf.textWidth / 2);
		tf.y = 30;
	}
	
	private function removeText():void
	{
		tf = null;
	}
	
	private function enterframeHandler(e:Event):void
	{
		e.target.rotation = (e.target.rotation + 360 / e.target.stage.frameRate) % 360;
	}
	
}

class ExNextButton extends NextButton {
	public function ExNextButton(initObject:Object = null) {
		super(initObject);
		
		graphics.beginFill(0x000000);
		graphics.moveTo(-25,-15);
		graphics.lineTo(0,-15);
		graphics.lineTo(0,-25);
		graphics.lineTo(25,0);
		graphics.lineTo(0,25);
		graphics.lineTo(0,15);
		graphics.lineTo(-25,15);
		graphics.lineTo(-25,-15);
		graphics.endFill();
		
		buttonMode = true;
		useHandCursor = true;
		
	}
}

class ExPreviousButton extends PreviousButton {
	public function ExPreviousButton(initObject:Object = null) {
		super(initObject);
		
		graphics.beginFill(0x000000);
		graphics.moveTo(-25,0);
		graphics.lineTo(0,-25);
		graphics.lineTo(0,-15);
		graphics.lineTo(25,-15);
		graphics.lineTo(25,15);
		graphics.lineTo(0,15);
		graphics.lineTo(0,25);
		graphics.lineTo(-25,0);
		graphics.endFill();
		
		buttonMode = true;
		useHandCursor = true;
	}
}

import flash.events.Event;
import flash.net.Responder;
import jp.progression.casts.*;
import jp.progression.commands.display.*;
import jp.progression.commands.lists.*;
import jp.progression.commands.net.*;
import jp.progression.commands.tweens.*;
import jp.progression.commands.*;
import jp.progression.data.*;
import jp.progression.events.*;
import jp.progression.scenes.*;

/**
 * ...
 * @author m_emem
 */
class Amf extends Command 
{
	private var _amf:AmfConnect;
	private var _func:String;
	private var _args:Object;
	private var _callback:Function;
	
	/**
	 * 新しい AmfCommand インスタンスを作成します。
	 */
	public function Amf( func:String, callback:Function, initObject:Object = null, ... args:Array ) 
	{
		_func = func;
		_callback = callback;
		_args = args;
		
		// 親クラスを初期化します。
		super( _execute, _interrupt, initObject );
	}
	
	/**
	 * 実行されるコマンドの実装です。
	 */
	private function _execute():void 
	{
		_amf = AmfConnect.instance;
		_amf.dispatcher.addEventListener(Event.COMPLETE, _complete, false, 0, true);
		
		var params:Array = [_func, _callback];
		params.push.apply(params, _args);
		_amf.execute.apply(_amf, params);
		
		// 
		//executeComplete();
	}
	
	/**
	 * 中断されるコマンドの実装です。
	 */
	private function _interrupt():void 
	{
	}
	
	private function _complete(e:Event):void
	{
		_amf.dispatcher.removeEventListener(Event.COMPLETE, _complete);
		latestData = _amf.data;
		
		_amf.data = null;
		_func = null;
		_callback = null;
		_args = null;
		
		if (_amf.error != null) {
			super.throwError(this, new Error(_amf.error));
		} else {
			super.executeComplete();
		}
	}
	
	/**
	 * インスタンスのコピーを作成して、各プロパティの値を元のプロパティの値と一致するように設定します。
	 */
	public override function clone():Command 
	{
		return new Amf( _func, _callback, this, _args );
	}
}

import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.IEventDispatcher;
import flash.events.NetStatusEvent;
import flash.net.NetConnection;
import flash.net.ObjectEncoding;
import flash.net.Responder;

/**
 * ...
 * @author m_emem
 */
class AmfConnect
{
	private static var _instance:AmfConnect;
	public var dispatcher:IEventDispatcher;
	public var nc:NetConnection;
	public var error:Object;
	
	//private var gatewayUrl:String = 'http://localhost:13000/rubyamf/gateway';
	private var gatewayUrl:String = 'http://afternoon-spring-97.heroku.com/rubyamf/gateway';
	private var callback:Function;
	public var data:Object;
	
	public function AmfConnect() 
	{
		if (_instance === null) {
			_instance = this;
			init();
		} else {
			throw new Error('Singleton class');
		}
	}
	
	public static function get instance():AmfConnect
	{
		if (_instance === null) {
			_instance = new AmfConnect();
		}
		return _instance;
	}
	
	private function init():void
	{
		dispatcher = new EventDispatcher();
		error = null;
		
		nc = new NetConnection();
		nc.objectEncoding = ObjectEncoding.AMF3;
		nc.addEventListener(NetStatusEvent.NET_STATUS, onNetStatus);
		nc.connect(gatewayUrl);
	}
	
	private function onNetStatus(e:NetStatusEvent):void 
	{
		trace("Connection error, error code: (" +e.info.code + ")", "System message");
	}
	
	public function execute(_func:String, _callback:Function, ... _args:Array):void
	{
		callback = _callback;
		
		var params:Array = [_func, new Responder(onResultHandler, onFaultHandler)];
		params.push.apply(params, _args);
		nc.call.apply(nc, params);
	}
	
	private function onResultHandler(result:Object):void
	{
		if (callback != null) {
			data = callback.call(null, result);
		} else {
			data = result;
		}
		dispatcher.dispatchEvent(new Event(Event.COMPLETE));
	}
	
	private function onFaultHandler(fault:Object):void
	{
		data = fault;
		error = 'discription: ' + fault.description + ' code: ' + fault.code + ' details: ' + fault.details + ' level: ' + fault.level + ' line: ' + fault.line;
		dispatcher.dispatchEvent(new Event(Event.COMPLETE));
	}
	
}