/**
 * Copyright kaminaly ( http://wonderfl.net/user/kaminaly )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aGaO
 */

// forked from kaminaly's 振り子 Pendulum
package  
{
	import com.bit101.components.*;
	import flash.display.Sprite;
	import flash.events.Event;
	
	[SWF(frameRate="30", width="465", height="465")]
	/**
	 * ...
	 * @author kaminaly at SHIFTBRAIN
	 */
	public class Main extends Sprite 
	{
		static public var tracer:Text;
		private var furikoList:Array;
		private var furikoHolder:Sprite;
		
		public function Main() 
		{
			furikoList = [];
			furikoHolder = new Sprite();
			addChild(furikoHolder);
			
			var label:Label = new Label(this, 20, 465 - 50, "shift");
			var shiftLabel:Label = new Label(this, 60, 465 - 20, "10.0");
			var shift:HSlider = new HSlider(this, 20, 465 - 30, function():void { shiftLabel.text = shift.value.toFixed(1); } );
			shift.value = 10.0;
			
			label = new Label(this, 130, 465 - 50, "offset");
			var offsetLabel:Label = new Label(this, 170, 465 - 20, "70.0");
			var offset:HSlider = new HSlider(this, 130, 465 - 30, function():void { offsetLabel.text = offset.value.toFixed(1); } );
			offset.value = 70.0;
			
			label = new Label(this, 240, 465 - 50, "speed");
			var speedLabel:Label = new Label(this, 280, 465 - 20, "0.1");
			var speed:HSlider = new HSlider(this, 240, 465 - 30, function():void { speedLabel.text = speed.value.toFixed(3); } );
			speed.value = 0.1;
			speed.maximum = 2.0;
			
			label = new Label(this, 20, 465 - 50 - 40, "furiko num");
			var numLabel:Label = new Label(this, 60, 465 - 20 - 40, "36");
			var num:HSlider = new HSlider(this, 20, 465 - 30 - 40, function():void { numLabel.text = num.value.toFixed(0); } );
			num.value = 36;
			num.minimum = 1;
			
			label = new Label(this, 130, 465 - 50 - 40, "wave degree");
			var degreeLabel:Label = new Label(this, 170, 465 - 20 - 40, "80.0");
			var degree:HSlider = new HSlider(this, 130, 465 - 30 - 40, function():void { degreeLabel.text = degree.value.toFixed(1); } );
			degree.value = 80.0;
			degree.maximum = 90.0;
			
			//tracer = new Text(this, 20, 465 - 160);
			
			var button:PushButton = new PushButton(this, 350, 465 - 30, "create", function():void{create(int(num.value), shift.value, offset.value, speed.value, degree.value)});
			
			addEventListener(Event.ENTER_FRAME, update);
		}
		
		private function create(num:int, shift:Number, offset:Number, speed:Number, degree:Number):void
		{
			while(furikoHolder.numChildren){
				furikoHolder.removeChildAt(0);
			}
			
			var rad:Number = degree * Math.PI / 180;
			var startX:Number = Math.sin(rad) * offset;
			var furiko:Furiko;
			furikoList = [];
			for (var i:int = 0; i < num; i++) {
				furiko = new Furiko(num-i, i * shift + offset, speed, Math.asin(startX / (i * shift + offset)));
				furiko.x = stage.stageWidth * 0.5;
				furiko.y = 20;
				furikoList[furikoList.length] = furiko;
				furikoHolder.addChildAt(furiko, 0);
			}
		}
		
		private function update(e:Event):void
		{
			var l:int = furikoList.length;
			while (l--) {
				furikoList[l].update();
			}
		}
	}

}

import flash.display.Sprite;
class Furiko extends Sprite 
{
	private const PI2:Number = 2 * Math.PI;
	private const G:Number = 9.85960;
	
	private var _t:Number;
	private var _length:Number;
	private var _arc:Number;
	private var _speed:Number;
	private var _count:Number;
	
	public function Furiko(index:int, length:Number, speed:Number, degree:Number)
	{
		_length = length;
		_speed = speed;
		
		_arc = degree;//degree * PI2 / 360;
		//_t = /*PI2 * */Math.sqrt(_length / G);
		_t = (51 + index) / 60;
		
		_count = 0;
	}
	
	public function update():void
	{
		_count += _speed;
		
		//var rad:Number = _arc * Math.cos(/*PI2 * */_count / _t);
		var rad:Number = _arc * Math.cos(/*PI2 * */_count * _t);
		var dx:Number = Math.sin(rad) * _length;
		var dy:Number = Math.cos(rad) * _length;
		
		//draw
		graphics.clear();
		graphics.lineStyle(1, 0, 0.1);
		graphics.moveTo(0, 0);
		graphics.lineTo(dx, dy);
		
		graphics.lineStyle();
		graphics.beginFill(0);
		graphics.drawCircle(dx, dy, 5);
		graphics.endFill();
	}
}