/**
 * Copyright yabuchany ( http://wonderfl.net/user/yabuchany )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aGTg
 */

/**
 * Processingのサンプルをfrocessingで動くか試してみました。
 * Moving On Curves. 
 * 
 * In this example, the circles moves along the curve y = x^4.
 * Click the mouse to have it move to a new position.
 */

package {
	import frocessing.display.*;
	[SWF(width=465,height=465,frameRate="60")]
	public class Main extends F5MovieClip2DBmp{
		private var stage_width:Number  = 465;
		private var stage_height:Number = 465;
		private var beginX:Number = 20.0;   // Initial x-coordinate
		private var beginY:Number= 20.0;    // Initial y-coordinate
		private var endX:Number = 400;      // Final x-coordinate
		private var endY:Number = 400;      // Final y-coordinate
		private var distX:Number;           // X-axis distance to move
		private var distY:Number;           // Y-axis distance to move
		private var exponent:Number = 4;    // Determines the curve
		private var xx:Number  =0;          // Current x-coordinate
		private var yy:Number = 0;          // Current y-coordinate
		private var step:Number = 0.01;     // Size of each step along the path
		private var pct:Number = 0;         // Percentage traceled(0 to 1)
		
		
		public function Main() {
			super();
		}
		
		public function setup():void {
			size( stage_width, stage_height );
			noStroke();
			smooth();
			distX = endX-beginX;
			distY = endY-beginY;
		}
		
		public function draw():void {
			fill(0,2);
			rect(0,0,stage_width,stage_height);
			pct += step;
			if(pct<1.0){
				xx = beginX+(pct*distX);
				yy= beginY+(pow(pct,exponent)*distY);
			}
			fill(255);
			ellipse(xx,yy,50,50);
		}
		public function mousePressed():void{
			trace("mousePressed");
			pct = 0.0;
			beginX = xx;
			beginY = yy;
			endX=mouseX;
			endY=mouseY;
			distX = endX-beginX;
			distY=endY-beginY;
		}
	}
}