/**
 * Copyright codeonwort ( http://wonderfl.net/user/codeonwort )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aGQ1
 */

// forked from GreekFellows's Kalimba
package {
    import flash.media.SoundLoaderContext;
    import flash.utils.ByteArray;
    import flash.events.Event;
    import flash.media.SoundMixer; 
    import flash.media.SoundChannel;
    import flash.net.URLRequest;
    import flash.media.Sound;
    import flash.display.Sprite;
    public class Main extends Sprite {
        public var kalimba:Sound;
        public var soundchannel:SoundChannel;
        
        public var renderer:Renderer;
        public var core:Sprite;
        
        public function Main() {
            init();
        }
        
        public function init():void {
            this.x = 465 / 2;
            this.y = 465 / 2;
            
            core = new Sprite();
            core.y = 100;
            core.z = 0;
            this.addChild(core);
            
            renderer = new Renderer(this, core);
            
            kalimba = new Sound(new URLRequest("http://ia600601.us.archive.org/16/items/kalimba_687/Kalimba.mp3"), new SoundLoaderContext(0, true))
            soundchannel = kalimba.play();

            
            this.addEventListener(Event.ENTER_FRAME, go);
            soundchannel.addEventListener(Event.SOUND_COMPLETE, finish); 
        }
        
        public function go(e:Event):void {
            core.rotationY += mouseX / 50;
            
            var ba:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(ba, true);
            
            renderer.faces = [];
            
            for (var si:int = 0; si < 256; si++) {
                renderer.addBuilding(si % 16 * 40 - 320, (si - si % 16) / 16 * 40 - 320, 40, ba.readFloat() * 200, 10);
            }
            
            renderer.render();
        }
        
        public function finish(e:Event):void {
            this.removeEventListener(Event.ENTER_FRAME, go);
        }
    }
}

import flash.geom.Vector3D;
import flash.display.Sprite;

class Renderer {
    public const dist:int = 500;
    public const space:Number = 10;
    
    public var faces:Array;
    
    public var base:Sprite;
    public var core:Sprite;
    
    public function Renderer(base:Sprite, core:Sprite):void {
        this.base = base;
        this.core = core;
        
        faces = [];
    }
    
    public function addBuilding(bx:Number, by:Number, width:Number, height:Number, windowsize:Number):void {
        addFace(new Vector3D(bx - width / 2, -height, by - width / 2),
        new Vector3D(bx + width / 2, -height, by - width / 2),
        new Vector3D(bx - width / 2, 0, by - width / 2),
        new Vector3D(bx + width / 2, 0, by - width / 2),
        windowsize);
        
        addFace(new Vector3D(bx - width / 2, -height, by + width / 2),
        new Vector3D(bx + width / 2, -height, by + width / 2),
        new Vector3D(bx - width / 2, 0, by + width / 2),
        new Vector3D(bx + width / 2, 0, by + width / 2),
        windowsize);
        
        addFace(new Vector3D(bx - width / 2, -height, by - width / 2),
        new Vector3D(bx - width / 2, 0, by - width / 2),
        new Vector3D(bx - width / 2, -height, by + width / 2),
        new Vector3D(bx - width / 2, 0, by + width / 2),
        windowsize);
        
        addFace(new Vector3D(bx + width / 2, -height, by - width / 2),
        new Vector3D(bx + width / 2, 0, by - width / 2),
        new Vector3D(bx + width / 2, -height, by + width / 2),
        new Vector3D(bx + width / 2, 0, by + width / 2),
        windowsize);
       
        addFace(new Vector3D(bx - width / 2, -height, by - width / 2),
        new Vector3D(bx + width / 2, -height, by - width / 2),
        new Vector3D(bx - width / 2, -height, by + width / 2),
        new Vector3D(bx + width / 2, -height, by + width / 2),
        windowsize);
        
        addFace(new Vector3D(bx - width / 2, 0, by - width / 2),
        new Vector3D(bx + width / 2, 0, by - width / 2),
        new Vector3D(bx - width / 2, 0, by + width / 2),
        new Vector3D(bx + width / 2, 0, by + width / 2),
        windowsize);
    }
    
    public function addFace(v1:Vector3D, v2:Vector3D, v3:Vector3D, v4:Vector3D, windowsize:Number):void {
        faces.push({v1:v1, v2:v2, v3:v3, v4:v4, vc:new Vector3D((v1.x + v2.x + v3.x + v4.x) / 4, (v1.y + v2.y + v3.y + v4.y) / 4, (v1.z + v2.z + v3.z + v4.z) / 4), size:windowsize});
    }
    
    public function render():void {
        var sorted:Array = [];
        
        base.graphics.clear();
        
        for (var i:int = 0; i < faces.length; i++) {
            var v1:Vector3D = faces[i].v1.clone();
            var v2:Vector3D = faces[i].v2.clone();
            var v3:Vector3D = faces[i].v3.clone();
            var v4:Vector3D = faces[i].v4.clone();
            var vc:Vector3D = faces[i].vc.clone();
            
            v1 = core.transform.matrix3D.transformVector(v1);
            v2 = core.transform.matrix3D.transformVector(v2);
            v3 = core.transform.matrix3D.transformVector(v3);
            v4 = core.transform.matrix3D.transformVector(v4);
            vc = core.transform.matrix3D.transformVector(vc);
            
            v1.w = (v1.z + dist) / dist;
            v2.w = (v2.z + dist) / dist;
            v3.w = (v3.z + dist) / dist;
            v4.w = (v4.z + dist) / dist;
            
            v1.project();
            v2.project();
            v3.project();
            v4.project();
            
            sorted.push( { v1:v1, v2:v2, v3:v3, v4:v4, z:vc.z, size:faces[i].size } );
        }
        
        sorted.sortOn("z", Array.NUMERIC | Array.DESCENDING);
        
        for (var di:int = 0; di < sorted.length; di++) {
            base.graphics.beginFill(0xffffff, 1);
            base.graphics.moveTo(sorted[di].v1.x, sorted[di].v1.y);
            base.graphics.lineTo(sorted[di].v2.x, sorted[di].v2.y);
            base.graphics.lineTo(sorted[di].v4.x, sorted[di].v4.y);
            base.graphics.lineTo(sorted[di].v3.x, sorted[di].v3.y);
            base.graphics.lineTo(sorted[di].v1.x, sorted[di].v1.y);
            base.graphics.endFill();
            
            base.graphics.beginFill(0x000000, (sorted[di].z + 300) / 500);
            base.graphics.moveTo(sorted[di].v1.x, sorted[di].v1.y);
            base.graphics.lineTo(sorted[di].v2.x, sorted[di].v2.y);
            base.graphics.lineTo(sorted[di].v4.x, sorted[di].v4.y);
            base.graphics.lineTo(sorted[di].v3.x, sorted[di].v3.y);
            base.graphics.lineTo(sorted[di].v1.x, sorted[di].v1.y);
            base.graphics.endFill();
        }
    }
}