/**
 * Copyright nolabs ( http://wonderfl.net/user/nolabs )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aFVC
 */

// forked from nolabs's forked from: forked from: Basic Transform
// forked from imajuk's forked from: Basic Transform
// forked from imajuk's Basic Transform
package  
{
	import flash.filters.BlurFilter;
	import flash.display.PixelSnapping;
	import flash.events.MouseEvent;
	import flash.geom.Rectangle;
	import flash.display.BlendMode;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.geom.Point;
	import flash.events.Event;
	import flash.display.Sprite;

	[SWF(backgroundColor="#000000")]

	public class Main extends Sprite
	{
		private var time:Number = 0;
		private var point:Point = new Point();
		private var speed:Number = 6000;
		private var band:Number = 50;

		public function Main() 
		{
			stage.frameRate = 60;

			//キャンバス
			var canvas:BitmapData = new BitmapData(500, 400, false, 0);
			var fade:BitmapData = new BitmapData(500, 400, true, 0x09000000);
			var r:Rectangle = fade.rect;
			addChild(new Bitmap(canvas, PixelSnapping.AUTO, false));
			
			var rect:Rect = new Rect();
			rect.translate(120, 150);
			
			stage.addEventListener(MouseEvent.MOUSE_MOVE, function(event:MouseEvent):void
			{
				speed = event.stageY / 400 * 4000 + 3000;
				band = event.stageX / 500 * 50;
			});
			
			addEventListener(Event.ENTER_FRAME, function():void
			{
				time += .01;
				
				var sin:Number = Math.sin(time);
				var cos:Number = Math.cos(time); 
				
				//角の丸み
				rect.round = Math.abs(cos) * 100;
				//トランスフォームの原点を移動
				var center:Point = new Point(cos * band + 50, sin * band + 50);
				rect.setOrigin(center);
				//回転
				DisplayObjectUtil.rotate(rect, center, MathUtil.degreesToRadians(-time * speed));
				//拡大・縮小
				var scale:Number = Math.abs(sin) + .3;
				DisplayObjectUtil.scale(rect, center, scale, scale);
				/**
				 * 誤差補正 
				 * Matrixによるトランスフォームはどうしても100分の1ピクセル単位の誤差が出てしまうためここで補正.
				 * もっといい方法はないだろうか？
				 */
				rect.revisePosition();
				
				//キャンバスに描画
				canvas.lock();
				canvas.draw(rect, rect.transform.matrix, null, BlendMode.ADD);
				canvas.applyFilter(canvas, r, point, new BlurFilter(1.5, 1.5));
				canvas.copyPixels(fade, r, point);
				canvas.unlock();
			});
		}
	}
}

import flash.geom.Matrix;
import flash.display.DisplayObject;
import flash.geom.Point;
import flash.display.Graphics;
import flash.display.Sprite;

class Rect extends Sprite
{
	private var size:Number = 120;
	private var clickedLocal:Point = new Point(size * .5, size * .5);

	
	private var clickedGlobal:Point = center;

	
	public function get center():Point
	{
		return localToGlobal(clickedLocal);
	}

	private var _round:Number = 4;

	public function set round(round:Number):void
	{
		_round = round;
		draw(getColor());
	}

	public function Rect() 
	{
		draw(getColor());
	}

	private function getColor():Number
	{
		return Math.random() * 0xFFFFFF;
	}

	public function setOrigin(local:Point):void
	{
		clickedLocal = local;
		clickedGlobal = localToGlobal(local);
		draw(getColor());
	}

	public function translate(tx:Number, ty:Number):void
	{
		x = tx;
		y = ty;
		clickedLocal.add(new Point(tx, ty));
		clickedGlobal = center;	
	}

	private function draw(color:Number):void
	{
		graphics.clear();
		drawShape(size, color);
	}

	private function drawShape(size:Number, color:uint):void
	{
		var g:Graphics = graphics;
		g.lineStyle(1, color);
		g.beginFill(color, .1);
		g.drawRoundRectComplex(0, 0, size, size, _round, _round, _round, _round);
		g.endFill();
	}

	public function revisePosition():void
	{
		var p1:Point = clickedGlobal; 
		var p2:Point = center;
		var dx:Number = p1.x - p2.x; 
		var dy:Number = p1.y - p2.y; 
		x += dx; 
		y += dy;
	}
}

class DisplayObjectUtil
{
	/**
	 * 対象となるDisplayObjectを、任意の点を原点として回転させます.
	 * @param target    対象となるDisplayObject
	 * @param origin    回転の中心となるグローバル座標
	 * @param radians   新しい角度.これは絶対値です.
	 */
	public static function rotate(target:DisplayObject, origin:Point, radians:Number):void
	{
		var m:Matrix = target.transform.matrix;
		var x:Number = origin.x;
		var y:Number = origin.y;
		m.concat(new Matrix(1, 0, 0, 1, -x, -y));
		m.rotate(radians - MathUtil.degreesToRadians(target.rotation));
		m.concat(new Matrix(1, 0, 0, 1, x, y));
		target.transform.matrix = m;
	}

	/**
	 * 対象となるDisplayObjectを、任意の点を原点として拡大・縮小させます.
	 * @param target    対象となるDisplayObject
	 * @param origin    拡大・縮小の中心となるグローバル座標
	 * @param scaleX   新しいスケールX.これは絶対値です.
	 * @param scaleY   新しいスケールY.これは絶対値です.
	 */
	public static function scale(target:DisplayObject, origin:Point, scaleX:Number, scaleY:Number):void
	{
		var m:Matrix = target.transform.matrix;
		var x:Number = origin.x;
		var y:Number = origin.y;
		m.concat(new Matrix(1, 0, 0, 1, -x, -y));
		m.scale(1 / target.scaleX, 1 / target.scaleY);
		m.scale(scaleX, scaleY);
		m.concat(new Matrix(1, 0, 0, 1, x, y));
		target.transform.matrix = m;
	}
}

class MathUtil
{
	private static const PI:Number = Math.PI;

	/**
	 * 渡された任意の角度をラジアンに変換します.
	 * 
	 * @param degrees　ラジアンに変換したい角度を渡します.
	 * @return 角度からラジアンに変換された値を返します.
	 */
	public static function degreesToRadians(degrees:Number):Number 
	{
		return degrees * PI / 180;
	}
}
